/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.util;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayImageDescriptor
extends CompositeImageDescriptor {
    private final int DEFAULT_IMAGE_WIDTH = 16;
    private final int DEFAULT_IMAGE_HEIGHT = 16;
    private int imageWidth = 16;
    private int imageHeight = 16;
    private Image srcImage = null;
    private ImageDescriptor overlayDesc = null;

    public OverlayImageDescriptor(Image srcImage, ImageDescriptor overlayDesc) {
        assert (srcImage != null);
        assert (overlayDesc != null);
        this.srcImage = srcImage;
        this.overlayDesc = overlayDesc;
    }

    public OverlayImageDescriptor(Image srcImage, ImageDescriptor overlayDesc, int width, int height) {
        this(srcImage, overlayDesc);
        this.imageWidth = width;
        this.imageHeight = height;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData overlayData;
        ImageData backgroundData = this.srcImage.getImageData();
        if (backgroundData != null) {
            this.drawImage(backgroundData, 0, 0);
        }
        if ((overlayData = this.overlayDesc.getImageData()) != null) {
            this.drawImage(overlayData, 0, 0);
        }
    }

    protected Point getSize() {
        return new Point(this.imageWidth, this.imageHeight);
    }
}

