/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.TerminalEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.TerminalOwnerShapeEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editpolicies.ContainerHighlightEditPolicy;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.BottomTerminalFigure;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.CircuitFigure;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.LogicColorConstants;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.TerminalFigure;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.TopTerminalFigure;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.InputTerminal;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Terminal;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

public class CircuitEditPart
extends TerminalOwnerShapeEditPart {
    public CircuitEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ContainerHighlightEditPolicy());
    }

    protected NodeFigure createMainFigure() {
        CircuitFigure nf = new CircuitFigure(new Dimension(this.getMapMode().DPtoLP(100), this.getMapMode().DPtoLP(100)));
        ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
        nf.setLayoutManager((LayoutManager)layout);
        return nf;
    }

    public Map createBoundsMap() {
        HashMap<String, Point> posMap = new HashMap<String, Point>();
        IMapMode mm = this.getMapMode();
        posMap.put("A", new Point(mm.DPtoLP(11), mm.DPtoLP(-1)));
        posMap.put("B", new Point(mm.DPtoLP(36), mm.DPtoLP(-1)));
        posMap.put("C", new Point(mm.DPtoLP(61), mm.DPtoLP(-1)));
        posMap.put("D", new Point(mm.DPtoLP(86), mm.DPtoLP(-1)));
        posMap.put("1", new Point(mm.DPtoLP(11), mm.DPtoLP(100)));
        posMap.put("2", new Point(mm.DPtoLP(36), mm.DPtoLP(100)));
        posMap.put("3", new Point(mm.DPtoLP(61), mm.DPtoLP(100)));
        posMap.put("4", new Point(mm.DPtoLP(86), mm.DPtoLP(100)));
        return posMap;
    }

    public NodeFigure createOwnedTerminalFigure(TerminalEditPart terminalEP) {
        Terminal terminal = (Terminal)ViewUtil.resolveSemanticElement((View)((View)terminalEP.getModel()));
        if (terminal == null) {
            return null;
        }
        TerminalFigure theFigure = null;
        int side = 1;
        if (terminal instanceof InputTerminal) {
            theFigure = new TopTerminalFigure(terminal.getId(), new Dimension(this.getMapMode().DPtoLP(6), this.getMapMode().DPtoLP(7)));
        } else {
            theFigure = new BottomTerminalFigure(terminal.getId(), new Dimension(this.getMapMode().DPtoLP(6), this.getMapMode().DPtoLP(7)));
            side = 4;
        }
        terminalEP.setLocator(new TerminalFigure.TerminalLocator(this.getFigure(), new Dimension(this.getMapMode().DPtoLP(100), this.getMapMode().DPtoLP(100)), side));
        return theFigure;
    }

    public Object getPreferredValue(EStructuralFeature feature) {
        if (feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
            return FigureUtilities.colorToInteger((Color)LogicColorConstants.logicGreen);
        }
        if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor()) {
            return FigureUtilities.colorToInteger((Color)LogicColorConstants.connectorGreen);
        }
        return super.getPreferredValue(feature);
    }
}

