/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.render.editparts;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gmf.runtime.diagram.ui.render.editparts.AbstractImageEditPart;
import org.eclipse.gmf.runtime.diagram.ui.render.editparts.AbstractImageEditPartTests;
import org.eclipse.gmf.runtime.diagram.ui.render.editparts.URLImageEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.TestsPlugin;
import org.osgi.framework.Bundle;

public class URLImageEditPartTests
extends AbstractImageEditPartTests {
    private String TEST2 = "test2.emf";
    private String TEST3 = "test3.jpg";
    private String TEST4 = "test4.gif";
    private String TEST5 = "test5.bmp";
    private String TEST6 = "test6.svg";
    private String TEST7 = "test7.txt";
    private String TEST8 = "test8.doc";
    private String TEST9 = "test9.xls";
    private String TEST10 = "nofile.xxx";
    private static final String TRANSLATE_PATH_ARGUMENT = "$nl$";
    private static final String IMAGES = "images";

    public static Test suite() {
        TestSuite suite = new TestSuite("Test for org.eclipse.gmf.tests.runtime.diagram.ui.internal.editparts");
        suite.addTestSuite(URLImageEditPartTests.class);
        return suite;
    }

    protected String getImagePathName() {
        return "images/";
    }

    private URL getURL(String fileName) {
        IPath path = new Path(TRANSLATE_PATH_ARGUMENT).append(String.valueOf(this.getImagePathName()) + fileName);
        return FileLocator.find((Bundle)TestsPlugin.getDefault().getBundle(), (IPath)path, null);
    }

    public List getFixtures() {
        ArrayList<URLImageEditPartFixture1> fixtures = new ArrayList<URLImageEditPartFixture1>(6);
        fixtures.add(new URLImageEditPartFixture1((View)this.getNode(), this.getURL(this.TEST2)));
        fixtures.add(new URLImageEditPartFixture1((View)this.getNode(), this.getURL(this.TEST3)));
        fixtures.add(new URLImageEditPartFixture1((View)this.getNode(), this.getURL(this.TEST4)));
        fixtures.add(new URLImageEditPartFixture1((View)this.getNode(), this.getURL(this.TEST5)));
        fixtures.add(new URLImageEditPartFixture1((View)this.getNode(), this.getURL(this.TEST6)));
        return fixtures;
    }

    protected List getNonImageFixtures() {
        ArrayList<URLImageEditPartFixture1> nonImageFixtures = new ArrayList<URLImageEditPartFixture1>(3);
        nonImageFixtures.add(new URLImageEditPartFixture1((View)this.getNode(), this.getURL(this.TEST7)));
        nonImageFixtures.add(new URLImageEditPartFixture1((View)this.getNode(), this.getURL(this.TEST8)));
        nonImageFixtures.add(new URLImageEditPartFixture1((View)this.getNode(), this.getURL(this.TEST9)));
        nonImageFixtures.add(new URLImageEditPartFixture1((View)this.getNode(), this.getURL(this.TEST10)));
        nonImageFixtures.add(new URLImageEditPartFixture1((View)this.getNode(), null));
        return nonImageFixtures;
    }

    public void test_regenerateImageFromSource() {
        List fixtures = this.getFixtures();
        ListIterator li = fixtures.listIterator();
        int testno = 1;
        while (li.hasNext()) {
            Object obj = li.next();
            if (!(obj instanceof AbstractImageEditPart)) continue;
            URLImageEditPartFixture1 fixture = (URLImageEditPartFixture1)((Object)obj);
            RenderedImage renderedImage = fixture.regenerateImageFromSourceTest();
            this.verifyRenderedImage(renderedImage, testno++);
        }
    }

    public void test_regenerateImageFromSource_InvalidSource() {
        List fixtures = this.getNonImageFixtures();
        ListIterator li = fixtures.listIterator();
        int testno = 1;
        while (li.hasNext()) {
            Object obj = li.next();
            if (!(obj instanceof AbstractImageEditPart)) continue;
            URLImageEditPartFixture1 fixture = (URLImageEditPartFixture1)((Object)obj);
            RenderedImage renderedImage = fixture.regenerateImageFromSourceTest();
            URLImageEditPartTests.assertNull((String)("Non image file was rendered to an image? " + new Integer(testno++).toString()), (Object)(renderedImage == null ? renderedImage : renderedImage.getSWTImage()));
        }
    }

    class URLImageEditPartFixture1
    extends URLImageEditPart {
        private URL url;

        public URLImageEditPartFixture1(View view, URL url) {
            super(view);
            this.url = url;
        }

        protected URL getURL() {
            if (this.url == null) {
                return super.getURL();
            }
            return this.url;
        }

        protected String getImagePath() {
            return null;
        }

        protected String getPathImagePathIsRelativeTo() {
            return null;
        }

        public RenderedImage regenerateImageFromSourceTest() {
            return super.regenerateImageFromSource();
        }
    }
}

