/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.codegen.util;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.jet.JETCompiler;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.codegen.util.GIFEmitter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.common.UnexpectedBehaviourException;
import org.eclipse.gmf.internal.common.codegen.BinaryEmitter;
import org.eclipse.gmf.internal.common.codegen.DefaultTextMerger;
import org.eclipse.gmf.internal.common.codegen.JETGIFEmitterAdapter;
import org.eclipse.gmf.internal.common.codegen.TextEmitter;
import org.eclipse.gmf.internal.common.codegen.TextMerger;
import org.eclipse.gmf.internal.common.codegen.XpandTextEmitter;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.util.BundleResourceManager;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodegenEmitters {
    private static final String PATH_SEPARATOR = "::";
    private final ResourceManager myResourceManager;
    private final URL[] myLocations;
    private Map<String, Object> myGlobals;

    public CodegenEmitters(boolean useBaseTemplatesOnly, String templateDirectory, boolean includeDynamicModelTemplates) {
        ArrayList<URL> urls = new ArrayList<URL>(5);
        if (!useBaseTemplatesOnly) {
            urls.add(CodegenEmitters.getDynamicTemplatesURL(templateDirectory));
        }
        if (includeDynamicModelTemplates) {
            urls.add(CodegenEmitters.getTemplatesBundle().getEntry("/templates-dynmodel/"));
        }
        urls.add(CodegenEmitters.getTemplatesBundle().getEntry("/templates/"));
        this.myLocations = urls.toArray(new URL[urls.size()]);
        this.myResourceManager = new BundleResourceManager(this.myLocations);
    }

    void setGlobals(Map<String, Object> globals) {
        this.myGlobals = globals;
    }

    public TextMerger createMergeService() {
        URL controlFile = this.getJMergeControlFile();
        if (controlFile != null) {
            JControlModel controlModel = new JControlModel();
            controlModel.initialize(CodeGenUtil.instantiateFacadeHelper((String)JMerger.DEFAULT_FACADE_HELPER_CLASS), controlFile.toString());
            if (!controlModel.canMerge()) {
                throw new IllegalStateException("Can not initialize JControlModel");
            }
            return new DefaultTextMerger(controlModel);
        }
        return null;
    }

    private static Bundle getTemplatesBundle() {
        return Platform.getBundle((String)"org.eclipse.gmf.codegen");
    }

    private static URL getDynamicTemplatesURL(String templateDirectory) {
        if (templateDirectory != null) {
            URI templatesURI = templateDirectory.indexOf(":") == -1 ? URI.createPlatformResourceURI((String)templateDirectory, (boolean)true) : URI.createURI((String)templateDirectory);
            try {
                return new URL(templatesURI.toString());
            }
            catch (MalformedURLException e) {
                Platform.getLog((Bundle)CodegenEmitters.getTemplatesBundle()).log((IStatus)new Status(4, CodegenEmitters.getTemplatesBundle().getSymbolicName(), 0, "Incorrecct dynamic templates location", (Throwable)e));
            }
        }
        return null;
    }

    public URL getJMergeControlFile() {
        return CodegenEmitters.getTemplatesBundle().getEntry("/templates/emf-merge.xml");
    }

    public TextEmitter getCreateNodeCommandEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::commands::CreateNodeCommand");
    }

    public TextEmitter getCreateLinkCommandEmitter() throws UnexpectedBehaviourException {
        return this.newXpandEmitter("xpt::diagram::commands::CreateLinkCommand::Main");
    }

    public TextEmitter getReorientLinkCommandEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::commands::ReorientLinkCommand");
    }

    public TextEmitter getReorientRefLinkCommandEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::commands::ReorientRefLinkCommand");
    }

    public TextEmitter getReorientLinkViewCommandEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::commands::ReorientLinkViewCommand");
    }

    public TextEmitter getCreateShortcutDecorationsCommandEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::commands::CreateShortcutDecorationsCommand");
    }

    public TextEmitter getBaseEditHelperEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::edithelpers::BaseEditHelper");
    }

    public TextEmitter getEditHelperEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::edithelpers::EditHelper");
    }

    public TextEmitter getEditHelperAdviceEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::edithelpers::EditHelperAdvice");
    }

    public TextEmitter getDiagramEditPartEmitter() throws UnexpectedBehaviourException {
        return this.getMainEmitter("diagram::editparts::DiagramEditPart");
    }

    public TextEmitter getNodeEditPartEmitter() throws UnexpectedBehaviourException {
        return this.getMainEmitter("diagram::editparts::NodeEditPart");
    }

    public TextEmitter getNodeLabelEditPartEmitter() throws UnexpectedBehaviourException {
        return this.getMainEmitter("diagram::editparts::NodeLabelEditPart");
    }

    public TextEmitter getExternalNodeLabelEditPartEmitter() throws UnexpectedBehaviourException {
        return this.getMainEmitter("diagram::editparts::ExternalNodeLabelEditPart");
    }

    public TextEmitter getChildNodeLabelEditPartEmitter() throws UnexpectedBehaviourException {
        return this.getMainEmitter("diagram::editparts::ChildNodeLabelEditPart");
    }

    public TextEmitter getCompartmentEditPartEmitter() throws UnexpectedBehaviourException {
        return this.getMainEmitter("diagram::editparts::CompartmentEditPart");
    }

    public TextEmitter getLinkEditPartEmitter() throws UnexpectedBehaviourException {
        return this.getMainEmitter("diagram::editparts::LinkEditPart");
    }

    public TextEmitter getLinkLabelEditPartEmitter() throws UnexpectedBehaviourException {
        return this.getMainEmitter("diagram::editparts::LinkLabelEditPart");
    }

    public TextEmitter getEditPartFactoryEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::editparts::EditPartFactory");
    }

    public TextEmitter getBaseItemSemanticEditPolicyEmitter() {
        return this.getPrimaryEmitter("xpt::diagram::editpolicies::BaseItemSemanticEditPolicy");
    }

    public TextEmitter getOpenDiagramEditPolicyEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::editpolicies::OpenDiagram");
    }

    public TextEmitter getDiagramCanonicalEditPolicyEmitter() {
        return this.getPrimaryEmitter("xpt::diagram::editpolicies::DiagramCanonicalEditPolicy");
    }

    public TextEmitter getChildContainerCanonicalEditPolicyEmitter() {
        return this.getPrimaryEmitter("xpt::diagram::editpolicies::ChildContainerCanonicalEditPolicy");
    }

    public TextEmitter getDiagramItemSemanticEditPolicyEmitter() {
        return this.getPrimaryEmitter("xpt::diagram::editpolicies::DiagramItemSemanticEditPolicy");
    }

    public TextEmitter getCompartmentItemSemanticEditPolicyEmitter() {
        return this.getPrimaryEmitter("xpt::diagram::editpolicies::CompartmentItemSemanticEditPolicy");
    }

    public TextEmitter getGraphicalNodeEditPolicyEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::editpolicies::GraphicalNodeEditPolicy");
    }

    public TextEmitter getNodeItemSemanticEditPolicyEmitter() {
        return this.getPrimaryEmitter("xpt::diagram::editpolicies::NodeItemSemanticEditPolicy");
    }

    public TextEmitter getLinkItemSemanticEditPolicyEmitter() {
        return this.getPrimaryEmitter("xpt::diagram::editpolicies::LinkItemSemanticEditPolicy");
    }

    public TextEmitter getTextSelectionEditPolicyEmitter() throws UnexpectedBehaviourException {
        return this.newXpandEmitter("xpt::diagram::editpolicies::TextFeedback::TextSelectionEditPolicy");
    }

    public TextEmitter getTextNonResizableEditPolicyEmitter() throws UnexpectedBehaviourException {
        return this.newXpandEmitter("xpt::diagram::editpolicies::TextFeedback::TextNonResizableEditPolicy");
    }

    public TextEmitter getDiagramUpdaterEmitter() {
        return this.getPrimaryEmitter("xpt::diagram::updater::DiagramUpdater");
    }

    public TextEmitter getUpdateCommandEmitter() {
        return this.getPrimaryEmitter("xpt::diagram::updater::UpdateCommand");
    }

    public TextEmitter getNodeDescriptorEmitter() {
        return this.getPrimaryEmitter("xpt::diagram::updater::NodeDescriptor");
    }

    public TextEmitter getLinkDescriptorEmitter() {
        return this.getPrimaryEmitter("xpt::diagram::updater::LinkDescriptor");
    }

    public TextEmitter getAbstractParserEmitter() throws UnexpectedBehaviourException {
        return this.newXpandEmitter("impl::parsers::AbstractParser::Main");
    }

    public String getAbstractParserName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("impl::parsers::AbstractParser", input);
    }

    public TextEmitter getPredefinedParserEmitter() throws UnexpectedBehaviourException {
        return this.newXpandEmitter("parsers::PredefinedParser::Main");
    }

    public TextEmitter getCustomParserEmitter() throws UnexpectedBehaviourException {
        return this.newXpandEmitter("parsers::CustomParser::Main");
    }

    public TextEmitter getParserProviderEmitter() throws UnexpectedBehaviourException {
        return this.newXpandEmitter("parsers::ParserProvider::Main");
    }

    public TextEmitter getElementInitializersEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::providers::ElementInitializers");
    }

    public TextEmitter getElementTypesEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::providers::ElementTypes");
    }

    public TextEmitter getViewProviderEmitter() {
        return this.getPrimaryEmitter("xpt::providers::ViewProvider");
    }

    public TextEmitter getEditPartProviderEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::providers::EditPartProvider");
    }

    public TextEmitter getModelingAssistantProviderEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::providers::ModelingAssistantProvider");
    }

    public TextEmitter getIconProviderEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::providers::IconProvider");
    }

    public TextEmitter getMarkerNavigationProviderEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::providers::MarkerNavigationProvider");
    }

    public TextEmitter getValidationProviderEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::providers::ValidationProvider");
    }

    public TextEmitter getValidationDecoratorProviderEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::providers::ValidationDecoratorProvider");
    }

    public TextEmitter getShortcutsDecoratorProviderEmitter() {
        return this.getPrimaryEmitter("xpt::providers::ShortcutsDecoratorProvider");
    }

    public TextEmitter getMetricProviderEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::providers::MetricProvider");
    }

    public TextEmitter getAbstractExpressionEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::expressions::AbstractExpression");
    }

    public TextEmitter getOCLExpressionFactoryEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::expressions::OCLExpressionFactory");
    }

    public TextEmitter getRegexpExpressionFactoryEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::expressions::RegexpExpressionFactory");
    }

    public TextEmitter getPropertySheetLabelProviderEmitter() throws UnexpectedBehaviourException {
        return this.newXpandEmitter("xpt::propsheet::LabelProvider::Class");
    }

    public TextEmitter getPropertySectionEmitter() throws UnexpectedBehaviourException {
        return this.newXpandEmitter("xpt::propsheet::PropertySection::Class");
    }

    public TextEmitter getValidateActionEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::editor::ValidateAction");
    }

    public String getValidateActionName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("xpt::editor::ValidateAction", input);
    }

    public TextEmitter getValidationMarkerEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::editor::ValidationMarker");
    }

    public String getValidationMarkerName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("xpt::editor::ValidationMarker", input);
    }

    public TextEmitter getDiagramContentInitializerEmitter() {
        return this.getPrimaryEmitter("xpt::editor::DiagramContentInitializer");
    }

    public TextEmitter getShortcutPropertyTesterEmitter() {
        return this.getPrimaryEmitter("xpt::editor::ShortcutPropertyTester");
    }

    public String getShortcutCreationWizardName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("xpt::editor::ShortcutCreationWizard", input);
    }

    public TextEmitter getShortcutCreationWizardEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::editor::ShortcutCreationWizard");
    }

    public String getModelElementSelectionPageName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("xpt::editor::ModelElementSelectionPage", input);
    }

    public TextEmitter getModelElementSelectionPageEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::editor::ModelElementSelectionPage");
    }

    public String getNewDiagramFileWizardName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("xpt::editor::NewDiagramFileWizard", input);
    }

    public TextEmitter getNewDiagramFileWizardEmitter() {
        return this.getPrimaryEmitter("xpt::editor::NewDiagramFileWizard");
    }

    public TextEmitter getPaletteEmitter() throws UnexpectedBehaviourException {
        return this.newXpandEmitter("xpt::editor::palette::PaletteFactory::Factory");
    }

    public TextEmitter getDiagramEditorUtilEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::editor::DiagramEditorUtil");
    }

    public TextEmitter getVisualIDRegistryEmitter() {
        return this.getPrimaryEmitter("xpt::editor::VisualIDRegistry");
    }

    public TextEmitter getCreationWizardEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::editor::CreationWizard");
    }

    public TextEmitter getCreationWizardPageEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::editor::CreationWizardPage");
    }

    public TextEmitter getDeleteElementActionEmitter() {
        return this.getPrimaryEmitter("xpt::editor::DeleteElementAction");
    }

    public String getDeleteElementActionName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("xpt::editor::DeleteElementAction", input);
    }

    public TextEmitter getDiagramEditorContextMenuProviderEmitter() {
        return this.getPrimaryEmitter("xpt::editor::DiagramEditorContextMenuProvider");
    }

    public String getDiagramEditorContextMenuProviderName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("xpt::editor::DiagramEditorContextMenuProvider", input);
    }

    public TextEmitter getEditorEmitter() {
        return this.getPrimaryEmitter("xpt::editor::Editor");
    }

    public TextEmitter getElementChooserEmitter() {
        return this.getPrimaryEmitter("xpt::editor::ElementChooser");
    }

    public TextEmitter getDocumentProviderEmitter() {
        return this.getPrimaryEmitter("xpt::editor::DocumentProvider");
    }

    public TextEmitter getActionBarContributorEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::editor::ActionBarContributor");
    }

    public TextEmitter getMatchingStrategyEmitter() {
        return this.getPrimaryEmitter("xpt::editor::MatchingStrategy");
    }

    public TextEmitter getURIEditorInputTesterEmitter() {
        return this.getPrimaryEmitter("xpt::editor::UriEditorInputTester");
    }

    public BinaryEmitter getShortcutImageEmitter() throws UnexpectedBehaviourException {
        return this.newGIFEmitter("/xpt/editor/shortcut.gif");
    }

    public BinaryEmitter getDiagramIconEmitter() throws UnexpectedBehaviourException {
        return this.newGIFEmitterAdapter("/xpt/editor/diagram.gif");
    }

    public BinaryEmitter getWizardBannerImageEmitter() throws UnexpectedBehaviourException {
        return this.newGIFEmitterAdapter("/xpt/editor/wizban.gif");
    }

    public TextEmitter getModelAccessFacilityEmitter() {
        return this.newXpandEmitter("Facility::Main");
    }

    public TextEmitter getNavigatorContentProviderEmitter() {
        return this.getPrimaryEmitter("xpt::navigator::NavigatorContentProvider");
    }

    public TextEmitter getDomainNavigatorContentProviderEmitter() {
        return this.getPrimaryEmitter("xpt::navigator::DomainNavigatorContentProvider");
    }

    public TextEmitter getDomainNavigatorLabelProviderEmitter() {
        return this.getPrimaryEmitter("xpt::navigator::DomainNavigatorLabelProvider");
    }

    public TextEmitter getDomainNavigatorItemEmitter() {
        return this.getPrimaryEmitter("xpt::navigator::DomainNavigatorItem");
    }

    public TextEmitter getNavigatorLabelProviderEmitter() {
        return this.getPrimaryEmitter("xpt::navigator::NavigatorLabelProvider");
    }

    public TextEmitter getNavigatorLinkHelperEmitter() {
        return this.getPrimaryEmitter("xpt::navigator::NavigatorLinkHelper");
    }

    public TextEmitter getNavigatorSorterEmitter() {
        return this.getPrimaryEmitter("xpt::navigator::NavigatorSorter");
    }

    public TextEmitter getNavigatorActionProviderEmitter() {
        return this.getPrimaryEmitter("xpt::navigator::NavigatorActionProvider");
    }

    public TextEmitter getAbstractNavigatorItemEmitter() {
        return this.getPrimaryEmitter("xpt::navigator::AbstractNavigatorItem");
    }

    public TextEmitter getNavigatorGroupEmitter() {
        return this.getPrimaryEmitter("xpt::navigator::NavigatorGroup");
    }

    public TextEmitter getNavigatorItemEmitter() {
        return this.getPrimaryEmitter("xpt::navigator::NavigatorItem");
    }

    public BinaryEmitter getGroupIconEmitter() throws UnexpectedBehaviourException {
        return this.newGIFEmitter("/xpt/navigator/navigatorGroup.gif");
    }

    public TextEmitter getPreferenceInitializerEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::preferences::PreferenceInitializer");
    }

    public String getPreferenceInitializerName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("xpt::diagram::preferences::PreferenceInitializer", input);
    }

    public TextEmitter getStandardPreferencePageEmitter() throws UnexpectedBehaviourException {
        return this.newXpandEmitter("impl::preferences::StandardPage::Main");
    }

    public TextEmitter getCustomPreferencePageEmitter() throws UnexpectedBehaviourException {
        return this.newXpandEmitter("impl::preferences::CustomPage::Main");
    }

    public TextEmitter getActivatorEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::plugin::Activator");
    }

    public TextEmitter getBundleManifestEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::plugin::manifest");
    }

    public TextEmitter getPluginXmlEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::plugin::plugin");
    }

    public TextEmitter getPluginPropertiesEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::plugin::properties");
    }

    public TextEmitter getBuildPropertiesEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::plugin::build");
    }

    public TextEmitter getOptionsFileEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::plugin::options");
    }

    public TextEmitter getExternalizeEmitter() {
        return this.newXpandEmitter("xpt::Externalizer::Access");
    }

    public TextEmitter getMessagesEmitter() {
        return this.newXpandEmitter("xpt::Externalizer::Values");
    }

    public TextEmitter getApplicationEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::application::Application");
    }

    public TextEmitter getActionBarAdvisorEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::application::ActionBarAdvisor");
    }

    public TextEmitter getPerspectiveEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::application::Perspective");
    }

    public TextEmitter getWorkbenchAdvisorEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::application::WorkbenchAdvisor");
    }

    public TextEmitter getWorkbenchWindowAdvisorEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::application::WorkbenchWindowAdvisor");
    }

    public TextEmitter getWizardNewFileCreationPageEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::application::WizardNewFileCreationPage");
    }

    public TextEmitter getCustomActionEmitter() {
        return this.newXpandEmitter("impl::actions::CustomAction::Main");
    }

    public TextEmitter getPredefinedActionEmitter() {
        return this.newXpandEmitter("impl::actions::PredefinedAction::Main");
    }

    private TextEmitter getPrimaryEmitter(String templateName) {
        String[] parts = templateName.split(PATH_SEPARATOR);
        String definition = String.valueOf(templateName) + PATH_SEPARATOR + parts[parts.length - 1];
        return this.newXpandEmitter(definition);
    }

    private TextEmitter getMainEmitter(String templateFilePath) {
        return this.newXpandEmitter(String.valueOf(templateFilePath) + PATH_SEPARATOR + "Main");
    }

    private TextEmitter getQualifiedClassNameEmitter(String templateName) throws UnexpectedBehaviourException {
        String definition = String.valueOf(templateName) + PATH_SEPARATOR + "qualifiedClassName";
        return this.newXpandEmitter(definition);
    }

    private String getText(TextEmitter emitter, Object ... input) throws UnexpectedBehaviourException {
        try {
            return emitter.generate((IProgressMonitor)new NullProgressMonitor(), input).trim();
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException ite) {
            throw new UnexpectedBehaviourException(ite.getCause());
        }
    }

    private String getQualifiedClassName(String templateName, Object ... input) throws UnexpectedBehaviourException {
        TextEmitter emitter = this.getQualifiedClassNameEmitter(templateName);
        return this.getText(emitter, input);
    }

    private BinaryEmitter newGIFEmitter(String relativePath) throws UnexpectedBehaviourException {
        return new org.eclipse.gmf.internal.common.codegen.GIFEmitter(this.checkTemplateLocation(relativePath));
    }

    private BinaryEmitter newGIFEmitterAdapter(String relativePath) throws UnexpectedBehaviourException {
        return new JETGIFEmitterAdapter(new GIFEmitter(this.checkTemplateLocation(relativePath)));
    }

    private String checkTemplateLocation(String relativePath) throws UnexpectedBehaviourException {
        String[] templatesPath = new String[this.myLocations.length];
        int i = 0;
        while (i < this.myLocations.length) {
            templatesPath[i] = this.myLocations[i].toString();
            ++i;
        }
        String templateLocation = JETCompiler.find((String[])templatesPath, (String)relativePath);
        if (templateLocation == null) {
            throw new UnexpectedBehaviourException("Template " + relativePath + " not found");
        }
        return templateLocation;
    }

    protected TextEmitter newXpandEmitter(String definition) {
        return new XpandTextEmitter(this.myResourceManager, definition, this.myGlobals);
    }
}

