/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.graph;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gmf.runtime.draw2d.ui.graph.ConstantSizeNode;
import org.eclipse.gmf.runtime.draw2d.ui.graph.ConstrainedEdge;
import org.eclipse.gmf.runtime.draw2d.ui.graph.JointIncomingEdges;
import org.eclipse.gmf.runtime.draw2d.ui.graph.JointOutgoingEdges;

public class BorderNode
extends ConstantSizeNode {
    private float outsideRatio = 0.5f;
    JointIncomingEdges incomingJointEdges = new JointIncomingEdges(this);
    JointOutgoingEdges outgoingJointEdges = new JointOutgoingEdges(this);
    ConstantSizeNode borderNodeParent;
    int position = 0;

    public BorderNode(Object data, ConstantSizeNode parentNode) {
        super(data);
        this.borderNodeParent = parentNode;
        this.borderNodeParent.borderNodes.add(this);
        this.incomingJointEdges.target = this.borderNodeParent;
        this.outgoingJointEdges.source = this.borderNodeParent;
        this.width = 10;
        this.height = 10;
    }

    void setPoint(Point p) {
        if (p.x == this.borderNodeParent.x) {
            this.position = 8;
            this.x = p.x - (int)((float)this.width * this.outsideRatio);
            this.y = p.y - this.height / 2;
        } else if (p.y == this.borderNodeParent.y) {
            this.position = 1;
            this.x = p.x - this.width / 2;
            this.y = p.y - (int)((float)this.height * this.outsideRatio);
        } else if (p.x == this.borderNodeParent.x + this.borderNodeParent.width) {
            this.position = 16;
            this.x = p.x - (int)((float)this.width * (1.0f - this.outsideRatio));
            this.y = p.y - this.height / 2;
        } else {
            this.position = 4;
            this.x = p.x - this.width / 2;
            this.y = p.y - (int)((float)this.height * (1.0f - this.outsideRatio));
        }
    }

    void addIncomingEdge(ConstrainedEdge e) {
        this.incomingJointEdges.edges.add((Object)e);
        e.target = this.borderNodeParent;
    }

    void addOutgoingEdge(ConstrainedEdge e) {
        this.outgoingJointEdges.edges.add((Object)e);
        e.source = this.borderNodeParent;
    }

    Point getEdgesDefaultEndPoint() {
        if (this.position == 8) {
            return new Point(this.x, this.y + this.height / 2);
        }
        if (this.position == 1) {
            return new Point(this.x + this.width / 2, this.y);
        }
        if (this.position == 16) {
            return new Point(this.x + this.width, this.y + this.height / 2);
        }
        return new Point(this.x + this.width / 2, this.y + this.height);
    }

    public float getOutsideRatio() {
        return this.outsideRatio;
    }

    public void setOutsideRatio(float outsideRatio) {
        if (outsideRatio < 0.0f || outsideRatio > 1.0f) {
            throw new IllegalArgumentException("Ratio must be between 0 and 1 inclusively");
        }
        this.outsideRatio = outsideRatio;
    }
}

