/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.codegen;

import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.gmf.common.UnexpectedBehaviourException;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.util.FigureQualifiedNameSwitch;
import org.eclipse.gmf.graphdef.codegen.FigureGenerator;
import org.eclipse.gmf.graphdef.codegen.MapModeCodeGenStrategy;
import org.eclipse.gmf.graphdef.codegen.StandaloneEmitters;
import org.eclipse.gmf.internal.common.codegen.DefaultTextMerger;
import org.eclipse.gmf.internal.common.codegen.GeneratorBase;
import org.eclipse.gmf.internal.common.codegen.ImportUtil;
import org.eclipse.gmf.internal.common.codegen.TextEmitter;
import org.eclipse.gmf.internal.common.codegen.TextMerger;

public class StandaloneGenerator
extends GeneratorBase {
    protected final Config myArgs;
    private final TextEmitter myFigureGenerator;
    private final StandaloneEmitters myAuxiliaryGenerators;
    private boolean mySkipPluginStructire;
    protected Processor myProcessor;
    private final Map<String, Figure> myCallbackFigures = new LinkedHashMap<String, Figure>();

    public StandaloneGenerator(Processor p, Config config) {
        this(p, config, null);
    }

    public StandaloneGenerator(Processor p, Config config, URL[] dynamicTemplates) {
        String accessor;
        MapModeCodeGenStrategy strategy;
        assert (p != null && config != null);
        this.myArgs = config;
        this.myProcessor = p;
        String pluginActivatorFQN = StandaloneGenerator.composePluginActivatorClassFQN(config);
        if (config.getMapMode() == MapModeCodeGenStrategy.DYNAMIC) {
            strategy = MapModeCodeGenStrategy.DYNAMIC;
            accessor = String.valueOf(pluginActivatorFQN) + ".getDefault().";
        } else {
            strategy = config.getMapMode() == null ? MapModeCodeGenStrategy.STATIC : config.getMapMode();
            accessor = null;
        }
        this.myFigureGenerator = new FigureGenerator(config.getRuntimeToken(), strategy, accessor, false, dynamicTemplates);
        this.myAuxiliaryGenerators = new StandaloneEmitters(strategy, dynamicTemplates);
    }

    public void setSkipPluginStructure(boolean skipManifest) {
        this.mySkipPluginStructire = skipManifest;
    }

    protected void setupProgressMonitor() {
    }

    protected TextMerger createMergeService() {
        return new DefaultTextMerger(new JControlModel());
    }

    protected void customRun() throws InterruptedException, UnexpectedBehaviourException {
        this.initializeEditorProject(this.myArgs.getPluginID(), null);
        if (!this.mySkipPluginStructire) {
            this.generatePluginStructure();
        }
        try {
            this.generateTopLevelFigures();
            this.generatePluginActivator();
        }
        catch (IllegalStateException e) {
            throw new UnexpectedBehaviourException((Throwable)e);
        }
    }

    protected void generatePluginActivator() throws UnexpectedBehaviourException, InterruptedException {
        Object[] args = new Object[]{this.myArgs, new ImportUtil(this.myArgs.getPluginActivatorPackageName(), this.myArgs.getPluginActivatorClassName()), new ArrayList(this.myCallbackFigures.keySet())};
        this.doGenerateJavaClass(this.myAuxiliaryGenerators.getPluginActivatorEmitter(), this.myArgs.getPluginActivatorPackageName(), this.myArgs.getPluginActivatorClassName(), args);
    }

    protected void generatePluginStructure() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateFile(this.myAuxiliaryGenerators.getBuildPropertiesEmitter(), (IPath)new Path("build.properties"), new Object[]{this.myArgs});
        this.doGenerateFile(this.myAuxiliaryGenerators.getManifestMFEmitter(), (IPath)new Path("META-INF/MANIFEST.MF"), new Object[]{this.myArgs, this.myProcessor.getRequiredBundles(null)});
        this.doGenerateFile(this.myAuxiliaryGenerators.getPluginPropertiesEmitter(), (IPath)new Path("plugin.properties"), new Object[]{this.myArgs});
    }

    private void generateTopLevelFigures() throws InterruptedException {
        this.myCallbackFigures.clear();
        this.myProcessor.go(new ProcessorCallback(){

            public String visitFigure(Figure f) throws InterruptedException {
                return StandaloneGenerator.this.visitFigure(f);
            }
        }, this.myArgs);
    }

    private String visitFigure(Figure figure) throws InterruptedException {
        ImportUtil importAssistant = new ImportUtil(this.getPackageName(), CodeGenUtil.validJavaIdentifier((String)figure.getName()));
        Object[] args = new Object[]{figure, importAssistant};
        this.doGenerateJavaClass(this.myFigureGenerator, this.getPackageName(), importAssistant.getCompilationUnitName(), args);
        String qualifiedName = StandaloneGenerator.composeFQN(this.getPackageName(), importAssistant.getCompilationUnitName());
        this.myCallbackFigures.put(qualifiedName, figure);
        return qualifiedName;
    }

    private String getPackageName() {
        return this.myArgs.getMainPackageName();
    }

    private static String composePluginActivatorClassFQN(Config config) {
        String packageName = config.getPluginActivatorPackageName();
        String className = config.getPluginActivatorClassName();
        return StandaloneGenerator.composeFQN(packageName, className);
    }

    private static String composeFQN(String packageName, String className) {
        return packageName == null || "".equals(packageName) ? className : String.valueOf(packageName) + "." + className;
    }

    public static interface Config {
        public String getPluginID();

        public String getPluginFriendlyName();

        public String getPluginProviderName();

        public String getMainPackageName();

        public String getPluginActivatorClassName();

        public String getPluginActivatorPackageName();

        public MapModeCodeGenStrategy getMapMode();

        public String getRuntimeToken();
    }

    public static class ConfigImpl
    implements Config {
        private final String myPluginId;
        private final String myMainPackageName;
        private final String myPluginFriendlyName;
        private final String myPluginProviderName;
        private final String myPluginActivatorClassName;
        private final String myPluginActivatorPackageName;
        private final MapModeCodeGenStrategy myMapMode;
        private final String myRuntimeToken;

        public ConfigImpl(String pluginId, String mainPackageName) {
            this(pluginId, mainPackageName, MapModeCodeGenStrategy.DYNAMIC, null);
        }

        public ConfigImpl(String pluginId, String mainPackageName, MapModeCodeGenStrategy mapMode, String runtimeToken) {
            this(pluginId, mainPackageName, pluginId, "", "PluginActivator", String.valueOf(mainPackageName == null ? "" : String.valueOf(mainPackageName) + ".") + "activator", mapMode, null);
        }

        public ConfigImpl(String pluginId, String mainPackageName, String pluginFriendlyName, String pluginProviderName, String pluginActivatorClassName, String pluginActivatorPackageName, MapModeCodeGenStrategy mapMode, String runtimeToken) {
            this.myPluginId = pluginId;
            this.myMainPackageName = mainPackageName == null ? "" : mainPackageName;
            this.myPluginFriendlyName = pluginFriendlyName;
            this.myPluginProviderName = pluginProviderName;
            this.myPluginActivatorClassName = pluginActivatorClassName;
            this.myPluginActivatorPackageName = pluginActivatorPackageName;
            this.myMapMode = mapMode;
            this.myRuntimeToken = runtimeToken;
        }

        public String getMainPackageName() {
            return this.myMainPackageName;
        }

        public String getPluginFriendlyName() {
            return this.myPluginFriendlyName;
        }

        public String getPluginID() {
            return this.myPluginId;
        }

        public String getPluginProviderName() {
            return this.myPluginProviderName;
        }

        public String getPluginActivatorClassName() {
            return this.myPluginActivatorClassName;
        }

        public String getPluginActivatorPackageName() {
            return this.myPluginActivatorPackageName;
        }

        public MapModeCodeGenStrategy getMapMode() {
            return this.myMapMode;
        }

        public String getRuntimeToken() {
            return this.myRuntimeToken;
        }
    }

    public static abstract class Processor {
        public abstract void go(ProcessorCallback var1, Config var2) throws InterruptedException;

        public String[] getRequiredBundles(FigureQualifiedNameSwitch fqnSwitch) {
            return new String[0];
        }
    }

    public static interface ProcessorCallback {
        public String visitFigure(Figure var1) throws InterruptedException;
    }
}

