/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.codegen.popup.actions;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.internal.bridge.NaiveIdentifierDispenser;
import org.eclipse.gmf.internal.bridge.StatefulVisualIdentifierDispencer;
import org.eclipse.gmf.internal.bridge.VisualIdentifierDispenser;
import org.eclipse.gmf.internal.codegen.CodeGenUIPlugin;
import org.osgi.framework.Bundle;

class VisualIdentifierDispenserProvider {
    private VisualIdentifierDispenser dispenser;
    private final URI myStateBaseURI;

    VisualIdentifierDispenserProvider(URI stateBaseURI) {
        this.myStateBaseURI = stateBaseURI;
    }

    private VisualIdentifierDispenser initialize() {
        Bundle tracePluginBundle = Platform.getBundle((String)"org.eclipse.gmf.bridge.trace");
        if (tracePluginBundle != null) {
            try {
                Class despenserClass = tracePluginBundle.loadClass("org.eclipse.gmf.internal.bridge.trace.MergingIdentifierDispenser");
                return (VisualIdentifierDispenser)despenserClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                CodeGenUIPlugin.getDefault().getLog().log(CodeGenUIPlugin.createError("MergingIdentifierDispenser was not found in org.eclipse.gmf.bridge.trace bundle", e));
            }
            catch (InstantiationException e) {
                CodeGenUIPlugin.getDefault().getLog().log(CodeGenUIPlugin.createError("MergingIdentifierDispenser was not instantiated", e));
            }
            catch (IllegalAccessException e) {
                CodeGenUIPlugin.getDefault().getLog().log(CodeGenUIPlugin.createError("IllegalAccessException while instantiating MergingIdentifierDispenser", e));
            }
            catch (ClassCastException ex) {
                CodeGenUIPlugin.getDefault().getLog().log(CodeGenUIPlugin.createError("MergingIdentifierDispenser was not instantiated", ex));
            }
        }
        return new NaiveIdentifierDispenser();
    }

    public VisualIdentifierDispenser get() {
        assert (this.dispenser != null);
        return this.dispenser;
    }

    public void acquire() {
        assert (this.dispenser == null);
        this.dispenser = this.initialize();
        if (this.dispenser instanceof StatefulVisualIdentifierDispencer) {
            StatefulVisualIdentifierDispencer statefulDispencer = (StatefulVisualIdentifierDispencer)this.dispenser;
            statefulDispencer.loadState(this.myStateBaseURI);
        }
    }

    public void release() {
        if (this.dispenser instanceof StatefulVisualIdentifierDispencer) {
            ((StatefulVisualIdentifierDispencer)this.dispenser).saveState();
        }
        this.dispenser = null;
    }
}

