/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.validation;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.lite.validation.Severity;
import org.eclipse.gmf.runtime.notation.View;

public class ViolationDescriptor {
    private final String myMessage;
    private final URI myUri;
    private final Severity mySeverity;
    private final Object myReferent;

    public ViolationDescriptor(Severity severity, String message, URI uri, Object data) {
        this.mySeverity = severity;
        this.myMessage = message;
        this.myUri = uri;
        this.myReferent = data;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public Severity getSeverity() {
        return this.mySeverity;
    }

    public URI getUri() {
        return this.myUri;
    }

    public Object getReferent() {
        return this.myReferent;
    }

    public int hashCode() {
        return this.myUri.hashCode() + 17 * this.mySeverity.hashCode() + 31 * this.myMessage.hashCode();
    }

    public static ViolationDescriptor create(View view, IStatus validationStatus) {
        Severity severity;
        switch (validationStatus.getSeverity()) {
            case 1: {
                severity = Severity.INFO;
                break;
            }
            case 2: {
                severity = Severity.WARNING;
                break;
            }
            case 4: {
                severity = Severity.ERROR;
                break;
            }
            default: {
                return null;
            }
        }
        return new ViolationDescriptor(severity, validationStatus.getMessage(), EcoreUtil.getURI((EObject)view), validationStatus);
    }

    public static ViolationDescriptor create(View view, Diagnostic diagnostic) {
        Severity severity;
        switch (diagnostic.getSeverity()) {
            case 1: {
                severity = Severity.INFO;
                break;
            }
            case 2: {
                severity = Severity.WARNING;
                break;
            }
            case 4: {
                severity = Severity.ERROR;
                break;
            }
            default: {
                return null;
            }
        }
        return new ViolationDescriptor(severity, diagnostic.getMessage(), EcoreUtil.getURI((EObject)view), diagnostic);
    }
}

