/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.edit.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gmf.runtime.lite.commands.WrappingCommand;
import org.eclipse.gmf.runtime.lite.requests.SetAllBendpointsRequest;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;

public class BendpointEditPolicy
extends org.eclipse.gef.editpolicies.BendpointEditPolicy {
    protected Edge getDiagramEdge() {
        return (Edge)this.getHost().getModel();
    }

    public org.eclipse.gef.commands.Command getCommand(Request request) {
        if ("set_all_bendpoints".equals(request.getType())) {
            return this.getSetAllBendpointsCommand((SetAllBendpointsRequest)request);
        }
        return super.getCommand(request);
    }

    protected org.eclipse.gef.commands.Command getSetAllBendpointsCommand(SetAllBendpointsRequest request) {
        return this.getModifyBendpointCommand(new BendpointSetter(request.getPoints()));
    }

    protected org.eclipse.gef.commands.Command getCreateBendpointCommand(BendpointRequest request) {
        return this.getModifyBendpointCommand(new BendpointCreator(request.getIndex(), request.getLocation()));
    }

    protected org.eclipse.gef.commands.Command getDeleteBendpointCommand(BendpointRequest request) {
        return this.getModifyBendpointCommand(new BendpointDeleter(request.getIndex()));
    }

    protected org.eclipse.gef.commands.Command getMoveBendpointCommand(BendpointRequest request) {
        return this.getModifyBendpointCommand(new BendpointMover(request.getIndex(), request.getLocation()));
    }

    private org.eclipse.gef.commands.Command getModifyBendpointCommand(BendpointModifier modifier) {
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.getDiagramEdge().getDiagram().getElement());
        return new WrappingCommand(editingDomain, (Command)new BendpointModificationCommand(modifier));
    }

    private static interface BendpointConverter {
        public RelativeBendpoint convert(Point var1);
    }

    private static class BendpointCreator
    implements BendpointModifier {
        private int index;
        private Point point;

        public BendpointCreator(int index, Point point) {
            this.index = index;
            this.point = point;
        }

        public void applyModification(List originalBendpoints, BendpointConverter converter) {
            originalBendpoints.add(this.index, converter.convert(this.point));
        }
    }

    private static class BendpointDeleter
    implements BendpointModifier {
        private int index;

        public BendpointDeleter(int index) {
            this.index = index;
        }

        public void applyModification(List originalBendpoints, BendpointConverter converter) {
            originalBendpoints.remove(this.index);
        }
    }

    private class BendpointModificationCommand
    extends AbstractCommand {
        private BendpointModifier bendpointModifier;
        private List oldPoints;
        private Point mySourceRef;
        private Point myTargetRef;

        public BendpointModificationCommand(BendpointModifier bendpointModifier) {
            this.bendpointModifier = bendpointModifier;
        }

        protected boolean prepare() {
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)BendpointEditPolicy.this.getDiagramEdge());
            if (domain != null && domain.isReadOnly(BendpointEditPolicy.this.getDiagramEdge().eResource())) {
                return false;
            }
            Connection connection = BendpointEditPolicy.this.getConnection();
            this.mySourceRef = connection.getSourceAnchor().getReferencePoint().getCopy();
            connection.translateToRelative((Translatable)this.mySourceRef);
            this.myTargetRef = connection.getTargetAnchor().getReferencePoint().getCopy();
            connection.translateToRelative((Translatable)this.myTargetRef);
            return true;
        }

        public void execute() {
            RelativeBendpoints bendpoints = (RelativeBendpoints)BendpointEditPolicy.this.getDiagramEdge().getBendpoints();
            if (bendpoints == null) {
                bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
                BendpointEditPolicy.this.getDiagramEdge().setBendpoints((Bendpoints)bendpoints);
            }
            this.oldPoints = bendpoints.getPoints();
            ArrayList newPoints = new ArrayList(this.oldPoints);
            this.bendpointModifier.applyModification(newPoints, new BendpointConverter(){

                public RelativeBendpoint convert(Point point) {
                    BendpointEditPolicy.this.getConnection().translateToRelative((Translatable)point);
                    Dimension s = point.getDifference(BendpointModificationCommand.this.mySourceRef);
                    Dimension t = point.getDifference(BendpointModificationCommand.this.myTargetRef);
                    return new RelativeBendpoint(s.width, s.height, t.width, t.height);
                }
            });
            bendpoints.setPoints(newPoints);
        }

        public void undo() {
            RelativeBendpoints bendpoints = (RelativeBendpoints)BendpointEditPolicy.this.getDiagramEdge().getBendpoints();
            bendpoints.setPoints(this.oldPoints);
        }

        public void redo() {
            this.execute();
        }
    }

    private static interface BendpointModifier {
        public void applyModification(List var1, BendpointConverter var2);
    }

    private static class BendpointMover
    implements BendpointModifier {
        private int index;
        private Point point;

        public BendpointMover(int index, Point point) {
            this.index = index;
            this.point = point;
        }

        public void applyModification(List originalBendpoints, BendpointConverter converter) {
            originalBendpoints.set(this.index, converter.convert(this.point));
        }
    }

    private static class BendpointSetter
    implements BendpointModifier {
        private PointList myPoints;

        public BendpointSetter(PointList points) {
            this.myPoints = points;
        }

        public void applyModification(List originalBendpoints, BendpointConverter converter) {
            originalBendpoints.clear();
            int i = 0;
            int iMax = this.myPoints.size();
            while (i < iMax) {
                originalBendpoints.add(converter.convert(this.myPoints.getPoint(i)));
                ++i;
            }
        }
    }
}

