/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.map.editor.edit.parts;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.map.editor.edit.parts.CanvasMappingContentsEditPart;
import org.eclipse.gmf.map.editor.edit.parts.CanvasMappingEditPart;
import org.eclipse.gmf.map.editor.edit.parts.CanvasMappingInfoEditPart;
import org.eclipse.gmf.map.editor.edit.parts.ChildReferenceEditPart;
import org.eclipse.gmf.map.editor.edit.parts.ChildReferenceOwnedChildEditPart;
import org.eclipse.gmf.map.editor.edit.parts.ChildReferenceReferencedChildEditPart;
import org.eclipse.gmf.map.editor.edit.parts.CompartmentMappingChildrenEditPart;
import org.eclipse.gmf.map.editor.edit.parts.CompartmentMappingEditPart;
import org.eclipse.gmf.map.editor.edit.parts.CompartmentMappingInfoEditPart;
import org.eclipse.gmf.map.editor.edit.parts.DesignLabelMapping2EditPart;
import org.eclipse.gmf.map.editor.edit.parts.DesignLabelMappingEditPart;
import org.eclipse.gmf.map.editor.edit.parts.FeatureLabelMapping2EditPart;
import org.eclipse.gmf.map.editor.edit.parts.FeatureLabelMappingEditPart;
import org.eclipse.gmf.map.editor.edit.parts.LabelMapping2EditPart;
import org.eclipse.gmf.map.editor.edit.parts.LabelMappingEditPart;
import org.eclipse.gmf.map.editor.edit.parts.LinkMappingEditPart;
import org.eclipse.gmf.map.editor.edit.parts.LinkMappingInfoEditPart;
import org.eclipse.gmf.map.editor.edit.parts.LinkMappingLabelsEditPart;
import org.eclipse.gmf.map.editor.edit.parts.MappingEditPart;
import org.eclipse.gmf.map.editor.edit.parts.NodeMappingContentsEditPart;
import org.eclipse.gmf.map.editor.edit.parts.NodeMappingEditPart;
import org.eclipse.gmf.map.editor.edit.parts.NodeMappingInfoEditPart;
import org.eclipse.gmf.map.editor.edit.parts.NodeMappingLabelsEditPart;
import org.eclipse.gmf.map.editor.edit.parts.ReferenceInfo2EditPart;
import org.eclipse.gmf.map.editor.edit.parts.ReferenceInfoEditPart;
import org.eclipse.gmf.map.editor.edit.parts.TopNodeReferenceEditPart;
import org.eclipse.gmf.map.editor.edit.parts.TopNodeReferenceOwnedChildEditPart;
import org.eclipse.gmf.map.editor.part.GMFMapVisualIDRegistry;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Text;

public class GMFMapEditPartFactory
implements EditPartFactory {
    public static final String EXTERNAL_NODE_LABELS_LAYER = "External Node Labels";

    public EditPart createEditPart(EditPart context, Object model) {
        if (model instanceof View) {
            View view = (View)model;
            int viewVisualID = GMFMapVisualIDRegistry.getVisualID(view);
            switch (viewVisualID) {
                case 2001: {
                    return new CanvasMappingEditPart(view);
                }
                case 5001: {
                    return new CanvasMappingInfoEditPart(view);
                }
                case 2003: {
                    return new NodeMappingEditPart(view);
                }
                case 5003: {
                    return new NodeMappingInfoEditPart(view);
                }
                case 2002: {
                    return new LinkMappingEditPart(view);
                }
                case 5002: {
                    return new LinkMappingInfoEditPart(view);
                }
                case 3001: {
                    return new TopNodeReferenceEditPart(view);
                }
                case 5005: {
                    return new ReferenceInfoEditPart(view);
                }
                case 3006: {
                    return new FeatureLabelMappingEditPart(view);
                }
                case 3007: {
                    return new DesignLabelMappingEditPart(view);
                }
                case 3002: {
                    return new LabelMappingEditPart(view);
                }
                case 3004: {
                    return new ChildReferenceEditPart(view);
                }
                case 5006: {
                    return new ReferenceInfo2EditPart(view);
                }
                case 3005: {
                    return new CompartmentMappingEditPart(view);
                }
                case 5004: {
                    return new CompartmentMappingInfoEditPart(view);
                }
                case 3008: {
                    return new FeatureLabelMapping2EditPart(view);
                }
                case 3009: {
                    return new DesignLabelMapping2EditPart(view);
                }
                case 3003: {
                    return new LabelMapping2EditPart(view);
                }
                case 7001: {
                    return new CanvasMappingContentsEditPart(view);
                }
                case 7003: {
                    return new NodeMappingLabelsEditPart(view);
                }
                case 7004: {
                    return new NodeMappingContentsEditPart(view);
                }
                case 7002: {
                    return new LinkMappingLabelsEditPart(view);
                }
                case 1000: {
                    return new MappingEditPart(view);
                }
                case 4001: {
                    return new TopNodeReferenceOwnedChildEditPart(view);
                }
                case 4004: {
                    return new ChildReferenceOwnedChildEditPart(view);
                }
                case 4002: {
                    return new ChildReferenceReferencedChildEditPart(view);
                }
                case 4003: {
                    return new CompartmentMappingChildrenEditPart(view);
                }
            }
        }
        return this.createUnrecognizedEditPart(context, model);
    }

    private EditPart createUnrecognizedEditPart(EditPart context, Object model) {
        return null;
    }

    public static CellEditorLocator getTextCellEditorLocator(ITextAwareEditPart source) {
        if (source.getFigure() instanceof WrapLabel) {
            return new TextCellEditorLocator((WrapLabel)source.getFigure());
        }
        IFigure figure = source.getFigure();
        return new LabelCellEditorLocator((Label)figure);
    }

    private static class LabelCellEditorLocator
    implements CellEditorLocator {
        private Label label;

        public LabelCellEditorLocator(Label label) {
            this.label = label;
        }

        public Label getLabel() {
            return this.label;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getLabel().getTextBounds().getCopy();
            this.getLabel().translateToAbsolute((Translatable)rect);
            int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
            rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    private static class TextCellEditorLocator
    implements CellEditorLocator {
        private WrapLabel wrapLabel;

        public TextCellEditorLocator(WrapLabel wrapLabel) {
            this.wrapLabel = wrapLabel;
        }

        public WrapLabel getWrapLabel() {
            return this.wrapLabel;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getWrapLabel().getTextBounds().getCopy();
            this.getWrapLabel().translateToAbsolute((Translatable)rect);
            if (this.getWrapLabel().isTextWrapped() && this.getWrapLabel().getText().length() > 0) {
                rect.setSize(new Dimension(text.computeSize(rect.width, -1)));
            } else {
                int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
                rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
            }
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }
}

