/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.validate;

import java.util.HashMap;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.gmf.internal.validate.AnnotatedDefinitionValidator;
import org.eclipse.gmf.internal.validate.AnnotatedOclValidator;
import org.eclipse.gmf.internal.validate.ExternModelImport;
import org.eclipse.gmf.internal.validate.ValidatorChain;
import org.eclipse.gmf.validate.ValidationOptions;

public class GMFValidator
extends ValidatorChain {
    private static EValidator[] GMF_VALIDATORS = new EValidator[]{ExternModelImport.getImportValidator(), new AnnotatedOclValidator(), new AnnotatedDefinitionValidator()};
    private static final EValidator NO_ECORE_INSTANCE = new ValidatorChain(GMF_VALIDATORS);
    private static EValidator[] ALL_VALIDATORS = new EValidator[]{EObjectValidator.INSTANCE, NO_ECORE_INSTANCE};
    public static final EValidator INSTANCE = new ValidatorChain(ALL_VALIDATORS);

    private GMFValidator() {
        super(GMF_VALIDATORS);
    }

    public static Diagnostic validate(EObject eObject) {
        Diagnostician diagnostician = new Diagnostician((EValidator.Registry)new DelegateRegistry());
        return diagnostician.validate(eObject);
    }

    public static Diagnostic validate(EObject eObject, ValidationOptions options) {
        Diagnostician diagnostician = new Diagnostician((EValidator.Registry)new DelegateRegistry(options));
        return diagnostician.validate(eObject);
    }

    private static class DelegateRegistry
    extends HashMap
    implements EValidator.Registry {
        private ValidationOptions options;
        private EValidator gmfValidator;
        private EValidator noEcoreValidator;
        static /* synthetic */ Class class$0;

        DelegateRegistry() {
            this((ValidationOptions)null);
            this.gmfValidator = INSTANCE;
            this.noEcoreValidator = NO_ECORE_INSTANCE;
        }

        DelegateRegistry(ValidationOptions options) {
            this.options = options;
        }

        private EValidator getGmfValidator() {
            if (this.gmfValidator == null) {
                this.gmfValidator = new ValidatorChain(ALL_VALIDATORS, this.options);
            }
            return this.gmfValidator;
        }

        private EValidator getNoEcoreValidator() {
            if (this.noEcoreValidator == null) {
                this.noEcoreValidator = new ValidatorChain(GMF_VALIDATORS, this.options);
            }
            return this.noEcoreValidator;
        }

        public EValidator getEValidator(EPackage ePackage) {
            EValidator delegateValidator;
            block9: {
                block8: {
                    if (this.containsKey(ePackage)) {
                        return (EValidator)super.get(ePackage);
                    }
                    delegateValidator = EValidator.Registry.INSTANCE.getEValidator(ePackage);
                    if (delegateValidator == null) break block8;
                    Class<?> clazz = delegateValidator.getClass();
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("org.eclipse.emf.ecore.util.EObjectValidator");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (!clazz.equals(clazz2)) break block9;
                }
                return this.getGmfValidator();
            }
            return this.createDelegator(ePackage, delegateValidator);
        }

        private EValidator createDelegator(Object key, EValidator delegate) {
            ValidatorChain delegatingValidator = new ValidatorChain(new EValidator[]{delegate, this.getNoEcoreValidator()});
            this.put(key, delegatingValidator);
            return delegatingValidator;
        }

        public Object get(Object key) {
            Object provider = super.get(key);
            if (provider != null) {
                return provider;
            }
            provider = EValidator.Registry.INSTANCE.get(key);
            if (provider != null && provider instanceof EValidator) {
                Class<?> clazz = provider.getClass();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.emf.ecore.util.EObjectValidator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(clazz2)) {
                    return this.getGmfValidator();
                }
                provider = this.createDelegator(key, (EValidator)provider);
            }
            return provider;
        }
    }
}

