/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.draw2d.ui.render.internal.svg;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import junit.framework.TestCase;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderInfo;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.image.ImageConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.ImageTranscoderEx;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.SVGImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.factory.RenderedImageFactory;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.RenderHelper;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.RenderingListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class SVGImageTest
extends TestCase {
    private static final String PREFIX_ROOT = "resources/svg/";
    private static final String SVG_BLACKWHITE = "resources/svg/blackwhite.svg";
    private static final String SVG_SHAPES = "resources/svg/shapes.svg";
    private static final String SVG_UMLSHAPES = "resources/svg/uml.svg";
    private static final String SVG_TRANSPARENCY_TEST = "resources/svg/presenter.svg";
    private final int WIDTH = 200;
    private final int HEIGHT = 200;
    private final int NEW_WIDTH = 120;
    private final int NEW_HEIGHT = 140;
    private final RGB NEW_FILL = new RGB(255, 0, 0);
    private final RGB NEW_OUTLINE = new RGB(0, 255, 0);
    private RenderedImage fixture1;
    private RenderedImage fixture2;
    private RenderedImage fixture3;
    private RenderedImage fixture4;
    static final int START_DIM = 100;
    static final int END_DIM = 1000;
    static final int INC_DIM = 10;
    private static final Dimension MAX_RENDER_SIZE = new Dimension(200, 200);
    private static RGB BLACK = new RGB(0, 0, 0);
    private static RGB WHITE = new RGB(255, 255, 255);
    private static RGB RED = new RGB(255, 0, 0);
    private static RGB GREEN = new RGB(0, 255, 0);

    public SVGImageTest(String name) {
        super(name);
    }

    private RenderedImage getFixture1() {
        return this.fixture1;
    }

    private RenderedImage getFixture2() {
        return this.fixture2;
    }

    private RenderedImage getFixture3() {
        return this.fixture3;
    }

    private RenderedImage getFixture4() {
        return this.fixture4;
    }

    protected void setUp() {
        try {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.gmf.tests.runtime.draw2d.ui.render");
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(SVG_UMLSHAPES), null);
            this.fixture1 = RenderedImageFactory.getInstance((URL)url);
            SVGImageTest.assertNotNull((String)"Fixture1 shouldn't be null", (Object)this.fixture1);
            RenderInfo info = RenderedImageFactory.createInfo((int)200, (int)200, (boolean)false, (boolean)false, null, null);
            url = FileLocator.find((Bundle)bundle, (IPath)new Path(SVG_SHAPES), null);
            this.fixture2 = RenderedImageFactory.getInstance((URL)url, (RenderInfo)info);
            SVGImageTest.assertNotNull((String)"Fixture2 shouldn't be null", (Object)this.fixture2);
            url = FileLocator.find((Bundle)bundle, (IPath)new Path(SVG_BLACKWHITE), null);
            this.fixture3 = RenderedImageFactory.getInstance((URL)url);
            SVGImageTest.assertNotNull((String)"Fixture3 shouldn't be null", (Object)this.fixture3);
            url = FileLocator.find((Bundle)bundle, (IPath)new Path(SVG_TRANSPARENCY_TEST), null);
            this.fixture4 = RenderedImageFactory.getInstance((URL)url);
            SVGImageTest.assertNotNull((String)"Fixture3 shouldn't be null", (Object)this.fixture4);
        }
        catch (Exception e) {
            SVGImageTest.fail((String)("The SVGImageTest.setUp method caught an exception - " + e));
        }
    }

    public void testGetRenderInfo() {
        RenderInfo info = this.getFixture1().getRenderInfo();
        SVGImageTest.assertTrue((String)"getRenderInfo fixture 1 return null", (info != null ? 1 : 0) != 0);
        info = this.getFixture2().getRenderInfo();
        SVGImageTest.assertTrue((String)"getRenderInfo fixture 2 return null", (info != null ? 1 : 0) != 0);
        SVGImageTest.assertTrue((String)"getRenderInfo fixture 2 width / height not correct", (info.getWidth() == 200 && info.getHeight() == 200 ? 1 : 0) != 0);
    }

    public void testGetNewRenderedImage() {
        RenderInfo info = RenderedImageFactory.createInfo((int)120, (int)140, (boolean)true, (boolean)true, (RGB)this.NEW_FILL, (RGB)this.NEW_OUTLINE);
        SVGImageTest.assertTrue((info != null ? 1 : 0) != 0);
        info = RenderedImageFactory.createInfo((int)120, (int)140, (boolean)false, (boolean)false, null, (RGB)this.NEW_OUTLINE);
        SVGImageTest.assertTrue((info != null ? 1 : 0) != 0);
    }

    private void performBatikRendering(SVGImage svg1, int width, int height) {
        ByteArrayInputStream in = new ByteArrayInputStream(svg1.getBuffer());
        RenderInfo info = svg1.getRenderInfo();
        ImageTranscoderEx transcoder = new ImageTranscoderEx();
        if (width > 0) {
            transcoder.addTranscodingHint(ImageTranscoderEx.KEY_WIDTH, (Object)new Float(width));
        }
        if (height > 0) {
            transcoder.addTranscodingHint(ImageTranscoderEx.KEY_HEIGHT, (Object)new Float(height));
        }
        transcoder.addTranscodingHint(ImageTranscoderEx.KEY_MAINTAIN_ASPECT_RATIO, (Object)info.shouldMaintainAspectRatio());
        transcoder.addTranscodingHint(ImageTranscoderEx.KEY_ANTI_ALIASING, (Object)info.shouldAntiAlias());
        if (info.getBackgroundColor() != null) {
            transcoder.addTranscodingHint(ImageTranscoderEx.KEY_FILL_COLOR, (Object)new RGB(info.getBackgroundColor().red, info.getBackgroundColor().green, info.getBackgroundColor().blue));
        }
        if (info.getForegroundColor() != null) {
            transcoder.addTranscodingHint(ImageTranscoderEx.KEY_OUTLINE_COLOR, (Object)new RGB(info.getForegroundColor().red, info.getForegroundColor().green, info.getForegroundColor().blue));
        }
        TranscoderInput input = new TranscoderInput((InputStream)in);
        TranscoderOutput output = new TranscoderOutput();
        try {
            transcoder.transcode(input, output);
        }
        catch (TranscoderException e) {
            e.printStackTrace();
        }
        BufferedImage bufImg = transcoder.getBufferedImage();
        Image swtImage = ImageConverter.convert((BufferedImage)bufImg);
        SVGImageTest.assertNotNull((String)"swtImage fixture 1 Image invalid", (Object)swtImage);
    }

    private void performRenderedImageRendering(SVGImage svg1, int width, int height) {
        RenderInfo info = svg1.getRenderInfo();
        info.setValues(width, height, true, true, info.getBackgroundColor(), info.getForegroundColor());
        RenderedImage ri = svg1.getNewRenderedImage(info);
        Image img = ri.getSWTImage();
        SVGImageTest.assertNotNull((String)"getSWTImage fixture 1 Image invalid", (Object)img);
    }

    public void testRenderedImagePerformance() {
        SVGImage svg1 = (SVGImage)this.getFixture1();
        int width = 100;
        int height = 100;
        long batikTime = 0L;
        long renderTime = 0L;
        this.performBatikRendering(svg1, width, height);
        long startTime = System.currentTimeMillis();
        while (width < 1000 && height < 1000) {
            this.performBatikRendering(svg1, width, height);
            width += 10;
            height += 10;
        }
        long endTime = System.currentTimeMillis();
        batikTime = endTime - startTime;
        startTime = System.currentTimeMillis();
        width = 100;
        height = 100;
        while (width < 1000 && height < 1000) {
            this.performRenderedImageRendering(svg1, width, height);
            width += 10;
            height += 10;
        }
        endTime = System.currentTimeMillis();
        renderTime = endTime - startTime;
        System.out.println("Batik rendering time was: " + batikTime);
        System.out.println("RenderedImage rendering time was: " + renderTime);
        System.out.println("Percentage difference: " + (float)(renderTime - batikTime) / (float)batikTime * 100.0f + "%");
        SVGImageTest.assertTrue((renderTime < batikTime ? 1 : 0) != 0);
    }

    public void testRenderHelper() {
        Display display = Display.getDefault();
        Image image = new Image((Device)display, new org.eclipse.swt.graphics.Rectangle(0, 0, 500, 500));
        GC gc = new GC((Drawable)image);
        SWTGraphics swtG = new SWTGraphics(gc);
        Rectangle target = new Rectangle(50, 50, 94, 94);
        RenderInfo info = this.getFixture1().getRenderInfo();
        info.setValues(target.width, target.height, true, true, info.getBackgroundColor(), info.getForegroundColor());
        RenderedImage ri = this.getFixture1().getNewRenderedImage(info);
        RenderHelper renderHelper = RenderHelper.getInstance((double)1.0, (boolean)false, (boolean)false, null);
        RenderingListenerImpl listener = new RenderingListenerImpl();
        RenderedImage retImage = renderHelper.drawRenderedImage((Graphics)swtG, ri, target, (RenderingListener)listener);
        SVGImageTest.assertTrue((boolean)retImage.isRendered());
        SVGImageTest.assertTrue((retImage.getSWTImage() != null ? 1 : 0) != 0);
        target.width -= 10;
        target.height -= 10;
        listener = new RenderingListenerImpl();
        renderHelper = RenderHelper.getInstance((double)1.0, (boolean)false, (boolean)true, null);
        retImage = renderHelper.drawRenderedImage((Graphics)swtG, retImage, target, (RenderingListener)listener);
        int i = 0;
        while (!retImage.isRendered() && i < 100) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        SVGImageTest.assertTrue((retImage.isRendered() && i < 100 ? 1 : 0) != 0);
    }

    public void testRenderMaxSize() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        Image image = new Image((Device)display, new org.eclipse.swt.graphics.Rectangle(0, 0, 500, 500));
        GC gc = new GC((Drawable)image);
        SWTGraphics swtG = new SWTGraphics(gc);
        Rectangle target = new Rectangle(0, 0, SVGImageTest.MAX_RENDER_SIZE.width * 2, SVGImageTest.MAX_RENDER_SIZE.height * 2);
        RenderInfo info = this.getFixture1().getRenderInfo();
        info.setValues(SVGImageTest.MAX_RENDER_SIZE.width * 2, SVGImageTest.MAX_RENDER_SIZE.height * 2, false, true, info.getBackgroundColor(), info.getForegroundColor());
        RenderedImage ri = this.getFixture1().getNewRenderedImage(info);
        RenderHelper renderHelper = RenderHelper.getInstance((double)1.0, (boolean)false, (boolean)false, null);
        RenderingListenerImpl listener = new RenderingListenerImpl();
        RenderedImage retImage = renderHelper.drawRenderedImage((Graphics)swtG, ri, target, (RenderingListener)listener);
        SVGImageTest.assertTrue((boolean)retImage.isRendered());
        SVGImageTest.assertTrue((retImage.getSWTImage() != null ? 1 : 0) != 0);
        SVGImageTest.assertTrue((Math.abs(retImage.getSWTImage().getBounds().width - SVGImageTest.MAX_RENDER_SIZE.width * 2) <= 5 ? 1 : 0) != 0);
        SVGImageTest.assertTrue((Math.abs(retImage.getSWTImage().getBounds().height - SVGImageTest.MAX_RENDER_SIZE.height * 2) <= 5 ? 1 : 0) != 0);
        renderHelper = RenderHelper.getInstance((double)1.0, (boolean)false, (boolean)false, (Dimension)MAX_RENDER_SIZE);
        retImage = renderHelper.drawRenderedImage((Graphics)swtG, ri, target, (RenderingListener)listener);
        SVGImageTest.assertTrue((boolean)retImage.isRendered());
        SVGImageTest.assertTrue((retImage.getSWTImage() != null ? 1 : 0) != 0);
        SVGImageTest.assertTrue((retImage.getSWTImage().getBounds().width <= SVGImageTest.MAX_RENDER_SIZE.width ? 1 : 0) != 0);
        SVGImageTest.assertTrue((retImage.getSWTImage().getBounds().height <= SVGImageTest.MAX_RENDER_SIZE.height ? 1 : 0) != 0);
    }

    private boolean findColor(Image srcImage, RGB colorToFind) {
        BufferedImage bufImg = ImageConverter.convert((Image)srcImage);
        int width = bufImg.getWidth();
        int height = bufImg.getHeight();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int color = bufImg.getRGB(x, y);
                Color swtColor = this.integerToColor(color);
                RGB checkColor = new RGB(swtColor.getRed(), swtColor.getGreen(), swtColor.getBlue());
                swtColor.dispose();
                if (checkColor.equals((Object)colorToFind)) {
                    return true;
                }
                ++x;
            }
            ++y;
        }
        return false;
    }

    private Color integerToColor(int color) {
        return new Color(null, (color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF);
    }

    public void testChangeColors() {
        RenderedImage fixture = this.getFixture3();
        RenderInfo info = fixture.getRenderInfo();
        Image swtImg1 = fixture.getSWTImage();
        SVGImageTest.assertTrue((boolean)this.findColor(swtImg1, BLACK));
        SVGImageTest.assertTrue((boolean)this.findColor(swtImg1, WHITE));
        SVGImageTest.assertFalse((boolean)this.findColor(swtImg1, RED));
        SVGImageTest.assertFalse((boolean)this.findColor(swtImg1, GREEN));
        info.setValues(info.getWidth(), info.getHeight(), true, true, RED, RED);
        RenderedImage colorImg1 = fixture.getNewRenderedImage(info);
        Image swtImg2 = colorImg1.getSWTImage();
        SVGImageTest.assertNotNull((String)"getSWTImage colorImg1 Image invalid", (Object)swtImg1);
        SVGImageTest.assertTrue((boolean)this.findColor(swtImg2, RED));
        SVGImageTest.assertFalse((boolean)this.findColor(swtImg2, GREEN));
        info.setValues(info.getWidth(), info.getHeight(), true, true, GREEN, GREEN);
        RenderedImage colorImg2 = fixture.getNewRenderedImage(info);
        Image swtImg3 = colorImg2.getSWTImage();
        SVGImageTest.assertNotNull((String)"getSWTImage colorImg1 Image invalid", (Object)swtImg1);
        SVGImageTest.assertNotNull((String)"getSWTImage colorImg2 Image invalid", (Object)swtImg2);
        SVGImageTest.assertTrue((colorImg1 != colorImg2 ? 1 : 0) != 0);
        SVGImageTest.assertTrue((boolean)this.findColor(swtImg3, GREEN));
        SVGImageTest.assertFalse((boolean)this.findColor(swtImg3, RED));
    }

    public void testGetSWTImage() {
        Image img = this.getFixture1().getSWTImage();
        SVGImageTest.assertNotNull((String)"getSWTImage fixture 1 Image invalid", (Object)img);
        img = this.getFixture2().getSWTImage();
        SVGImageTest.assertNotNull((String)"getSWTImage fixture 2 Image invalid", (Object)img);
    }

    public void testTransparency() {
        Image img = this.getFixture4().getSWTImage();
        ImageData imgData = img.getImageData();
        org.eclipse.swt.graphics.Rectangle bounds = img.getBounds();
        SVGImageTest.assertTrue((boolean)this.isTransparentAt(imgData, bounds.x + 1, bounds.y + 1));
        SVGImageTest.assertTrue((boolean)this.isTransparentAt(imgData, bounds.x + bounds.width - 2, bounds.y + 1));
        SVGImageTest.assertTrue((boolean)this.isTransparentAt(imgData, bounds.x + 1, bounds.y + bounds.height - 2));
        SVGImageTest.assertTrue((boolean)this.isTransparentAt(imgData, bounds.x + bounds.width - 2, bounds.y + bounds.height - 2));
    }

    protected boolean isTransparentAt(ImageData data, int x, int y) {
        if (x < 0 || x >= data.width || y < 0 || y >= data.height) {
            return true;
        }
        ImageData transMaskData = data.getTransparencyMask();
        int transValue = 255;
        if (transMaskData != null) {
            int n = transValue = transMaskData.getPixel(x, y) == 0 ? 0 : 255;
        }
        if (transValue != 0 && data.alphaData != null) {
            transValue = data.getAlpha(x, y);
        }
        boolean trans = false;
        if (transValue < 10) {
            trans = true;
        }
        return trans;
    }

    private static class RenderingListenerImpl
    implements RenderingListener {
        boolean done = false;

        boolean isDone() {
            return this.done;
        }

        public void paintFigureWhileRendering(Graphics g) {
        }

        public synchronized void imageRendered(RenderedImage rndImg) {
            this.done = true;
            SVGImageTest.assertTrue((boolean)rndImg.isRendered());
            SVGImageTest.assertTrue((rndImg.getSWTImage() != null ? 1 : 0) != 0);
        }
    }
}

