/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.graphdef.codegen.ui;

import org.eclipse.pde.ui.templates.BaseOptionTemplateSection;
import org.eclipse.pde.ui.templates.TemplateOption;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FileNameOption
extends TemplateOption {
    private final String[] myExtensions;
    private Text myText;
    private Label myLabelControl;
    private Button myBrowseButton;
    private boolean myIgnoreListener;
    private boolean mySaveNotLoad;

    public FileNameOption(BaseOptionTemplateSection section, String name, String label, String[] extensions) {
        super(section, name, label);
        this.setRequired(true);
        this.myExtensions = extensions;
    }

    public void setSaveNotLoad(boolean saveNotLoad) {
        this.mySaveNotLoad = saveNotLoad;
    }

    public String getText() {
        if (this.getValue() != null) {
            return this.getValue().toString();
        }
        return null;
    }

    public void setText(String newText) {
        this.setValue(newText);
    }

    public void setValue(Object value) {
        super.setValue(value);
        if (this.myText != null) {
            this.myIgnoreListener = true;
            String textValue = this.getText();
            this.myText.setText(textValue != null ? textValue : "");
            this.myIgnoreListener = false;
        }
    }

    public void createControl(Composite parent, int span) {
        this.myLabelControl = this.createLabel(parent, 1);
        this.myLabelControl.setEnabled(this.isEnabled());
        Composite textAndButtonGroup = new Composite(parent, 0);
        GridLayout groupLayout = new GridLayout(2, false);
        groupLayout.marginWidth = 0;
        groupLayout.marginHeight = 0;
        groupLayout.verticalSpacing = 0;
        groupLayout.horizontalSpacing = 5;
        textAndButtonGroup.setLayout((Layout)groupLayout);
        GridData groupLayoutData = new GridData(768);
        groupLayoutData.horizontalSpan = span - 1;
        textAndButtonGroup.setLayoutData((Object)groupLayoutData);
        this.myText = new Text(textAndButtonGroup, 2052);
        GridData textGD = new GridData(768);
        this.myText.setLayoutData((Object)textGD);
        this.myBrowseButton = new Button(textAndButtonGroup, 0);
        GridData buttonGD = new GridData(64);
        this.myBrowseButton.setLayoutData((Object)buttonGD);
        if (this.getValue() != null) {
            this.myText.setText(this.getValue().toString());
        }
        this.myText.setEnabled(this.isEnabled());
        this.myText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FileNameOption.this.myIgnoreListener) {
                    return;
                }
                FileNameOption.super.setValue(FileNameOption.this.myText.getText());
                FileNameOption.this.getSection().validateOptions((TemplateOption)FileNameOption.this);
            }
        });
        this.myBrowseButton.setText("Browse...");
        this.myBrowseButton.setEnabled(this.isEnabled());
        this.myBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(e.display.getActiveShell(), this.getSaveNotLoadDialogStyle() | 0x8000);
                fileDialog.setFilterExtensions(FileNameOption.this.myExtensions);
                FileNameOption.this.setText(fileDialog.open());
                FileNameOption.this.getSection().validateOptions((TemplateOption)FileNameOption.this);
            }

            private int getSaveNotLoadDialogStyle() {
                return FileNameOption.this.isSaveNotLoad() ? 8192 : 4096;
            }
        });
    }

    public boolean isEmpty() {
        return this.getValue() == null || this.getValue().toString().trim().length() == 0;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.myLabelControl != null) {
            this.myLabelControl.setEnabled(enabled);
            this.myText.setEnabled(enabled);
            this.myBrowseButton.setEnabled(enabled);
        }
    }

    private boolean isSaveNotLoad() {
        return this.mySaveNotLoad;
    }
}

