/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.common.ui.internal.action;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.ui.action.ActionManager;
import org.eclipse.gmf.runtime.common.ui.action.ActionManagerChangeEvent;
import org.eclipse.gmf.runtime.common.ui.action.IActionManagerChangeListener;
import org.eclipse.gmf.runtime.common.ui.action.IActionWithProgress;

public class ActionManagerTest
extends TestCase {
    private ActionManagerChangeEvent actionManagerChangeEvent = null;
    private Exception exception = null;
    private Fixture fixture = null;

    public static void main(String[] args) {
        TestRunner.run((Test)ActionManagerTest.suite());
    }

    public static Test suite() {
        return new TestSuite(ActionManagerTest.class);
    }

    public ActionManagerTest(String name) {
        super(name);
    }

    protected ActionManagerChangeEvent getActionManagerChangeEvent() {
        return this.actionManagerChangeEvent;
    }

    protected void setActionManagerChangeEvent(ActionManagerChangeEvent actionManagerChangeEvent) {
        this.actionManagerChangeEvent = actionManagerChangeEvent;
    }

    protected Exception getException() {
        return this.exception;
    }

    protected void setException(Exception exception) {
        this.exception = exception;
    }

    protected Fixture getFixture() {
        return this.fixture;
    }

    protected void setFixture(Fixture fixture) {
        this.fixture = fixture;
    }

    protected void setUp() {
        this.setFixture(new Fixture());
    }

    public void test_add_remove_ActionManagerChangeListener() {
        IActionManagerChangeListener listener = new IActionManagerChangeListener(){

            public void actionManagerChanged(ActionManagerChangeEvent event) {
                ActionManagerTest.this.setActionManagerChangeEvent(event);
            }
        };
        ActionManagerTest.assertNull((Object)this.getActionManagerChangeEvent());
        this.getFixture().addActionManagerChangeListener(listener);
        this.getFixture().fireActionManagerChange(new ActionManagerChangeEvent((ActionManager)this.getFixture()));
        ActionManagerTest.assertNotNull((Object)this.getActionManagerChangeEvent());
        ActionManagerTest.assertSame((Object)((Object)this.getFixture()), (Object)this.getActionManagerChangeEvent().getSource());
        this.setActionManagerChangeEvent(null);
        this.getFixture().removeActionManagerChangeListener(listener);
        this.getFixture().fireActionManagerChange(new ActionManagerChangeEvent((ActionManager)this.getFixture()));
        ActionManagerTest.assertNull((Object)this.getActionManagerChangeEvent());
    }

    public void test_fireActionManagerChange() {
        final IActionManagerChangeListener[] listeners = new IActionManagerChangeListener[99];
        int i = 0;
        while (i < 99) {
            listeners[i] = new IActionManagerChangeListener(){

                public void actionManagerChanged(ActionManagerChangeEvent event) {
                }
            };
            ++i;
        }
        Thread addThread = new Thread(new Runnable(){

            public void run() {
                int i = 0;
                while (i < 99) {
                    ActionManagerTest.this.getFixture().addActionManagerChangeListener(listeners[i]);
                    if (ActionManagerTest.this.getException() != null) break;
                    ++i;
                }
            }
        });
        addThread.start();
        Thread fireThread = new Thread(new Runnable(){

            public void run() {
                ActionManagerChangeEvent event = new ActionManagerChangeEvent((ActionManager)ActionManagerTest.this.getFixture());
                try {
                    int i = 0;
                    while (i < 99) {
                        ActionManagerTest.this.getFixture().fireActionManagerChange(event);
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {}
                        ++i;
                    }
                }
                catch (Exception e) {
                    ActionManagerTest.this.setException(e);
                }
            }
        });
        fireThread.start();
        Thread removeThread = new Thread(new Runnable(){

            public void run() {
                int i = 0;
                while (i < 99) {
                    ActionManagerTest.this.getFixture().removeActionManagerChangeListener(listeners[i]);
                    if (ActionManagerTest.this.getException() != null) break;
                    ++i;
                }
            }
        });
        removeThread.start();
        try {
            fireThread.join();
        }
        catch (InterruptedException ie) {
            this.setException(ie);
        }
        if (this.getException() != null) {
            ActionManagerTest.fail();
        }
    }

    public void test_clear() {
        ActionManagerTest.assertNull((Object)this.getFixture().getFixtureAction());
        this.getFixture().setFixtureAction(new RepeatableAction(this.getName(), true));
        ActionManagerTest.assertNotNull((Object)this.getFixture().getFixtureAction());
        this.getFixture().clear();
        ActionManagerTest.assertNull((Object)this.getFixture().getFixtureAction());
    }

    public void test_run() {
        ActionManagerTest.assertNull((Object)this.getFixture().getFixtureAction());
        try {
            this.getFixture().run(new RepeatableAction(this.getName(), false));
            ActionManagerTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            ActionManagerTest.assertNull((Object)this.getFixture().getFixtureAction());
        }
        RepeatableAction action = new RepeatableAction(this.getName(), true);
        try {
            this.getFixture().run(action);
            ActionManagerTest.assertSame((Object)action, (Object)this.getFixture().getFixtureAction());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            ActionManagerTest.fail();
        }
        try {
            this.getFixture().run(new RepeatableAction(this.getName(), false));
            ActionManagerTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            ActionManagerTest.assertSame((Object)action, (Object)this.getFixture().getFixtureAction());
        }
        action = new RepeatableAction(this.getName(), true);
        try {
            this.getFixture().run(action);
            ActionManagerTest.assertSame((Object)action, (Object)this.getFixture().getFixtureAction());
        }
        catch (Exception exception) {
            ActionManagerTest.fail();
        }
    }

    protected static class Fixture
    extends ActionManager {
        public Fixture() {
            super(OperationHistoryFactory.getOperationHistory());
        }

        protected IActionWithProgress getFixtureAction() {
            return super.getAction();
        }

        protected void setFixtureAction(IActionWithProgress action) {
            super.setAction(action);
        }

        protected void fireActionManagerChange(ActionManagerChangeEvent event) {
            super.fireActionManagerChange(event);
        }
    }

    protected static class RepeatableAction
    implements IActionWithProgress {
        private final String label;
        private final boolean runnable;

        public RepeatableAction(String label, boolean runnable) {
            this.label = label;
            this.runnable = runnable;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean isRunnable() {
            return this.runnable;
        }

        public void refresh() {
        }

        public void run(IProgressMonitor progressMonitor) {
        }

        public IActionWithProgress.WorkIndicatorType getWorkIndicatorType() {
            return IActionWithProgress.WorkIndicatorType.NONE;
        }

        public boolean setup() {
            return true;
        }
    }
}

