/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.commands;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.util.Assert;

public class CreateCommand
extends AbstractTransactionalCommand {
    protected final CreateViewRequest.ViewDescriptor viewDescriptor;
    protected final View containerView;

    public CreateCommand(TransactionalEditingDomain editingDomain, CreateViewRequest.ViewDescriptor viewDescriptor, View containerView) {
        super(editingDomain, DiagramUIMessages.CreateCommand_Label, CreateCommand.getWorkspaceFiles((EObject)containerView));
        Assert.isNotNull((Object)viewDescriptor);
        Assert.isNotNull((Object)containerView);
        this.viewDescriptor = viewDescriptor;
        this.containerView = containerView;
        this.setResult(CommandResult.newOKCommandResult((Object)viewDescriptor));
    }

    protected CreateViewRequest.ViewDescriptor getViewDescriptor() {
        return this.viewDescriptor;
    }

    protected View getContainerView() {
        return this.containerView;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        View view = ViewService.getInstance().createView(this.viewDescriptor.getViewKind(), this.viewDescriptor.getElementAdapter(), this.containerView, this.viewDescriptor.getSemanticHint(), this.viewDescriptor.getIndex(), this.viewDescriptor.isPersisted(), this.viewDescriptor.getPreferencesHint());
        Assert.isNotNull((Object)view, (String)"failed to create a view");
        this.viewDescriptor.setView(view);
        return CommandResult.newOKCommandResult((Object)this.viewDescriptor);
    }

    public boolean canExecute() {
        return ViewService.getInstance().provides(this.viewDescriptor.getViewKind(), this.viewDescriptor.getElementAdapter(), this.containerView, this.viewDescriptor.getSemanticHint(), this.viewDescriptor.getIndex(), this.viewDescriptor.isPersisted(), this.viewDescriptor.getPreferencesHint());
    }

    public boolean isPersisted() {
        return this.getViewDescriptor().isPersisted();
    }

    public List getAffectedFiles() {
        if (this.isPersisted()) {
            return super.getAffectedFiles();
        }
        return Collections.EMPTY_LIST;
    }
}

