/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.migrate;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.SAXXMIHandler;
import org.eclipse.emf.ecore.xmi.impl.XMILoadImpl;
import org.eclipse.gmf.internal.common.ToolingResourceFactory;
import org.eclipse.gmf.internal.common.migrate.Messages;
import org.eclipse.gmf.internal.common.migrate.MigrationHelper;
import org.eclipse.gmf.internal.common.migrate.MigrationHelperDelegate;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MigrationResource
extends ToolingResourceFactory.ToolResource {
    private boolean isOldVersionDetected;
    private MigrationHelper myMigrationHelper;

    protected MigrationResource(URI uri) {
        super(uri);
    }

    public final void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        try {
            this.isOldVersionDetected = false;
            super.doLoad(inputStream, options);
            this.handlePostLoadSuccess();
        }
        catch (IOException e) {
            this.handlePostLoadException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.handlePostLoadException(e);
            throw e;
        }
    }

    protected XMLLoad createXMLLoad() {
        return new XMILoadImpl(this.createXMLHelper()){

            protected DefaultHandler makeDefaultHandler() {
                return new SAXXMIHandler(this.resource, this.helper, this.options){

                    protected EPackage getPackageForURI(String uriString) {
                        if (!MigrationResource.this.getMetamodelNsURI().equals(uriString) && MigrationResource.this.getBackwardSupportedURIs().contains(uriString)) {
                            MigrationResource.this.handleOldVersionDetected();
                            return super.getPackageForURI(MigrationResource.this.getMetamodelNsURI());
                        }
                        return super.getPackageForURI(uriString);
                    }
                };
            }
        };
    }

    private void handleOldVersionDetected() {
        if (this.myMigrationHelper != null) {
            this.myMigrationHelper.enableDelegate(true);
        }
        this.isOldVersionDetected = true;
    }

    protected void handlePostLoadSuccess() {
        if (this.isOldVersionDetected) {
            Diagnostic diagnostic = MigrationResource.createMessageDiagnostic((Resource)this, Messages.oldModelVersionLoadedMigrationRequired);
            this.getWarnings().add(0, (Object)diagnostic);
        }
    }

    protected void handlePostLoadException(Exception e) {
        Diagnostic diagnostic = MigrationResource.createMessageDiagnostic((Resource)this, Messages.oldModelVersionLoadErrorMigrationMayBeRequired);
        this.getErrors().add(0, (Object)diagnostic);
    }

    protected XMLHelper createXMLHelper() {
        MigrationHelperDelegate delegate = this.createDelegate();
        assert (delegate != null);
        this.myMigrationHelper = new MigrationHelper((XMLResource)this, delegate);
        return this.myMigrationHelper;
    }

    protected abstract Collection<String> getBackwardSupportedURIs();

    protected abstract MigrationHelperDelegate createDelegate();

    protected abstract String getMetamodelNsURI();

    private static Diagnostic createMessageDiagnostic(Resource resource, String message) {
        String location = resource.getURI() == null ? null : resource.getURI().toString();
        return new Diagnostic(message, location);
    }

    public static class Diagnostic
    implements Resource.Diagnostic {
        private final String myMessage;
        private final String myLocation;

        Diagnostic(String message, String location) {
            this.myMessage = message;
            this.myLocation = location;
        }

        public String getMessage() {
            return this.myMessage;
        }

        public String getLocation() {
            return this.myLocation;
        }

        public int getColumn() {
            return 0;
        }

        public int getLine() {
            return 0;
        }
    }
}

