/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.codegen;

import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.gmf.internal.common.Activator;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PluginXMLTextMerger {
    private static final String ATTR_POINT = "point";
    private static final String ELEM_EXTENSION = "extension";
    private static final String ELEM_EXTENSION_START = "<extension";
    private static final String ELEM_EXTENSION_END = "</extension>";
    private static final String ELEM_PLUGIN = "plugin";
    private static final String ELEM_PLUGIN_END = "</plugin>";
    private static final String COMMENT_START = "<!--";
    private static final String COMMENT_END = "-->";
    private final String myPITag;
    private SAXParserFactory factory;

    public PluginXMLTextMerger(String piTarget, String piAttrName, String piAttrValue) {
        this.myPITag = MessageFormat.format("<?{0} {1}=\"{2}\"?>", piTarget, piAttrName, piAttrValue);
    }

    public boolean isRecognizedDocument(String xml) {
        try {
            ParsedPluginXML doc = this.parseDocument(xml);
            return doc != null && doc.getExtensionsStart() > 0 & doc.getExtensionsEnd() >= doc.getExtensionsStart();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String process(String oldXML, String newXML) {
        ParsedPluginXML oldDoc;
        ParsedPluginXML newDoc;
        try {
            newDoc = this.parseDocument(newXML);
        }
        catch (Exception e) {
            this.logException("Generated plugin.xml is invalid. Existing plugin.xml will be kept", e);
            return oldXML;
        }
        try {
            oldDoc = this.parseDocument(oldXML);
        }
        catch (Exception e) {
            this.logException("Existing plugin.xml is invalid and will be replaced with generated one", e);
            return newXML;
        }
        String result = this.mergeDocuments(oldDoc, newDoc);
        try {
            this.parseDocument(result);
        }
        catch (Exception e) {
            this.logException("Merged plugin.xml is invalid and will be replaced with generated one", e);
            return newXML;
        }
        return result;
    }

    private ParsedPluginXML parseDocument(String xml) throws SAXException, ParserConfigurationException, IOException {
        ParsedPluginXML pluginXML = new ParsedPluginXML(xml, this.myPITag);
        InputSource is = new InputSource(new StringReader(xml));
        this.getParserFactory().newSAXParser().parse(is, (DefaultHandler)pluginXML);
        return pluginXML;
    }

    private SAXParserFactory getParserFactory() {
        if (this.factory == null) {
            this.factory = SAXParserFactory.newInstance();
        }
        return this.factory;
    }

    private String mergeDocuments(ParsedPluginXML oldDoc, ParsedPluginXML newDoc) {
        StringBuilder result = new StringBuilder();
        int currentPosition = oldDoc.getExtensionsStart() - 1;
        String oldXML = oldDoc.getXML();
        result.append(oldXML.substring(0, currentPosition));
        int length = oldXML.length();
        while (currentPosition < length) {
            boolean afterStart;
            int key = currentPosition;
            ExtensionDescriptor oldED = oldDoc.getExtensionByStart(key);
            if (oldED == null) {
                result.append(oldXML.charAt(currentPosition));
                ++currentPosition;
            } else {
                List<ExtensionDescriptor> newEDs = newDoc.getExtensionsByPoint(oldED.pointName);
                if (oldED.generated) {
                    if (newEDs == null) {
                        currentPosition = oldED.endLine;
                        oldED.remove();
                    } else {
                        ExtensionDescriptor newED = newEDs.get(0);
                        result.append(newED.getText());
                        currentPosition = oldED.endLine;
                        oldED.remove();
                        newED.remove();
                    }
                } else {
                    result.append(oldED.getText());
                    currentPosition += oldED.getTextLength();
                    oldED.remove();
                    if (newEDs != null && !oldDoc.hasGeneratedExtension(oldED.pointName)) {
                        ExtensionDescriptor newED = newEDs.get(0);
                        newED.remove();
                    }
                }
            }
            if (!oldDoc.getExtensions().isEmpty() || newDoc.getExtensions().isEmpty()) continue;
            boolean sameStartEnd = oldDoc.getExtensionsStart() == oldDoc.getExtensionsEnd();
            boolean bl = afterStart = currentPosition >= oldDoc.getExtensionsStart();
            if (!afterStart || !sameStartEnd && currentPosition >= oldDoc.getExtensionsEnd()) continue;
            List<ExtensionDescriptor> newEDs = newDoc.getExtensions();
            for (ExtensionDescriptor newED : newEDs) {
                result.append(newED.getText());
                newED.remove();
                result.append(PluginXMLTextMerger.getPlatformNewLine());
            }
        }
        return result.toString();
    }

    protected void logException(String message, Exception e) {
        Activator.logError(message, e);
    }

    private static String getPlatformNewLine() {
        return System.getProperties().getProperty("line.separator");
    }

    private static class ExtensionDescriptor {
        private final ParsedPluginXML parsedDoc;
        String pointName;
        final boolean generated;
        private final int startLine;
        private final int endLine;

        ExtensionDescriptor(ParsedPluginXML parsedPluginXml, int start, int end, boolean isGenerated) {
            this.parsedDoc = parsedPluginXml;
            this.startLine = start;
            this.endLine = end;
            this.generated = isGenerated;
        }

        String getText() {
            return this.parsedDoc.getXML().substring(this.startLine, this.endLine);
        }

        int getTextLength() {
            return this.endLine - this.startLine;
        }

        void remove() {
            this.parsedDoc.removeExtension(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParsedPluginXML
    extends DefaultHandler {
        private final String myXML;
        private String myGeneratedToken;
        private int myPluginEnd;
        private final Map<String, List<ExtensionDescriptor>> myPoint2ExtensionsMap;
        private final SortedMap<Integer, ExtensionDescriptor> myStart2ExtensionMap;
        private Iterator<ExtensionDescriptor> myIterator;
        private final int myCachedExtStart;

        ParsedPluginXML(String xml, String generatedToken) {
            this.myXML = xml;
            this.myGeneratedToken = generatedToken;
            this.myPoint2ExtensionsMap = new HashMap<String, List<ExtensionDescriptor>>();
            this.myStart2ExtensionMap = new TreeMap<Integer, ExtensionDescriptor>();
            this.parse(xml);
            this.myCachedExtStart = this.myStart2ExtensionMap.size() > 0 ? this.myStart2ExtensionMap.firstKey() : this.myPluginEnd;
        }

        private void parse(String xml) {
            int currentIndex = 0;
            int length = xml.length();
            this.myPluginEnd = xml.lastIndexOf(PluginXMLTextMerger.ELEM_PLUGIN_END);
            while (currentIndex < length) {
                int extensionStart = this.getStartIndex(xml, PluginXMLTextMerger.ELEM_EXTENSION_START, currentIndex);
                if (extensionStart == length - 1) break;
                currentIndex = this.isInsideComment(xml, extensionStart) ? extensionStart + PluginXMLTextMerger.ELEM_EXTENSION_START.length() : (!Character.isWhitespace(xml.charAt(extensionStart + PluginXMLTextMerger.ELEM_EXTENSION_START.length())) ? extensionStart + PluginXMLTextMerger.ELEM_EXTENSION_START.length() : this.processExtensonBlock(xml, extensionStart));
            }
        }

        private int processExtensonBlock(String xml, int fromIndex) {
            int extensionStart = fromIndex;
            int extensionEnd = this.getStartIndex(xml, PluginXMLTextMerger.ELEM_EXTENSION_END, fromIndex) + PluginXMLTextMerger.ELEM_EXTENSION_END.length();
            while (this.isInsideComment(xml, extensionEnd)) {
                extensionEnd = this.getStartIndex(xml, PluginXMLTextMerger.ELEM_EXTENSION_END, extensionEnd) + PluginXMLTextMerger.ELEM_EXTENSION_END.length();
            }
            boolean isGenerated = this.isGenerated(xml, extensionStart, extensionEnd);
            ExtensionDescriptor ed = new ExtensionDescriptor(this, extensionStart, extensionEnd, isGenerated);
            this.myStart2ExtensionMap.put(ed.startLine, ed);
            return extensionEnd;
        }

        private boolean isGenerated(String xml, int extensionStart, int extensionEnd) {
            int genStart = this.getStartIndex(xml, this.myGeneratedToken, extensionStart);
            while (genStart < extensionEnd) {
                if (!this.isInsideComment(xml, genStart)) {
                    return true;
                }
                genStart = this.getStartIndex(xml, this.myGeneratedToken, genStart + this.myGeneratedToken.length());
            }
            return false;
        }

        private int getStartIndex(String xml, String token, int fromIndex) {
            int commentStart = xml.indexOf(token, fromIndex);
            return commentStart < 0 ? xml.length() - 1 : commentStart;
        }

        private boolean isInsideComment(String xml, int fromIndex) {
            int lastOpened = xml.lastIndexOf(PluginXMLTextMerger.COMMENT_START, fromIndex);
            if (lastOpened < 0) {
                return false;
            }
            int lastClosed = xml.lastIndexOf(PluginXMLTextMerger.COMMENT_END, fromIndex);
            return lastClosed <= lastOpened || lastClosed >= fromIndex;
        }

        List<ExtensionDescriptor> getExtensionsByPoint(String point) {
            List<ExtensionDescriptor> list = this.myPoint2ExtensionsMap.get(point);
            return list;
        }

        ExtensionDescriptor getExtensionByStart(int start) {
            return (ExtensionDescriptor)this.myStart2ExtensionMap.get(start);
        }

        void removeExtension(ExtensionDescriptor ed) {
            this.myStart2ExtensionMap.remove(ed.startLine);
            List<ExtensionDescriptor> list = this.getExtensionsByPoint(ed.pointName);
            if (list != null) {
                list.remove(ed);
                if (list.size() == 0) {
                    this.myPoint2ExtensionsMap.remove(ed.pointName);
                }
            }
        }

        boolean hasGeneratedExtension(String point) {
            List<ExtensionDescriptor> list = this.getExtensionsByPoint(point);
            if (list != null && list.size() > 0) {
                for (ExtensionDescriptor ed : list) {
                    if (!ed.generated) continue;
                    return true;
                }
            }
            return false;
        }

        List<ExtensionDescriptor> getExtensions() {
            return new ArrayList<ExtensionDescriptor>(this.myStart2ExtensionMap.values());
        }

        int getExtensionsStart() {
            if (this.myStart2ExtensionMap.size() > 0) {
                return this.myStart2ExtensionMap.firstKey();
            }
            return this.myCachedExtStart;
        }

        int getExtensionsEnd() {
            if (this.myStart2ExtensionMap.size() > 0) {
                ExtensionDescriptor ed = (ExtensionDescriptor)this.myStart2ExtensionMap.get(this.myStart2ExtensionMap.lastKey());
                return ed.endLine;
            }
            return this.myPluginEnd;
        }

        String getXML() {
            return this.myXML;
        }

        @Override
        public void startDocument() throws SAXException {
            this.myIterator = this.myStart2ExtensionMap.values().iterator();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String pointName;
            if (PluginXMLTextMerger.ELEM_EXTENSION.equals(qName) && (pointName = attributes.getValue(PluginXMLTextMerger.ATTR_POINT)) != null && this.myIterator != null && this.myIterator.hasNext()) {
                ExtensionDescriptor ed = this.myIterator.next();
                ed.pointName = pointName;
                List<ExtensionDescriptor> list = this.getExtensionsByPoint(ed.pointName);
                if (list == null) {
                    list = new ArrayList<ExtensionDescriptor>();
                    this.myPoint2ExtensionsMap.put(ed.pointName, list);
                }
                list.add(ed);
            }
        }

        @Override
        public void endDocument() throws SAXException {
            this.myIterator = null;
        }
    }
}

