/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.codegen.popup.actions;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.importer.ui.EMFModelWizard;
import org.eclipse.gmf.internal.bridge.genmodel.BasicGenModelAccess;
import org.eclipse.gmf.internal.bridge.genmodel.DummyGenModel;
import org.eclipse.gmf.internal.bridge.genmodel.FileGenModelAccess;
import org.eclipse.gmf.internal.bridge.genmodel.GenModelAccess;
import org.eclipse.gmf.internal.codegen.CodeGenUIPlugin;
import org.eclipse.gmf.internal.codegen.popup.actions.LinkMessageDialog;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GenModelDetector {
    private GenModelAccess myGMAccess;
    private final IFile myPatternResource;

    public GenModelDetector(IFile patternResource) {
        assert (patternResource != null);
        this.myPatternResource = patternResource;
    }

    public IStatus find(Shell shell, Mapping mapping) {
        IFile workspaceFile;
        HashSet<EPackage> packages = new HashSet<EPackage>();
        for (Object next : EcoreUtil.ExternalCrossReferencer.find((EObject)mapping).keySet()) {
            if (!(next instanceof EClass)) continue;
            packages.add(((EClass)next).getEPackage());
        }
        Iterator<Object> it = packages.iterator();
        while (it.hasNext()) {
            Object next;
            next = (EPackage)it.next();
            if (next.getESuperPackage() == null || !EcoreUtil.isAncestor(packages, (EObject)next.getESuperPackage())) continue;
            it.remove();
        }
        if (packages.isEmpty()) {
            this.myGMAccess = new GenModelAccess.Adapter(null);
            return Status.OK_STATUS;
        }
        if (packages.size() == 1) {
            EPackage solePack = (EPackage)packages.iterator().next();
            BasicGenModelAccess gma = new BasicGenModelAccess(solePack);
            gma.initDefault();
            if (gma.load((ResourceSet)new ResourceSetImpl()).isOK()) {
                gma.unload();
                this.myGMAccess = gma;
                return Status.OK_STATUS;
            }
            workspaceFile = this.suggestCreateDefaultGenModel(shell, packages);
        } else {
            workspaceFile = this.askGenModelFile(shell, "Need genmodel to cover all referenced domain packages (" + packages.size() + ")");
        }
        if (workspaceFile == null) {
            return Status.CANCEL_STATUS;
        }
        this.myGMAccess = new FileGenModelAccess(workspaceFile);
        return Status.OK_STATUS;
    }

    private IFile askGenModelFile(Shell shell, String message) {
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof IFile) || "genmodel".equals(((IFile)element).getFileExtension());
            }
        };
        IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)shell, null, (String)message, (boolean)false, (Object[])new Object[]{this.myPatternResource.getParent()}, Collections.singletonList(filter));
        if (files.length > 0) {
            return files[0];
        }
        return null;
    }

    public GenModel get(ResourceSet resSet) {
        IStatus s = this.myGMAccess.load(resSet);
        if (!s.isOK()) {
            throw new IllegalStateException(s.getMessage());
        }
        return this.myGMAccess.model();
    }

    private IFile suggestCreateDefaultGenModel(Shell shell, final Collection<EPackage> packages) {
        final IPath[] result = new IPath[1];
        int dlgRes = new LinkMessageDialog(shell, GenModelDetector.createDialogConfig()){

            protected void dispatchLinkSelected(String linkHref) {
                if ("link2".equals(linkHref)) {
                    this.launchEMFWizard();
                } else if ("link1".equals(linkHref)) {
                    this.createDefault();
                }
            }

            private void launchEMFWizard() {
                EMFModelWizard wizard = new EMFModelWizard(){

                    public boolean performFinish() {
                        result[0] = this.genModelContainerPath.append(this.genModelFileName);
                        return super.performFinish();
                    }
                };
                wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)GenModelDetector.this.createSelectionForEMFWizard());
                if (new WizardDialog(this.getShell(), (IWizard)wizard).open() == 0) {
                    if (!$assertionsDisabled && result[0] == null) {
                        throw new AssertionError();
                    }
                    this.closeWithCode(178);
                }
            }

            private void createDefault() {
                LinkedList pp = new LinkedList(packages);
                EPackage primaryPackage = (EPackage)pp.removeFirst();
                DummyGenModel gma = new DummyGenModel(primaryPackage, pp);
                gma.setPluginID(GenModelDetector.this.myPatternResource.getProject().getName());
                GenModel model = gma.create();
                result[0] = GenModelDetector.this.createDefaultResourcePath();
                Resource res = new ResourceSetImpl().createResource(URI.createPlatformResourceURI((String)result[0].toString(), (boolean)true));
                res.getContents().add((Object)model);
                try {
                    res.save(null);
                    this.closeWithCode(178);
                }
                catch (IOException ex) {
                    CodeGenUIPlugin.getDefault().getLog().log(CodeGenUIPlugin.createError("Can't save created genmodel", ex));
                }
            }

            private void closeWithCode(int code) {
                this.setReturnCode(code);
                this.close();
            }
        }.open();
        if (dlgRes == 0) {
            if (packages.size() == 1) {
                EPackage pkg = packages.iterator().next();
                return this.askGenModelFile(shell, "Can't find genmodel for package " + pkg.getName() + "(" + pkg.getNsURI() + ")");
            }
            return this.askGenModelFile(shell, "Need genmodel to cover all referenced domain packages (" + packages.size() + ")");
        }
        if (dlgRes == 178) {
            assert (result[0] != null);
            return ResourcesPlugin.getWorkspace().getRoot().getFile(result[0]);
        }
        assert (dlgRes == 1);
        return null;
    }

    private StructuredSelection createSelectionForEMFWizard() {
        IContainer parent = this.myPatternResource.getParent();
        IFile neighbour = parent.getFile(new Path(this.myPatternResource.getName()).removeFileExtension().addFileExtension("ecore"));
        if (neighbour.exists()) {
            return new StructuredSelection((Object)neighbour);
        }
        return new StructuredSelection((Object)this.myPatternResource);
    }

    private IPath createDefaultResourcePath() {
        return this.myPatternResource.getFullPath().removeFileExtension().addFileExtension("genmodel");
    }

    private static LinkMessageDialog.Config createDialogConfig() {
        LinkMessageDialog.Config cfg = new LinkMessageDialog.Config();
        cfg.title = CodeGenUIPlugin.getBundleString("detectgenmodel.title");
        cfg.message = CodeGenUIPlugin.getBundleString("detectgenmodel.question");
        cfg.buttonLabels = new String[]{CodeGenUIPlugin.getBundleString("detectgenmodel.browse"), IDialogConstants.CANCEL_LABEL};
        cfg.imageType = 3;
        return cfg;
    }
}

