/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.merge.api;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.compare.diff.merge.api.EMFCompareEObjectCopier;
import org.eclipse.emf.compare.diff.merge.api.IMerger;
import org.eclipse.emf.compare.diff.merge.service.MergeService;
import org.eclipse.emf.compare.diff.metamodel.ConflictingDiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelInputSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChange;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeRightTarget;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;

public class DefaultMerger
implements IMerger {
    protected DiffElement diff;
    protected Resource leftResource;
    protected Resource rightResource;

    public void applyInOrigin() {
        this.handleMutuallyDerivedReferences();
        this.removeFromContainer(this.diff);
    }

    public boolean canApplyInOrigin() {
        return true;
    }

    public boolean canUndoInTarget() {
        return true;
    }

    public void setDiffElement(DiffElement element) {
        this.diff = element;
    }

    public void undoInTarget() {
        this.handleMutuallyDerivedReferences();
        this.removeFromContainer(this.diff);
    }

    protected void cleanDiffGroup(DiffGroup diffGroup) {
        EObject parent;
        if (diffGroup != null && diffGroup.getSubchanges() == 0 && (parent = diffGroup.eContainer()) != null && parent instanceof DiffGroup) {
            EcoreUtil.remove((EObject)diffGroup);
            this.cleanDiffGroup((DiffGroup)parent);
        }
    }

    protected EObject copy(EObject eObject) {
        EMFCompareEObjectCopier copier = MergeService.getCopier(this.diff);
        EObject result = copier.copy(eObject);
        copier.copyReferences();
        copier.copyXMIIDs();
        return result;
    }

    protected Resource findLeftResource() {
        if (this.leftResource == null) {
            MatchModel match = ((ModelInputSnapshot)EcoreUtil.getRootContainer((EObject)this.diff)).getMatch();
            for (Match2Elements element : match.getMatchedElements()) {
                if (element.getLeftElement() == null) continue;
                this.leftResource = element.getLeftElement().eResource();
            }
        }
        return this.leftResource;
    }

    protected Resource findRightResource() {
        if (this.rightResource == null) {
            MatchModel match = ((ModelInputSnapshot)EcoreUtil.getRootContainer((EObject)this.diff)).getMatch();
            for (Match2Elements element : match.getMatchedElements()) {
                if (element.getRightElement() == null) continue;
                this.rightResource = element.getRightElement().eResource();
            }
        }
        return this.rightResource;
    }

    protected DiffModel getDiffModel() {
        EObject container = this.diff.eContainer();
        while (container != null) {
            if (container instanceof DiffModel) {
                return (DiffModel)container;
            }
            container = container.eContainer();
        }
        return null;
    }

    protected String getXMIID(EObject object) {
        String objectID = null;
        if (object != null && object.eResource() instanceof XMIResource) {
            objectID = ((XMIResource)object.eResource()).getID(object);
        }
        return objectID;
    }

    protected void removeDanglingReferences(EObject deletedObject) {
        EObject root = EcoreUtil.getRootContainer((EObject)deletedObject);
        if (root instanceof ModelInputSnapshot) {
            root = ((ModelInputSnapshot)root).getDiff();
        }
        if (root != null) {
            EcoreUtil.CrossReferencer referencer = new EcoreUtil.CrossReferencer(root.eResource()){
                private static final long serialVersionUID = 616050158241084372L;
                {
                    this.crossReference();
                }

                protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
                    if (eReference.isChangeable() && !eReference.isDerived()) {
                        return crossReferencedEObject.eResource() == null;
                    }
                    return false;
                }
            };
            for (Map.Entry entry : referencer.entrySet()) {
                Iterator j = ((Collection)entry.getValue()).iterator();
                while (j.hasNext()) {
                    EcoreUtil.remove((EStructuralFeature.Setting)((EStructuralFeature.Setting)j.next()), entry.getKey());
                }
            }
        }
    }

    protected void removeFromContainer(DiffElement diffElement) {
        EObject parent = diffElement.eContainer();
        EcoreUtil.remove((EObject)diffElement);
        this.removeDanglingReferences(parent);
        if (parent instanceof ConflictingDiffElement) {
            this.removeFromContainer((DiffElement)parent);
        }
        if (parent instanceof DiffGroup) {
            this.cleanDiffGroup((DiffGroup)parent);
        }
    }

    protected void setXMIID(EObject object, String id) {
        if (object != null && object.eResource() instanceof XMIResource) {
            ((XMIResource)object.eResource()).setID(object, id);
        }
    }

    private void handleMutuallyDerivedReferences() {
        DiffElement toRemove = null;
        if (this.diff instanceof ReferenceChange) {
            EReference reference = ((ReferenceChange)this.diff).getReference();
            block0 : switch (reference.getFeatureID()) {
                case 10: {
                    EObject referenceType = this.diff instanceof ReferenceChangeLeftTarget ? ((ReferenceChangeLeftTarget)this.diff).getLeftRemovedTarget() : ((ReferenceChangeRightTarget)this.diff).getRightAddedTarget();
                    for (DiffElement siblingDiff : ((DiffGroup)this.diff.eContainer()).getSubDiffElements()) {
                        if (siblingDiff instanceof ModelElementChangeLeftTarget) {
                            if (!(((ModelElementChangeLeftTarget)siblingDiff).getLeftElement() instanceof EGenericType) || ((EGenericType)((ModelElementChangeLeftTarget)siblingDiff).getLeftElement()).getEClassifier() != referenceType) continue;
                            toRemove = siblingDiff;
                            break block0;
                        }
                        if (!(siblingDiff instanceof ModelElementChangeRightTarget) || !(((ModelElementChangeRightTarget)siblingDiff).getRightElement() instanceof EGenericType) || ((EGenericType)((ModelElementChangeRightTarget)siblingDiff).getRightElement()).getEClassifier() != referenceType) continue;
                        toRemove = siblingDiff;
                        break block0;
                    }
                }
            }
        } else if (this.diff instanceof ModelElementChangeLeftTarget && ((ModelElementChangeLeftTarget)this.diff).getLeftElement() instanceof EGenericType) {
            ModelElementChangeLeftTarget theDiff = (ModelElementChangeLeftTarget)this.diff;
            EClassifier referenceType = ((EGenericType)theDiff.getLeftElement()).getEClassifier();
            for (DiffElement siblingDiff : ((DiffGroup)this.diff.eContainer()).getSubDiffElements()) {
                if (!(siblingDiff instanceof ReferenceChangeLeftTarget) || ((ReferenceChangeLeftTarget)siblingDiff).getReference().getFeatureID() != 10 || ((ReferenceChangeLeftTarget)siblingDiff).getLeftRemovedTarget() != referenceType) continue;
                toRemove = siblingDiff;
                break;
            }
        } else if (this.diff instanceof ModelElementChangeRightTarget && ((ModelElementChangeRightTarget)this.diff).getRightElement() instanceof EGenericType) {
            ModelElementChangeRightTarget theDiff = (ModelElementChangeRightTarget)this.diff;
            EClassifier referenceType = ((EGenericType)theDiff.getRightElement()).getEClassifier();
            for (DiffElement siblingDiff : ((DiffGroup)this.diff.eContainer()).getSubDiffElements()) {
                if (!(siblingDiff instanceof ReferenceChangeRightTarget) || ((ReferenceChangeRightTarget)siblingDiff).getReference().getFeatureID() != 10 || ((ReferenceChangeRightTarget)siblingDiff).getRightAddedTarget() != referenceType) continue;
                toRemove = siblingDiff;
                break;
            }
        }
        if (toRemove != null) {
            this.removeFromContainer(toRemove);
        }
    }
}

