/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.utilities.migrator.internal.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.cdo.utilities.migrator.MigratorUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractFileAction
implements IObjectActionDelegate {
    private static final String TITLE = "CDO Migrator Utility";
    private IWorkbenchPart targetPart;
    private IFile currentFile;
    private boolean needClientProject;

    protected AbstractFileAction(boolean needClientProject) {
        this.needClientProject = needClientProject;
    }

    protected IWorkbenchPart getTargetPart() {
        return this.targetPart;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structure = (IStructuredSelection)selection;
            for (Object item : structure) {
                if (!(item instanceof IFile)) continue;
                this.currentFile = (IFile)item;
                break;
            }
        }
    }

    public void run(IAction action) {
        if (this.currentFile == null) {
            this.showError("No file selected.");
            return;
        }
        final String[] msg = new String[1];
        if (!this.needClientProject || this.ensureClientProject()) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        msg[0] = AbstractFileAction.this.doRun(AbstractFileAction.this.currentFile, monitor);
                    }
                    catch (Exception ex) {
                        throw new InvocationTargetException(ex);
                    }
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().run(false, false, op);
                if (msg[0] != null) {
                    this.showMessage(msg[0]);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
                Throwable realException = ex.getTargetException();
                this.showError(realException.getLocalizedMessage());
            }
        }
    }

    protected abstract String doRun(IFile var1, IProgressMonitor var2) throws Exception;

    private boolean ensureClientProject() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("org.eclipse.emf.cdo.client");
        if (project == null || !project.exists()) {
            if (!MessageDialog.openConfirm((Shell)new Shell(), (String)TITLE, (String)"The CDO Client project does not exist in the workspace. Shall it be imported as source plugin?")) {
                return false;
            }
            try {
                if (!MigratorUtil.importClientPlugin()) {
                    return false;
                }
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.showError("An error occured while importing the CDO Client plugin.");
                return false;
            }
        }
        if (!project.isOpen()) {
            if (!MessageDialog.openConfirm((Shell)new Shell(), (String)TITLE, (String)"The CDO Client project exists in the workspace but is not open. Shall it be opened?")) {
                return false;
            }
            try {
                project.open((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ex) {
                ex.printStackTrace();
                this.showError("An error occured while opening the CDO Client project.");
                return false;
            }
        }
        return true;
    }

    protected void showMessage(String msg) {
        MessageDialog.openInformation((Shell)new Shell(), (String)TITLE, (String)msg);
    }

    protected void showError(String msg) {
        MessageDialog.openError((Shell)new Shell(), (String)TITLE, (String)msg);
    }
}

