/*******************************************************************************
 * Copyright (c) 2010 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.ui.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.mint.IJavaTypeReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;

public class FindTypeJob extends Job {
	
	private final ItemJavaElementDescriptor descriptor;
	
	private final IJavaTypeReference ref;
	
	private final UpdateViewerJob updateViewerJob;
	
	public FindTypeJob(ItemJavaElementDescriptor descriptor, IJavaTypeReference ref, UpdateViewerJob updateViewerJob) {
		super(NLS.bind(Messages.FindTypeJob_Name, ref.getTypeName()));
		this.descriptor = descriptor;
		this.ref = ref;
		this.updateViewerJob = updateViewerJob;
		setSystem(true);
	}
	
	@Override
	public boolean belongsTo(Object family) {
		return family == updateViewerJob;
	}

	@Override
	protected IStatus run(IProgressMonitor monitor) {
		try {
			IType type = ref.getContext().findType(ref.getTypeName(), monitor);
			if (monitor.isCanceled())
				return Status.CANCEL_STATUS;
			
			updateViewerJob.addUpdate(descriptor, type);
		} catch (JavaModelException e) {
			return e.getStatus();
		}
		
		return Status.OK_STATUS;
	}
}
