/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda.framework;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.impl.EdgeImpl;
import org.eclipse.emf.henshin.model.impl.NodeImpl;
import org.eclipse.emf.henshin.multicda.cda.conflict.ConflictReason;
import org.eclipse.emf.henshin.multicda.cda.dependency.DependencyReason;
import org.eclipse.emf.henshin.multicda.cda.units.Atom;
import org.eclipse.emf.henshin.multicda.cda.units.Reason;
import org.eclipse.emf.henshin.multicda.cda.units.Span;
import org.eclipse.emf.henshin.multicda.cda.units.SymmetricReason;

public abstract class Condition {
    protected String[] values;

    public Condition(String ... values) {
        this.values = values;
    }

    public boolean proove(GraphElement graphelement) {
        if (this instanceof Edge && graphelement instanceof EdgeImpl) {
            EdgeImpl edge = (EdgeImpl)graphelement;
            return edge.getSource().getName().equals(this.values[0]) && edge.getTarget().getName().equals(this.values[1]);
        }
        if (this instanceof Node && graphelement instanceof NodeImpl) {
            NodeImpl edge = (NodeImpl)graphelement;
            return edge.getName().equals(this.values[0]);
        }
        return false;
    }

    public String toString() {
        String result = "";
        String[] stringArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            result = String.valueOf(result) + ", " + string;
            ++n2;
        }
        return String.valueOf(this.getClass().getSimpleName()) + ":" + " (" + result.substring(2) + ")";
    }

    public int hashCode() {
        int i = 0;
        int m = 11;
        String[] stringArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            i += s.hashCode() * m++;
            ++n2;
        }
        return i;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Condition && obj.getClass() == this.getClass() && ((Condition)obj).values.length == this.values.length) {
            Condition c = (Condition)obj;
            String[] stringArray = this.values;
            int n = this.values.length;
            int n2 = 0;
            while (n2 < n) {
                String v1 = stringArray[n2];
                boolean found = false;
                String[] stringArray2 = c.values;
                int n3 = c.values.length;
                int n4 = 0;
                while (n4 < n3) {
                    String v2 = stringArray2[n4];
                    if (v1.equals(v2)) {
                        found = true;
                        break;
                    }
                    ++n4;
                }
                if (!found) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public static class AtomSize
    extends ReasonSize {
        public AtomSize(int size) {
            super(size);
        }

        @Override
        public String toString() {
            return "(" + this.size + " Atoms)";
        }
    }

    public static class CCR
    extends Conditions {
        public CCR(StateProvider state, Condition ... conditions) {
            super(state, conditions);
        }

        public CCR(Condition ... conditions) {
            super(new StateProvider(new StateProvider[0]), conditions);
        }
    }

    public static class CEDNCR
    extends Conditions {
        public CEDNCR(State state, Condition ... conditions) {
            super(new StateProvider(state == State.Atom ? State.Atom : (state == State.Minimal ? State.Minimal : State.None), new State[0]), conditions);
        }

        public CEDNCR(Condition ... conditions) {
            super(new StateProvider(new StateProvider[0]), conditions);
        }
    }

    public static class ChCR
    extends Conditions {
        public ChCR(StateProvider state, Condition ... conditions) {
            super(state, conditions);
        }

        public ChCR(Condition ... conditions) {
            super(new StateProvider(new StateProvider[0]), conditions);
        }
    }

    public static abstract class Conditions
    implements Provable {
        protected Set<Condition> conditions = new HashSet<Condition>();
        protected StateProvider state;

        public Conditions(StateProvider state, Condition ... conditions) {
            Condition[] conditionArray = conditions;
            int n = conditions.length;
            int n2 = 0;
            while (n2 < n) {
                Condition c = conditionArray[n2];
                if (c instanceof Edge) {
                    this.conditions.add(new Node(c.values[0]));
                    this.conditions.add(new Node(c.values[1]));
                }
                this.conditions.add(c);
                ++n2;
            }
            this.state = state;
        }

        public boolean proove(Span span) {
            span.toString();
            if (span instanceof Atom != this.state.is(State.Atom) || span instanceof Reason && ((Reason)span).isMinimalReason() != this.state.is(State.Minimal) || span.isForbid() != this.state.is(State.Forbid) || span.isRequire() != this.state.is(State.Require) || span.isDependency() != this.state.is(State.Dependency)) {
                return false;
            }
            if ((span instanceof Atom.CreateEdgeDeleteNodeConflictAtom || span instanceof ConflictReason.CreateEdgeDeleteNodeConflictReason) != this instanceof CEDNCR || (span instanceof Atom.DeleteEdgeDeleteNodeDependencyAtom || span instanceof DependencyReason.DeleteEdgeDeleteNodeDependencyReason) != this instanceof DEDNDR) {
                return false;
            }
            ArrayList elements = new ArrayList(span.getGraph().getNodes());
            elements.addAll(span.getGraph().getEdges());
            if (this.sameType(span)) {
                for (Condition condition : this.conditions) {
                    GraphElement toDelete = null;
                    for (GraphElement element : elements) {
                        if (!condition.proove(element)) continue;
                        toDelete = element;
                        break;
                    }
                    if (toDelete != null) {
                        elements.remove(toDelete);
                        continue;
                    }
                    return false;
                }
            }
            return elements.isEmpty();
        }

        private boolean sameType(Span span) {
            boolean result = this.getClass().getSimpleName().startsWith(span.getTag());
            return result &= !(span.getTag().length() == 1 ^ this.getClass().getSimpleName().charAt(1) != 'h');
        }

        public boolean is(StateProvider ... state) {
            return this.state.is(state);
        }

        public boolean is(State ... state) {
            return this.state.is(state);
        }

        @Override
        public StateProvider getState() {
            return this.state;
        }

        public String toString() {
            String result = "";
            for (Condition condition : this.conditions) {
                result = String.valueOf(result) + ", " + condition;
            }
            StateProvider s = this.state;
            String id = this.getClass().getSimpleName();
            id = id.substring(0, id.length() - 2);
            id = String.valueOf(id) + (s.is(State.Dependency) ? "D" : "C") + (s.is(StateProvider.ATOM) ? "A" : "R");
            return String.valueOf(s.is(State.Minimal) ? "M" : "") + (s.is(State.Forbid) ? "F" : (s.is(State.Require) ? "Req" : "")) + id + ":" + " [" + result.substring(2) + "]";
        }
    }

    public static class ConditionsSet
    extends HashSet<Provable>
    implements Provable {
        private static final long serialVersionUID = 1348579384573097L;
        private Set<Span> prooved = new HashSet<Span>();
        private Set<Provable> proovedd = new HashSet<Provable>();
        public final boolean atoms;
        public final boolean minimals;
        public final boolean reasons;

        public ConditionsSet(Conditions ... conditions) {
            this(true, true, true, conditions);
        }

        public ConditionsSet(boolean atoms, boolean minimals, boolean reasons, Conditions ... conditions) {
            this.atoms = atoms;
            this.minimals = minimals;
            this.reasons = reasons;
            Conditions[] conditionsArray = conditions;
            int n = conditions.length;
            int n2 = 0;
            while (n2 < n) {
                Conditions c = conditionsArray[n2];
                this.add(c);
                ++n2;
            }
        }

        public void reset() {
            this.prooved.clear();
            this.proovedd.clear();
        }

        public Set<Provable> getRest() {
            HashSet<Provable> result = new HashSet<Provable>(this);
            result.removeAll(this.proovedd);
            return result;
        }

        @Override
        public boolean remove(Object o) {
            this.proovedd.remove(o);
            return super.remove(o);
        }

        public boolean proove(Span span) {
            if (this.prooved.add(span)) {
                for (Provable p : this) {
                    if (this.proovedd.contains(p) || !p.proove(span)) continue;
                    this.proovedd.add(p);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void clear() {
            super.clear();
            this.reset();
        }

        @Override
        public StateProvider getState() {
            return new StateProvider(new StateProvider[0]);
        }
    }

    public static class DCR
    extends Conditions {
        public DCR(StateProvider state, Condition ... conditions) {
            super(state, conditions);
        }

        public DCR(Condition ... conditions) {
            super(new StateProvider(new StateProvider[0]), conditions);
        }
    }

    public static class DEDNDR
    extends Conditions {
        public DEDNDR(State state, Condition ... conditions) {
            super(new StateProvider(State.Dependency, state == State.Atom ? State.Atom : (state == State.Minimal ? State.Minimal : State.None)), conditions);
        }

        public DEDNDR(Condition ... conditions) {
            super(new StateProvider(State.Dependency, new State[0]), conditions);
        }
    }

    public static class Edge
    extends Condition {
        public Edge(String from, String to) {
            super(from, to);
        }
    }

    public static class MinimalSize
    extends ReasonSize {
        public MinimalSize(int size) {
            super(size);
        }

        @Override
        public String toString() {
            return "(" + this.size + " Minimal Reasons)";
        }
    }

    public static class Node
    extends Condition {
        public Node(String name) {
            super(name);
        }
    }

    public static interface Provable {
        public <T extends Span> boolean proove(T var1);

        public StateProvider getState();
    }

    public static class ReasonSize
    extends Condition
    implements Provable {
        protected int size = 0;

        public ReasonSize() {
            super(new String[0]);
            this.size = 0;
        }

        public ReasonSize(int size) {
            super(new String[0]);
            this.size = size;
        }

        public boolean proove(Integer size) {
            return this.size == size;
        }

        @Override
        public String toString() {
            return "(" + this.size + " Reasons)";
        }

        @Override
        public StateProvider getState() {
            return new StateProvider(new StateProvider[0]);
        }

        @Override
        public <T extends Span> boolean proove(T span) {
            return false;
        }
    }

    public static enum State {
        None(0),
        Minimal(1),
        Require(2),
        Forbid(4),
        Dependency(8),
        Atom(16);

        public final int id;
        public static final int max;

        static {
            max = State.calculateMax();
        }

        private State(int id) {
            this.id = id;
        }

        private static int calculateMax() {
            int result = 0;
            State[] stateArray = State.values();
            int n = stateArray.length;
            int n2 = 0;
            while (n2 < n) {
                State s = stateArray[n2];
                result += s.id;
                ++n2;
            }
            return result;
        }

        public static State getState(int id) {
            State[] stateArray = State.values();
            int n = stateArray.length;
            int n2 = 0;
            while (n2 < n) {
                State s = stateArray[n2];
                if (s.id == id) {
                    return s;
                }
                ++n2;
            }
            return None;
        }
    }

    public static class StateProvider {
        private int state;
        public static final StateProvider DEPENDENCY = new StateProvider(State.Dependency, new State[0]);
        public static final StateProvider MINIMAL = new StateProvider(State.Minimal, new State[0]);
        public static final StateProvider ATOM = new StateProvider(State.Atom, new State[0]);
        public static final StateProvider FORBID = new StateProvider(State.Forbid, new State[0]);
        public static final StateProvider REQUIRE = new StateProvider(State.Require, new State[0]);
        public static final StateProvider ATOM_DEPENDENCY = new StateProvider(ATOM, DEPENDENCY);
        public static final StateProvider ATOM_FORBID = new StateProvider(ATOM, FORBID);
        public static final StateProvider ATOM_REQUIRE = new StateProvider(ATOM, REQUIRE);
        public static final StateProvider ATOM_DEPENDENCY_FORBID = new StateProvider(ATOM_DEPENDENCY, FORBID);
        public static final StateProvider ATOM_DEPENDENCY_REQUIRE = new StateProvider(ATOM_DEPENDENCY, REQUIRE);
        public static final StateProvider MINIMAL_DEPENDENCY = new StateProvider(MINIMAL, DEPENDENCY);
        public static final StateProvider MINIMAL_FORBID = new StateProvider(MINIMAL, FORBID);
        public static final StateProvider MINIMAL_REQUIRE = new StateProvider(MINIMAL, REQUIRE);
        public static final StateProvider MINIMAL_DEPENDENCY_FORBID = new StateProvider(MINIMAL_DEPENDENCY, FORBID);
        public static final StateProvider MINIMAL_DEPENDENCY_REQUIRE = new StateProvider(MINIMAL_DEPENDENCY, REQUIRE);
        public static final StateProvider DEPENDENCY_FORBID = new StateProvider(DEPENDENCY, FORBID);
        public static final StateProvider DEPENDENCY_REQUIRE = new StateProvider(DEPENDENCY, REQUIRE);

        public StateProvider(State state, State ... states) {
            this.state = State.None.id;
            this.state |= state.id;
            State[] stateArray = states;
            int n = states.length;
            int n2 = 0;
            while (n2 < n) {
                State os = stateArray[n2];
                this.state |= os.id;
                ++n2;
            }
            if (this.is(State.Forbid) && this.is(State.Require)) {
                this.state &= State.max - State.Require.id;
            }
        }

        public StateProvider(StateProvider ... states) {
            this.state = State.None.id;
            StateProvider[] stateProviderArray = states;
            int n = states.length;
            int n2 = 0;
            while (n2 < n) {
                StateProvider s = stateProviderArray[n2];
                this.state |= s.hashCode();
                ++n2;
            }
            if (this.is(State.Forbid) && this.is(State.Require)) {
                this.state &= State.max - State.Require.id;
            }
        }

        public boolean is(StateProvider ... state) {
            StateProvider[] stateProviderArray = state;
            int n = state.length;
            int n2 = 0;
            while (n2 < n) {
                StateProvider s = stateProviderArray[n2];
                if (!this.is(s.hashCode())) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public boolean is(State ... state) {
            State[] stateArray = state;
            int n = state.length;
            int n2 = 0;
            while (n2 < n) {
                State s = stateArray[n2];
                if (!this.is(s.id)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public boolean is(int ... state) {
            int[] nArray = state;
            int n = state.length;
            int n2 = 0;
            while (n2 < n) {
                int s = nArray[n2];
                if ((this.state & s) != s) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public boolean equals(Object obj) {
            if (obj instanceof StateProvider) {
                return obj.hashCode() == this.hashCode();
            }
            return false;
        }

        public int hashCode() {
            return this.state;
        }

        public List<State> getStates() {
            ArrayList<State> states = new ArrayList<State>();
            int id = 1;
            while (id <= State.max) {
                if (this.is(id)) {
                    states.add(State.getState(id));
                }
                id *= 2;
            }
            return states;
        }

        public String toString() {
            String result = "";
            for (State s : this.getStates()) {
                result = String.valueOf(result) + ", " + (Object)((Object)s);
            }
            return result.isEmpty() ? "" : result.substring(2);
        }
    }

    public static class SymmetricCondition
    implements Provable {
        private Conditions conditionsS1;
        private Conditions[] conditionsS2;

        public SymmetricCondition(Conditions conditionsS1, Conditions ... conditionsS2) {
            this.conditionsS1 = conditionsS1;
            this.conditionsS2 = conditionsS2;
        }

        public boolean proove(Span span) {
            if (!(span instanceof SymmetricReason)) {
                return false;
            }
            SymmetricReason reason = (SymmetricReason)span;
            if (this.conditionsS2.length != reason.getS2().size()) {
                return false;
            }
            if (!this.conditionsS1.proove(reason.getS1())) {
                return false;
            }
            HashMap<Conditions, Reason> map = new HashMap<Conditions, Reason>();
            for (Reason r : reason.getS2()) {
                boolean found = false;
                Conditions[] conditionsArray = this.conditionsS2;
                int n = this.conditionsS2.length;
                int n2 = 0;
                while (n2 < n) {
                    Conditions c2 = conditionsArray[n2];
                    if (map.get(c2) == null && c2.proove(r)) {
                        map.put(c2, r);
                        found = true;
                        break;
                    }
                    ++n2;
                }
                if (found) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            String result = "";
            Conditions[] conditionsArray = this.conditionsS2;
            int n = this.conditionsS2.length;
            int n2 = 0;
            while (n2 < n) {
                Conditions condition = conditionsArray[n2];
                result = String.valueOf(result) + ", " + condition;
                ++n2;
            }
            return String.valueOf(this.getClass().getSimpleName()) + ": " + this.conditionsS1 + (result.isEmpty() ? "" : " -> " + result.substring(2));
        }

        @Override
        public StateProvider getState() {
            return this.conditionsS1.getState();
        }
    }
}

