/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.util;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Node;

public class ContainmentCycleFinder {
    private List<List<Edge>> cycles;

    public List<List<Edge>> findContainmentCycles(Graph graph) {
        this.cycles = new LinkedList<List<Edge>>();
        for (Node node : graph.getNodes()) {
            this.searchContainmentCyclesRevursivelyDepthFirst(node, new LinkedList<Edge>());
        }
        return this.cycles;
    }

    private void searchContainmentCyclesRevursivelyDepthFirst(Node currentNode, LinkedList<Edge> visitedEdges) {
        HashSet<Edge> relevantEdges = new HashSet<Edge>();
        for (Edge e : currentNode.getOutgoing()) {
            if (e.getType() == null || !e.getType().isContainment()) continue;
            relevantEdges.add(e);
        }
        for (Edge e : currentNode.getIncoming()) {
            if (e.getType() == null || !e.getType().isContainer()) continue;
            relevantEdges.add(e);
        }
        for (Edge edge : relevantEdges) {
            if (visitedEdges.contains(edge)) {
                this.extractCycle(visitedEdges, edge);
                return;
            }
            if (visitedEdges.contains(edge)) continue;
            Node nextNode = currentNode == edge.getSource() ? edge.getTarget() : edge.getSource();
            visitedEdges.add(edge);
            this.searchContainmentCyclesRevursivelyDepthFirst(nextNode, (LinkedList)visitedEdges.clone());
        }
    }

    private void extractCycle(LinkedList<Edge> pathOfEdges, Edge startingEdge) {
        List cycle = pathOfEdges.subList(pathOfEdges.indexOf(startingEdge), pathOfEdges.size());
        for (List<Edge> allreadyKnownCycle : this.cycles) {
            if (allreadyKnownCycle.size() != cycle.size() || !allreadyKnownCycle.containsAll(cycle)) continue;
            return;
        }
        this.cycles.add(cycle);
    }
}

