/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.compact;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.ParameterKind;
import org.eclipse.emf.henshin.model.ParameterMapping;
import org.eclipse.emf.henshin.model.Unit;

public class CUnit {
    private Unit unit;

    protected CUnit(Unit unit) {
        this.unit = unit;
    }

    public CUnit createParameter(ParameterKind kind, String name, EClassifier type) {
        if (kind == null) {
            throw new RuntimeException("No valid ParameterKind was given");
        }
        Parameter p = HenshinFactory.eINSTANCE.createParameter();
        p.setName(name);
        p.setKind(kind);
        p.setType(type);
        this.unit.getParameters().add((Object)p);
        return this;
    }

    public CUnit createParameter(ParameterKind kind, String name, String ... type) {
        return this.createParameter(kind, name, (EClassifier)this.getEClassByName(type));
    }

    public CUnit createParameter(String kind, String name, EDataType type) {
        return this.createParameter(ParameterKind.getByString(kind), name, (EClassifier)type);
    }

    public CUnit createParameter(String kind, String name, String ... type) {
        return this.createParameter(ParameterKind.getByString(kind), name, (EClassifier)this.getEClassByName(type));
    }

    public CUnit mapParameterToSubunit(String from, String targetUnit, String to) {
        EList<Unit> subs = this.unit.getSubUnits(false);
        Unit sub = null;
        for (Unit u : subs) {
            if (!u.getName().equals(targetUnit)) continue;
            sub = u;
        }
        if (sub == null) {
            throw new RuntimeException("Unit: " + targetUnit + " not found");
        }
        ParameterMapping mapping = HenshinFactory.eINSTANCE.createParameterMapping();
        Parameter fromParam = this.unit.getParameter(from);
        if (fromParam == null) {
            throw new RuntimeException("Parameter: " + from + " not found");
        }
        Parameter toParam = sub.getParameter(to);
        if (toParam == null) {
            throw new RuntimeException("Parameter: " + to + " in " + targetUnit + " not found");
        }
        if (!fromParam.getType().equals(toParam.getType())) {
            throw new RuntimeException("Parameters do not have equal Types");
        }
        mapping.setSource(fromParam);
        mapping.setTarget(toParam);
        this.unit.getParameterMappings().add((Object)mapping);
        return this;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    protected EClass getEClassByName(String ... name) {
        EClass result = null;
        String packURI = "";
        if (name.length > 1) {
            packURI = name[1];
        }
        for (EPackage pack : this.getUnit().getModule().getImports()) {
            if (!packURI.equals("") && !packURI.equals(pack.getNsURI())) continue;
            result = (EClass)pack.getEClassifier(name[0]);
        }
        if (result == null) {
            throw new RuntimeException("No Classifier for " + name + " found.");
        }
        return result;
    }
}

