/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.compact;

import java.text.ParseException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Node;

public class CNode {
    private Node node;

    protected CNode(Node node) {
        this.node = node;
    }

    public boolean canCreateEdge(CNode target, EReference ref) {
        return this.node.getGraph().getRule().canCreateEdge(this.getNode(), target.getNode(), ref);
    }

    public boolean canCreateEdge(CNode target, String ref) {
        return this.canCreateEdge(target, this.getEReferenceByName(ref));
    }

    public CNode createEdge(CNode target, EReference ref, Action action) {
        Edge edge = this.node.getGraph().getRule().createEdge(this.node, target.getNode(), ref);
        if (edge == null) {
            throw new RuntimeException("Failed to create Edge");
        }
        edge.setAction(action);
        return this;
    }

    public CNode createEdge(CNode target, String ref) {
        return this.createEdge(target, this.getEReferenceByName(ref), new Action(Action.Type.PRESERVE));
    }

    public CNode createEdge(CNode target, EReference ref) {
        return this.createEdge(target, ref, new Action(Action.Type.PRESERVE));
    }

    public CNode createEdge(CNode target, String ref, String action) {
        try {
            return this.createEdge(target, this.getEReferenceByName(ref), Action.parse(action));
        }
        catch (ParseException parseException) {
            throw new RuntimeException(String.valueOf(action) + " is not a valid Action");
        }
    }

    public CNode createEdge(CNode target, String ref, Action action) {
        return this.createEdge(target, this.getEReferenceByName(ref), action);
    }

    public CNode createEdge(CNode target, EReference ref, String action) {
        try {
            return this.createEdge(target, ref, Action.parse(action));
        }
        catch (ParseException parseException) {
            throw new RuntimeException(String.valueOf(action) + " is not a valid Action");
        }
    }

    public CNode createAttribute(EAttribute attribute, String value, Action action) {
        String result = "";
        if (value.contains("->")) {
            int index = value.indexOf("->");
            result = value.substring(index + 2);
            value = value.substring(0, index);
        }
        Attribute att = HenshinFactory.eINSTANCE.createAttribute(this.node, attribute, value);
        att.setAction(action);
        this.node.getAttributes().add((Object)att);
        if (!result.equals("")) {
            this.setAttributeResult(attribute, result);
        }
        return this;
    }

    public CNode createAttribute(String attribute, String value) {
        return this.createAttribute(this.getEAttributeByName(attribute), value, this.node.getAction());
    }

    public CNode createAttribute(EAttribute attribute, String value) {
        return this.createAttribute(attribute, value, this.node.getAction());
    }

    public CNode createAttribute(String attribute, String value, String action) {
        try {
            return this.createAttribute(this.getEAttributeByName(attribute), value, Action.parse(action));
        }
        catch (ParseException parseException) {
            throw new RuntimeException(String.valueOf(action) + " is not a valid Action");
        }
    }

    public CNode createAttribute(EAttribute attribute, String value, String action) {
        try {
            return this.createAttribute(attribute, value, Action.parse(action));
        }
        catch (ParseException parseException) {
            throw new RuntimeException(String.valueOf(action) + " is not a valid Action");
        }
    }

    public CNode createAttribute(String attribute, String value, Action action) {
        return this.createAttribute(this.getEAttributeByName(attribute), value, action);
    }

    private CNode setAttributeResult(EAttribute attribute, String resultValue) {
        Node imageNode = this.node.getGraph().getRule().getMappings().getImage(this.node, this.node.getGraph().getRule().getRhs());
        Attribute imageAttribute = imageNode.getAttribute(attribute);
        imageAttribute.setValue(resultValue);
        return this;
    }

    public void setName(String name) {
        this.node.setName(name);
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public Node getNode() {
        return this.node;
    }

    private EReference getEReferenceByName(String name) {
        EReference result = null;
        for (EReference ref : this.node.getType().getEAllReferences()) {
            if (!ref.getName().equals(name)) continue;
            result = ref;
            break;
        }
        if (result == null) {
            throw new RuntimeException("No Reference for " + name + " found.");
        }
        return result;
    }

    private EAttribute getEAttributeByName(String name) {
        EAttribute result = null;
        for (EAttribute att : this.node.getType().getEAllAttributes()) {
            if (!att.getName().equals(name)) continue;
            result = att;
            break;
        }
        if (result == null) {
            throw new RuntimeException("No Attribute for " + name + " found.");
        }
        return result;
    }
}

