/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.popupmenu;

import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdRule;
import agg.gui.AGGAppl;
import agg.gui.treeview.GraGraTreeView;
import agg.gui.treeview.nodedata.GraGraTreeNodeData;
import agg.gui.treeview.nodedata.RuleSequenceTreeNodeData;
import agg.ruleappl.RuleSequence;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Rule;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class RuleSequencePopupMenu
extends JPopupMenu {
    JMenuItem mi;
    JMenuItem miRuleSeqValidated;
    JMenuItem miConcurDisJointRule;
    JMenuItem miConcurJointRule;
    JMenuItem miAllConcurJointRule;
    JMenuItem miConcurRuleByObjFlow;
    JMenuItem miEvalRuleSeq;
    JMenuItem miRuleSeqObjFlow;
    JMenuItem miParallelRule;
    GraGraTreeView treeView;
    TreePath path;
    DefaultMutableTreeNode node;
    RuleSequenceTreeNodeData data;
    int locationRow;
    RuleSequence ruleSeq;
    List<EdRule> concurrentRules;

    public RuleSequencePopupMenu(GraGraTreeView tree) {
        super("RuleSequence");
        this.treeView = tree;
        this.mi = this.add(new JMenuItem("Show / Edit"));
        this.mi.setActionCommand("editRuleSequence");
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RuleSequencePopupMenu.this.ruleSeq != null) {
                    RuleSequencePopupMenu.this.treeView.selectPath(RuleSequencePopupMenu.this.locationRow);
                    if (RuleSequencePopupMenu.this.ruleSeq.getGraGra() == RuleSequencePopupMenu.this.treeView.getCurrentGraGra().getBasisGraGra()) {
                        if (!RuleSequencePopupMenu.this.ruleSeq.isValid()) {
                            JOptionPane.showMessageDialog(RuleSequencePopupMenu.this.treeView.getFrame(), "Currently selected rule sequence is not valid anymore.\nAt least one rule of it is not available.\nPlease delete this sequence and create a new one. ", "Rule Sequence failed", 0);
                            return;
                        }
                        ((AGGAppl)RuleSequencePopupMenu.this.treeView.getFrame()).getGraGraEditor().showRuleSequenceGUI(RuleSequencePopupMenu.this.ruleSeq.getName());
                    } else {
                        int indx = RuleSequencePopupMenu.this.locationRow;
                        TreePath p = RuleSequencePopupMenu.this.treeView.getTreePathOfGrammar(RuleSequencePopupMenu.this.ruleSeq.getGraGra());
                        if (p != null) {
                            RuleSequencePopupMenu.this.treeView.selectPath(p);
                            RuleSequencePopupMenu.this.treeView.selectPath(indx);
                            if (!RuleSequencePopupMenu.this.ruleSeq.isValid()) {
                                JOptionPane.showMessageDialog(RuleSequencePopupMenu.this.treeView.getFrame(), "Currently selected rule sequence is not valid anymore.\nAt least one rule of it is not available.\nPlease delete this sequence and create a new one. ", "Rule Sequence failed", 0);
                                return;
                            }
                            ((AGGAppl)RuleSequencePopupMenu.this.treeView.getFrame()).getGraGraEditor().showRuleSequenceGUI(RuleSequencePopupMenu.this.ruleSeq.getName());
                        }
                    }
                }
            }
        });
        this.addSeparator();
        this.miConcurDisJointRule = new JMenuItem("Make Concurrent Rule by disjoint Union");
        this.miConcurDisJointRule.setActionCommand("disjointConcurRuleOfSeq");
        this.miConcurDisJointRule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleSequencePopupMenu.this.makeDisjointConcurRuleOfSeq();
            }
        });
        this.miConcurJointRule = new JMenuItem("Make (max) Concurrent Rule jointly by Dependency");
        this.add(this.miConcurJointRule);
        this.miConcurJointRule.setActionCommand("jointConcurRuleOfSeq");
        this.miConcurJointRule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleSequencePopupMenu.this.makeMaxJointlyConcurRuleOfSeq();
            }
        });
        this.miAllConcurJointRule = new JMenuItem("Make Concurrent Rule(s) jointly by Dependency");
        this.add(this.miAllConcurJointRule);
        this.miAllConcurJointRule.setActionCommand("jointAllConcurRuleOfSeq");
        this.miAllConcurJointRule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleSequencePopupMenu.this.makeJointlyConcurRuleOfSeq();
            }
        });
        this.miConcurRuleByObjFlow = this.add(new JMenuItem("Make Concurrent Rule jointly by Object Flow"));
        this.miConcurRuleByObjFlow.setActionCommand("concurRuleOfSeqByOF");
        this.miConcurRuleByObjFlow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleSequencePopupMenu.this.makeConcurRuleOfSeqByOF();
            }
        });
        this.miParallelRule = new JMenuItem("Make Parallel Rule by disjoint Union");
        this.add(this.miParallelRule);
        this.miParallelRule.setActionCommand("makeParallelRule");
        this.miParallelRule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleSequencePopupMenu.this.makeParallelRuleOfSeq();
            }
        });
        this.addSeparator();
        this.mi = this.add(new JMenuItem("Delete"));
        this.mi.setActionCommand("deleteRuleSequence");
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RuleSequencePopupMenu.this.treeView.hasMultipleSelection()) {
                    RuleSequencePopupMenu.this.treeView.delete("selected");
                } else {
                    RuleSequencePopupMenu.this.treeView.deleteRuleSequence(RuleSequencePopupMenu.this.node, RuleSequencePopupMenu.this.path, true);
                }
            }
        });
        this.addSeparator();
        this.miRuleSeqValidated = this.add(new JCheckBoxMenuItem("Graph Transformation by validated Rule Sequence"));
        this.miRuleSeqValidated.setActionCommand("validatedRuleSequence");
        this.miRuleSeqValidated.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RuleSequencePopupMenu.this.ruleSeq != null) {
                    if (!RuleSequencePopupMenu.this.ruleSeq.isChecked()) {
                        JOptionPane.showMessageDialog(null, "<html><body>Currently selected rule sequence isn't checked!\n ", "Cannot select this action", 2);
                        ((JCheckBoxMenuItem)e.getSource()).setSelected(false);
                        return;
                    }
                    if (((JCheckBoxMenuItem)e.getSource()).isSelected()) {
                        if (RuleSequencePopupMenu.this.ruleSeq.isChecked()) {
                            RuleSequencePopupMenu.this.miRuleSeqObjFlow.setSelected(false);
                            RuleSequencePopupMenu.this.ruleSeq.getGraGra().setTrafoByApplicableRuleSequence(true);
                            if (RuleSequencePopupMenu.this.ruleSeq.getGraph() != null) {
                                ((JCheckBoxMenuItem)e.getSource()).setText("Graph: " + RuleSequencePopupMenu.this.ruleSeq.getGraph().getName() + "Transformation by validated Rule Sequence");
                            } else {
                                ((JCheckBoxMenuItem)e.getSource()).setText("Transformation by validated Rule Sequence");
                            }
                        }
                    } else {
                        RuleSequencePopupMenu.this.ruleSeq.getGraGra().setTrafoByApplicableRuleSequence(false);
                        ((JCheckBoxMenuItem)e.getSource()).setText("Transformation by validated Rule Sequence");
                    }
                }
            }
        });
        this.miRuleSeqObjFlow = new JCheckBoxMenuItem("Graph Transformation by defined Object Flow");
        this.add(this.miRuleSeqObjFlow);
        this.miRuleSeqObjFlow.setActionCommand("objectflowRuleSequence");
        this.miRuleSeqObjFlow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RuleSequencePopupMenu.this.ruleSeq != null) {
                    if (((JCheckBoxMenuItem)e.getSource()).isSelected()) {
                        if (RuleSequencePopupMenu.this.ruleSeq.getObjectFlow().isEmpty()) {
                            JOptionPane.showMessageDialog(null, "<html><body>There isn't any Object Flow defined.", "Cannot select this action", 2);
                            ((JCheckBoxMenuItem)e.getSource()).setSelected(false);
                            return;
                        }
                        RuleSequencePopupMenu.this.miRuleSeqValidated.setSelected(false);
                        RuleSequencePopupMenu.this.ruleSeq.getGraGra().setTrafoByRuleSequenceWithObjectFlow(true);
                    } else {
                        RuleSequencePopupMenu.this.ruleSeq.getGraGra().setTrafoByRuleSequenceWithObjectFlow(false);
                    }
                }
            }
        });
    }

    public boolean invoked(int x, int y) {
        if (this.treeView == null) {
            return false;
        }
        this.locationRow = this.treeView.getTree().getRowForLocation(x, y);
        if (this.locationRow != -1 && this.treeView.getTree().getPathForLocation(x, y).getPath().length == 3) {
            this.path = this.treeView.getTree().getPathForLocation(x, y);
            this.node = (DefaultMutableTreeNode)this.path.getLastPathComponent();
            this.data = (RuleSequenceTreeNodeData)this.node.getUserObject();
            this.ruleSeq = this.treeView.getRuleSequence(this.node);
            if (this.ruleSeq != null) {
                this.miConcurJointRule.setEnabled(!this.ruleSeq.isEmpty());
                this.miAllConcurJointRule.setEnabled(!this.ruleSeq.isEmpty());
                this.miConcurRuleByObjFlow.setEnabled(!this.ruleSeq.isEmpty());
                this.miParallelRule.setEnabled(!this.ruleSeq.isEmpty());
                this.miRuleSeqValidated.setEnabled(!this.ruleSeq.isEmpty());
                this.miRuleSeqObjFlow.setEnabled(!this.ruleSeq.isEmpty());
                ((JCheckBoxMenuItem)this.miRuleSeqValidated).setText("Graph Transformation by validated Rule Sequence");
                ((JCheckBoxMenuItem)this.miRuleSeqValidated).setSelected(this.ruleSeq.isTrafoByARS());
                ((JCheckBoxMenuItem)this.miRuleSeqObjFlow).setSelected(this.ruleSeq.isTrafoByObjFlow());
                return true;
            }
        }
        return false;
    }

    void makeDisjointConcurRuleOfSeq() {
        TreePath graPath = this.path.getParentPath();
        if (graPath != null) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
            final GraGraTreeNodeData graData = (GraGraTreeNodeData)graNode.getUserObject();
            final int indxOfLastRule = ((DefaultMutableTreeNode)this.node.getParent()).getIndex(this.treeView.getTreeNodeOfRule(graData.getGraGra().getRules().lastElement()));
            if (this.warningOK()) {
                if (this.data.getRuleSequence().getRules().size() == 1) {
                    JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>The concurrent rule for the single rule is the rule itself.", "Concurrent Rule", 1);
                    return;
                }
                JOptionPane pane = new JOptionPane("Generating concurrent rule ... \n Please wait ... ", 2);
                final JDialog d = pane.createDialog("Generating ...");
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        EdRule concurrentRule = graData.getGraGra().makeConcurrentRuleOfRuleSeq(RuleSequencePopupMenu.this.data.getRuleSequence(), false, true);
                        if (concurrentRule != null) {
                            RuleSequencePopupMenu.this.treeView.putRuleIntoTree(concurrentRule, (DefaultMutableTreeNode)RuleSequencePopupMenu.this.node.getParent(), indxOfLastRule + 1);
                            RuleSequencePopupMenu.this.treeView.concurrentRuleWarning(concurrentRule);
                        } else {
                            JOptionPane.showMessageDialog(RuleSequencePopupMenu.this.treeView.getFrame(), "<html><body>It wasn't possible to create a concurrent rule.", "Concurrent Rule", 0);
                        }
                        d.setVisible(false);
                    }
                };
                thread.start();
                d.setVisible(true);
                while (thread.isAlive()) {
                }
            }
        }
    }

    void makeMaxJointlyConcurRuleOfSeq() {
        TreePath graPath = this.path.getParentPath();
        if (graPath != null) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
            final GraGraTreeNodeData graData = (GraGraTreeNodeData)graNode.getUserObject();
            int indxOfLastRule = ((DefaultMutableTreeNode)this.node.getParent()).getIndex(this.treeView.getTreeNodeOfRule(graData.getGraGra().getRules().lastElement()));
            if (this.warningOK()) {
                if (this.data.getRuleSequence().getRules().size() == 1) {
                    JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>The concurrent rule for the single rule is the rule itself.", "Concurrent Rule", 1);
                    return;
                }
                JOptionPane pane = new JOptionPane("Generating concurrent rule ... \n Please wait ... ", 2);
                final JDialog d = pane.createDialog("Generating ...");
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        RuleSequencePopupMenu.this.concurrentRules = graData.getGraGra().makeConcurrentRuleOfRuleSeqForward(RuleSequencePopupMenu.this.data.getRuleSequence(), false, true);
                        d.setVisible(false);
                    }
                };
                thread.start();
                d.setVisible(true);
                while (thread.isAlive()) {
                }
                if (this.concurrentRules != null && !this.concurrentRules.isEmpty()) {
                    int i = 0;
                    while (i < this.concurrentRules.size()) {
                        EdRule concurrentRule = this.concurrentRules.get(i);
                        this.treeView.putRuleIntoTree(concurrentRule, (DefaultMutableTreeNode)this.node.getParent(), indxOfLastRule + 1 + i);
                        ++i;
                    }
                    this.treeView.concurrentRuleWarning(this.concurrentRules.get(0));
                } else {
                    JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>It wasn't possible to create a concurrent rule.<br>(Reason may be: Dependency of rules doesn't exist)", "Concurrent Rule", 0);
                }
            }
        }
    }

    void makeJointlyConcurRuleOfSeq() {
        TreePath graPath = this.path.getParentPath();
        if (graPath != null) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
            final GraGraTreeNodeData graData = (GraGraTreeNodeData)graNode.getUserObject();
            int indxOfLastRule = ((DefaultMutableTreeNode)this.node.getParent()).getIndex(this.treeView.getTreeNodeOfRule(graData.getGraGra().getRules().lastElement()));
            if (this.warningOK()) {
                if (this.data.getRuleSequence().getRules().size() == 1) {
                    JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>The concurrent rule for the single rule is the rule itself.", "Concurrent Rule", 1);
                    return;
                }
                JOptionPane pane = new JOptionPane("Generating concurrent rule ... \n Please wait ... ", 2);
                final JDialog d = pane.createDialog("Generating ...");
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        RuleSequencePopupMenu.this.concurrentRules = graData.getGraGra().makeConcurrentRuleOfRuleSeqForward(RuleSequencePopupMenu.this.data.getRuleSequence(), true, true);
                        d.setVisible(false);
                    }
                };
                thread.start();
                d.setVisible(true);
                while (thread.isAlive()) {
                }
                if (this.concurrentRules != null && !this.concurrentRules.isEmpty()) {
                    int i = 0;
                    while (i < this.concurrentRules.size()) {
                        EdRule concurrentRule = this.concurrentRules.get(i);
                        this.treeView.putRuleIntoTree(concurrentRule, (DefaultMutableTreeNode)this.node.getParent(), indxOfLastRule + 1 + i);
                        ++i;
                    }
                    this.treeView.concurrentRuleWarning(this.concurrentRules.get(0));
                } else {
                    JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>It isn't possible to create a concurrent rule.", "Concurrent Rule", 0);
                }
            }
        }
    }

    void makeConcurRuleOfSeqByOF() {
        TreePath graPath = this.path.getParentPath();
        if (graPath != null) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
            final GraGraTreeNodeData graData = (GraGraTreeNodeData)graNode.getUserObject();
            final int indxOfLastRule = ((DefaultMutableTreeNode)this.node.getParent()).getIndex(this.treeView.getTreeNodeOfRule(graData.getGraGra().getRules().lastElement()));
            if (this.warningOK()) {
                if (this.data.getRuleSequence().getRules().size() == 1) {
                    JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>The concurrent rule for the single rule is the rule itself.", "Concurrent Rule", 1);
                    return;
                }
                if (this.data.getRuleSequence().isObjFlowDefined()) {
                    JOptionPane pane = new JOptionPane("Generating concurrent rule ... \n Please wait ... ", 2);
                    final JDialog d = pane.createDialog("Generating ...");
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            EdRule concurrentRule = graData.getGraGra().makeConcurrentRuleOfRuleSeq(RuleSequencePopupMenu.this.data.getRuleSequence(), true, true);
                            if (concurrentRule != null) {
                                RuleSequencePopupMenu.this.treeView.putRuleIntoTree(concurrentRule, (DefaultMutableTreeNode)RuleSequencePopupMenu.this.node.getParent(), indxOfLastRule + 1);
                                RuleSequencePopupMenu.this.treeView.concurrentRuleWarning(concurrentRule);
                            } else {
                                JOptionPane.showMessageDialog(RuleSequencePopupMenu.this.treeView.getFrame(), "<html><body>It isn't possible to create a concurrent rule.", "Concurrent Rule Failed", 0);
                            }
                            d.setVisible(false);
                        }
                    };
                    thread.start();
                    d.setVisible(true);
                    while (thread.isAlive()) {
                    }
                } else {
                    JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>Any Object Flow does not exist.<br>It should be defined before.", "Concurrent Rule Failed", 0);
                }
            }
        }
    }

    private boolean warningOK() {
        if (this.data.getRuleSequence().containsRuleScheme()) {
            JOptionPane.showMessageDialog(this.treeView.getFrame(), "Currently selected rule sequence contains at least one Rule Scheme.\nBuilding of a concurrent rule is not available in this case.\nOnly plain rules will be supported. ", "Feature not available", 0);
            return false;
        }
        Rule failedRule = BaseFactory.theFactory().checkApplCondsOfRules(this.data.getRuleSequence().getRules());
        if (failedRule != null) {
            JOptionPane.showMessageDialog(this.treeView.getFrame(), "Currently selected rule list contains at least one invalid rule.\n" + failedRule.getName() + ":    " + failedRule.getErrorMsg(), "Concurrent Rule Failed", 0);
            return false;
        }
        if (this.data.getRuleSequence().containsRuleLoop()) {
            JOptionPane.showMessageDialog(this.treeView.getFrame(), "Please note:\nThe (*) iterations of a rule will be converted to 2 times.", "Concurrent Rule", 1);
        }
        return true;
    }

    void makeParallelRuleOfSeq() {
        DefaultMutableTreeNode graNode;
        GraGraTreeNodeData graData;
        TreePath graPath = this.path.getParentPath();
        if (graPath != null && (graData = (GraGraTreeNodeData)(graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent()).getUserObject()).getGraGra() != null) {
            int indxOfLastRule = ((DefaultMutableTreeNode)this.node.getParent()).getIndex(this.treeView.getTreeNodeOfRule(graData.getGraGra().getRules().lastElement()));
            if (this.data.getRuleSequence().containsRuleScheme()) {
                JOptionPane.showMessageDialog(this.treeView.getFrame(), "Currently selected rule sequence contains at least one Rule Scheme.\nBuilding of a parallel rule is not available in this case.\nOnly plain rules will be supported. ", "Feature not available", 0);
                return;
            }
            Rule failedRule = BaseFactory.theFactory().checkApplCondsOfRules(this.data.getRuleSequence().getRules());
            if (failedRule != null) {
                JOptionPane.showMessageDialog(this.treeView.getFrame(), "Currently selected rule list contains at least one invalid rule.\n" + failedRule.getName() + ":    " + failedRule.getErrorMsg(), "Parallel Rule Failed", 0);
                return;
            }
            if (this.data.getRuleSequence().containsRuleLoop()) {
                JOptionPane.showMessageDialog(this.treeView.getFrame(), "Please note:\nThe (*) iterations of a rule will be converted to 2 times.", "Parallel Rule", 1);
            }
            this.makeParallelRuleOfRules(graData.getGraGra(), this.data.getRuleSequence().getRules(), graNode, indxOfLastRule);
        }
    }

    private void makeParallelRuleOfRules(EdGraGra gra, List<Rule> rules, DefaultMutableTreeNode node, int indxOfLastRule) {
        EdRule parallelRule = gra.makeParallelRuleOfRules(rules, true);
        if (parallelRule != null) {
            if (parallelRule.getBasisRule().isApplicable()) {
                this.treeView.putRuleIntoTree(parallelRule, node, indxOfLastRule + 1);
                JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>Building of a parallel rule was successful.\n\nThe rule:  " + parallelRule.getName() + "\n" + "is added at the end of the rule set.\n\n", "Parallel Rule:  " + parallelRule.getName(), 1);
            } else {
                JOptionPane.showMessageDialog(this.treeView.getFrame(), "Building of a rule failed!", "Parallel Rule:  " + parallelRule.getName(), 0);
            }
        } else {
            JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>It was not possible to build a rule.", "Parallel Rule", 0);
        }
    }
}

