/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda.computation;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.multicda.cda.ReasonFactory;
import org.eclipse.emf.henshin.multicda.cda.Utils;
import org.eclipse.emf.henshin.multicda.cda.computation.MinimalReasonComputation;
import org.eclipse.emf.henshin.multicda.cda.conflict.ConflictReason;

public class ConflictReasonComputation {
    static Action deleteAction = new Action(Action.Type.DELETE);
    static Action preserveAction = new Action(Action.Type.PRESERVE);
    static HenshinFactory henshinFactory = HenshinFactory.eINSTANCE;
    protected Rule rule1;
    protected Rule rule2;

    public ConflictReasonComputation(Rule rule1, Rule rule2) {
        this.rule1 = rule1;
        this.rule2 = rule2;
    }

    public Set<ConflictReason> computeConflictReasons() {
        Set<ConflictReason> minimalReasons = new MinimalReasonComputation(this.rule1, this.rule2).computeMinimalConflictReasons();
        return this.computeConflictReasons(minimalReasons);
    }

    public Set<ConflictReason> computeConflictReasons(Set<ConflictReason> minimalConflictReasons) {
        HashSet<ConflictReason> result = new HashSet<ConflictReason>();
        for (ConflictReason mcr : minimalConflictReasons) {
            HashSet<ConflictReason> remainingMCR = new HashSet<ConflictReason>(minimalConflictReasons);
            remainingMCR.remove(mcr);
            result.addAll(Utils.computeMinimalConflictReasons(mcr, remainingMCR));
            result.add(ReasonFactory.eINSTANCE.createDRReason(mcr));
        }
        return result;
    }
}

