/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda.compareLogger;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Rule;

public class Logger2 {
    LogData logData;
    boolean dataAdded = false;
    String[][] analysisDurations;
    String[][] analysisResults;
    List<Rule> firstRules;
    List<Rule> secondRules;
    boolean addDetailsOnRuleName = false;

    public LogData getLogData() {
        return this.logData;
    }

    public String[][] getAnalysisDurations() {
        return this.analysisDurations;
    }

    public String[][] getAnalysisResults() {
        return this.analysisResults;
    }

    public List<Rule> getFirstRules() {
        return this.firstRules;
    }

    public List<Rule> getSecondRules() {
        return this.secondRules;
    }

    public Logger2(LogData logData, List<Rule> firstRules, List<Rule> secondRules) {
        this.logData = logData;
        this.firstRules = firstRules;
        this.secondRules = secondRules;
        this.analysisDurations = new String[firstRules.size()][secondRules.size()];
        this.analysisResults = new String[firstRules.size()][secondRules.size()];
    }

    public Logger2(LogData logData, List<Rule> rules) {
        this(logData, rules, rules);
    }

    public void setAnalysisKinds(boolean normal, boolean essential, boolean atomic) {
        String runtimeString = "";
        String deleteUseconflicts = "";
        StringBuffer sb = new StringBuffer("");
        if (normal) {
            sb.append("normalCPs");
        }
        if (sb.length() > 1 && essential) {
            sb.append("/");
        }
        if (essential) {
            sb.append("essentialCPs");
        }
        if (sb.length() > 1 && atomic) {
            sb.append(" / ");
        }
        if (atomic) {
            sb.append("conflictAtoms");
        }
        runtimeString = sb.toString();
        deleteUseconflicts = sb.toString();
        if (atomic) {
            deleteUseconflicts = deleteUseconflicts.concat(" / Candidates / Minimal Reasons");
        }
        this.analysisDurations[0][0] = "RUNTIME - " + runtimeString + "[ms]";
        this.analysisResults[0][0] = "D-U-CONFLICTS - " + deleteUseconflicts;
    }

    public void addData(Rule rule1, Rule rule2, String runtime, String results) {
        this.dataAdded = true;
        int rowPosition = this.firstRules.indexOf(rule1);
        int columnPosition = this.secondRules.indexOf(rule2);
        this.analysisDurations[rowPosition][columnPosition] = runtime;
        this.analysisResults[rowPosition][columnPosition] = results;
    }

    public void setAddDetailsOnRuleName(boolean addDetailsOnRuleName) {
        this.addDetailsOnRuleName = addDetailsOnRuleName;
    }

    private String analyseDetailsOfRule(Rule rule) {
        int numberOfLhsNodes = rule.getLhs().getNodes().size();
        int numberOfLhsEdges = rule.getLhs().getEdges().size();
        Action deleteAction = new Action(Action.Type.DELETE);
        EList deletionNodes = rule.getActionNodes(deleteAction);
        int numberOfDeletionNodes = deletionNodes.size();
        EList deletionEdges = rule.getActionEdges(deleteAction);
        int numberOfDeletionEdges = deletionEdges.size();
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append("#LhsNode:");
        sb.append(numberOfLhsNodes);
        sb.append(" ,#LhsEdges:");
        sb.append(numberOfLhsEdges);
        sb.append(" ,#deleteNodes:");
        sb.append(numberOfDeletionNodes);
        sb.append(" ,#deleteEdges:");
        sb.append(numberOfDeletionEdges);
        sb.append("]");
        return sb.toString();
    }

    public void exportStoredRuntimeToCSV(String targetFolder) {
        String filename = String.valueOf(targetFolder) + File.separator + "_runtime.csv";
        File file = new File(filename);
        if (this.dataAdded) {
            try {
                this.exportDataToCSV(file, this.analysisDurations);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void exportStoredResultsToCSV(String targetFolder) {
        String filename = String.valueOf(targetFolder) + File.separator + this.logData.toString() + "_results.csv";
        File file = new File(filename);
        if (this.dataAdded) {
            try {
                this.exportDataToCSV(file, this.analysisResults);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void exportDataToCSV(File file, String[][] exportData) throws IOException {
        FileWriter fw = new FileWriter(file);
        fw.append("\\/firstRule / secondRule->;");
        for (Rule rule : this.secondRules) {
            fw.append(rule.getName().toString());
            fw.append(";");
        }
        fw.append("\n");
        int row = 0;
        while (row < this.firstRules.size()) {
            fw.append(this.firstRules.get(row).getName().toString());
            fw.append(";");
            int column = 0;
            while (column < this.secondRules.size()) {
                fw.append(exportData[row][column]);
                fw.append(";");
                ++column;
            }
            fw.append("\n");
            ++row;
        }
        this.addStatisticsToCSV(fw);
        fw.flush();
        fw.close();
    }

    private void addStatisticsToCSV(FileWriter fw) throws IOException {
        int lastRow = this.firstRules.size() + 1;
        fw.append("SUM:");
        fw.append(";");
        String sum = "=SUMME(B2:CCC" + lastRow + ")";
        fw.append(sum);
        fw.append(";");
        fw.append("\n");
        fw.append("TIMEOUTS:");
        fw.append(";");
        String to = "=Z\ufffdHLENWENN(B2:CCC" + lastRow + ".\"TO\")";
        fw.append(to);
        fw.append(";");
        fw.append("\n");
        fw.append("MAXIMUM:");
        fw.append(";");
        String max = "=MAX(B2:CCC" + lastRow + ")";
        fw.append(max);
        fw.append(";");
        fw.append("\n");
        fw.append("AVERAGE:");
        fw.append(";");
        String avg = "=MITTELWERT(B2:CCC" + lastRow + ")";
        fw.append(avg);
        fw.append(";");
        fw.append("\n");
    }

    public int getTotalResultAmount() {
        return this.sumUpAllNumbers(this.analysisResults);
    }

    public int getTotalRuntimeAmount() {
        return this.sumUpAllNumbers(this.analysisDurations);
    }

    private int sumUpAllNumbers(String[][] values) {
        int sum = 0;
        int i = 0;
        while (i < values.length) {
            int j = 0;
            while (j < values[i].length) {
                try {
                    int number = Integer.parseInt(values[i][j]);
                    sum += number;
                }
                catch (NumberFormatException numberFormatException) {}
                ++j;
            }
            ++i;
        }
        return sum;
    }

    public static enum LogData {
        DELTE_USE_CONFLICTS,
        PRODUCE_USE_DEPENDENCY,
        ESSENTIAL_DELTE_USE_CONFLICTS,
        ESSENTIAL_PRODUCE_USE_DEPENDENCY,
        CONFLICT_CANDIDATE,
        DEPENDENCY_CANDIDATE,
        CONFLICT_ATOM,
        DEPENDENCY_ATOM,
        MINIMAL_CONFLICT_REASON,
        MINIMAL_DEPENDENCY_REASON,
        CONFLICT_REASON,
        DEPENDENCY_REASON;

    }
}

