/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.util;

import java.util.Collection;

public class Aggregations {
    public static double COUNT(Collection<?> elements) {
        return elements.size();
    }

    public static double SUM(Collection<?> elements) {
        double sum = 0.0;
        Aggregations.ensureNumbers(elements);
        for (Object elem : elements) {
            sum += ((Number)elem).doubleValue();
        }
        return sum;
    }

    public static double MIN(Collection<?> elements) {
        Aggregations.ensureNonEmpty(elements);
        Aggregations.ensureNumbers(elements);
        double min = ((Number)elements.iterator().next()).doubleValue();
        for (Object elem : elements) {
            min = Math.min(min, ((Number)elem).doubleValue());
        }
        return min;
    }

    public static double MIN(Collection<?> elements, Number valueForEmptyCollection) {
        return elements.isEmpty() ? valueForEmptyCollection.doubleValue() : Aggregations.MIN(elements);
    }

    public static double MAX(Collection<?> elements) {
        Aggregations.ensureNonEmpty(elements);
        Aggregations.ensureNumbers(elements);
        double max = ((Number)elements.iterator().next()).doubleValue();
        for (Object elem : elements) {
            max = Math.max(max, ((Number)elem).doubleValue());
        }
        return max;
    }

    public static double MAX(Collection<?> elements, Number valueForEmptyCollection) {
        return elements.isEmpty() ? valueForEmptyCollection.doubleValue() : Aggregations.MAX(elements);
    }

    public static double AVG(Collection<?> elements) {
        Aggregations.ensureNonEmpty(elements);
        return Aggregations.SUM(elements) / Aggregations.COUNT(elements);
    }

    public static double AVG(Collection<?> elements, Number valueForEmptyCollection) {
        return elements.isEmpty() ? valueForEmptyCollection.doubleValue() : Aggregations.AVG(elements);
    }

    public static double VAR(Collection<?> elements) {
        Aggregations.ensureNonEmpty(elements);
        double mean = Aggregations.AVG(elements);
        double temp = 0.0;
        for (Object elem : elements) {
            double a = ((Number)elem).doubleValue();
            temp += (mean - a) * (mean - a);
        }
        return temp / Aggregations.COUNT(elements);
    }

    double STDEV(Collection<?> elements) {
        return Math.sqrt(Aggregations.VAR(elements));
    }

    private static void ensureNumbers(Collection<?> elements) {
        for (Object elem : elements) {
            if (elem instanceof Number) continue;
            throw new IllegalArgumentException("Not a number: " + elem);
        }
    }

    private static void ensureNonEmpty(Collection<?> elements) {
        if (elements.isEmpty()) {
            throw new IllegalArgumentException("Cannot aggegrate over empty set");
        }
    }
}

