/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.debug;

import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.debug.DebugValueList;
import org.eclipse.emf.henshin.interpreter.debug.DebugValueObject;
import org.eclipse.emf.henshin.interpreter.debug.HenshinDebugTarget;
import org.eclipse.emf.henshin.interpreter.debug.HenshinDebugValue;
import org.eclipse.emf.henshin.interpreter.debug.HenshinDebugVariable;
import org.eclipse.emf.henshin.interpreter.matching.conditions.DebugApplicationCondition;

public class DebugValueEObject
extends HenshinDebugValue {
    private EObject value;

    public DebugValueEObject(IDebugTarget target, EGraph graph, String declaredType, EObject value, int indexInDomain) {
        super(target, graph, declaredType);
        this.value = value;
        this.indexInDomain = indexInDomain;
        EObject valueEObject = value;
        if (valueEObject == null) {
            this.valueString = "";
            this.actualType = "";
            this.childrenVariables = null;
        } else if (this.isPrimitive(valueEObject)) {
            this.valueString = valueEObject.toString();
            this.actualType = ((EAttribute)valueEObject).getEType().getInstanceClassName();
            this.childrenVariables = null;
        } else {
            EList structuralFeatures = valueEObject.eClass().getEAllStructuralFeatures();
            this.valueString = DebugApplicationCondition.retrieveValueLabel(valueEObject, graph);
            this.actualType = valueEObject.eClass().getName();
            this.childrenVariables = new HenshinDebugVariable[structuralFeatures.size()];
        }
    }

    @Override
    public IVariable[] getVariables() throws DebugException {
        if (this.hasVariables()) {
            EObject valueEObject = this.value;
            EList structuralFeatures = valueEObject.eClass().getEAllStructuralFeatures();
            int i = 0;
            while (i < structuralFeatures.size()) {
                EStructuralFeature childFeature = (EStructuralFeature)structuralFeatures.get(i);
                String nameString = childFeature.getName();
                childFeature.getEType().getName();
                Object childObj = valueEObject.eGet(childFeature);
                if (this.isPrimitive((EObject)childFeature)) {
                    childFeature.getEType().getInstanceClassName();
                }
                if (childObj instanceof EObject) {
                    EObject childEObj = (EObject)childObj;
                    List<EObject> domain = this.graph.getDomain(childEObj.eClass(), false);
                    int index = domain.indexOf(childEObj);
                    this.childrenVariables[i] = new HenshinDebugVariable((HenshinDebugTarget)this.getDebugTarget(), nameString, new DebugValueEObject(this.getDebugTarget(), this.graph, childFeature.getEType().getName(), childEObj, index));
                } else if (childObj instanceof List) {
                    List valueList = (List)childObj;
                    this.childrenVariables[i] = new HenshinDebugVariable((HenshinDebugTarget)this.getDebugTarget(), nameString, new DebugValueList((HenshinDebugTarget)this.getDebugTarget(), this.graph, this.declaredType, valueList));
                } else {
                    this.childrenVariables[i] = new HenshinDebugVariable((HenshinDebugTarget)this.getDebugTarget(), nameString, new DebugValueObject((HenshinDebugTarget)this.getDebugTarget(), this.graph, this.declaredType, childObj, i));
                }
                ++i;
            }
            return this.childrenVariables;
        }
        return new HenshinDebugVariable[0];
    }
}

