/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.henshin.model.BinaryFormula;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.UnaryFormula;
import org.eclipse.emf.henshin.model.impl.AndImpl;
import org.eclipse.emf.henshin.model.impl.NamedElementImpl;
import org.eclipse.emf.henshin.model.impl.NestedConditionImpl;
import org.eclipse.emf.henshin.model.impl.NotImpl;

public class GraphImpl
extends NamedElementImpl
implements Graph {
    protected EList<Node> nodes;
    protected EList<Edge> edges;
    protected Formula formula;

    public GraphImpl() {
    }

    public GraphImpl(String name) {
        this.setName(name);
    }

    @Override
    protected EClass eStaticClass() {
        return HenshinPackage.Literals.GRAPH;
    }

    @Override
    public EList<Node> getNodes() {
        if (this.nodes == null) {
            this.nodes = new EObjectContainmentWithInverseEList.Resolving(Node.class, (InternalEObject)this, 3, 6);
        }
        return this.nodes;
    }

    @Override
    public EList<Edge> getEdges() {
        if (this.edges == null) {
            this.edges = new EObjectContainmentWithInverseEList.Resolving(Edge.class, (InternalEObject)this, 4, 5);
        }
        return this.edges;
    }

    @Override
    public Formula getFormula() {
        if (this.formula != null && this.formula.eIsProxy()) {
            InternalEObject oldFormula = (InternalEObject)this.formula;
            this.formula = (Formula)this.eResolveProxy(oldFormula);
            if (this.formula != oldFormula) {
                InternalEObject newFormula = (InternalEObject)this.formula;
                NotificationChain msgs = oldFormula.eInverseRemove((InternalEObject)this, -6, null, null);
                if (newFormula.eInternalContainer() == null) {
                    msgs = newFormula.eInverseAdd((InternalEObject)this, -6, null, msgs);
                }
                if (msgs != null) {
                    msgs.dispatch();
                }
                if (this.eNotificationRequired()) {
                    this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 5, (Object)oldFormula, (Object)this.formula));
                }
            }
        }
        return this.formula;
    }

    public Formula basicGetFormula() {
        return this.formula;
    }

    public NotificationChain basicSetFormula(Formula newFormula, NotificationChain msgs) {
        Formula oldFormula = this.formula;
        this.formula = newFormula;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldFormula, (Object)newFormula);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setFormula(Formula newFormula) {
        if (newFormula != this.formula) {
            NotificationChain msgs = null;
            if (this.formula != null) {
                msgs = ((InternalEObject)this.formula).eInverseRemove((InternalEObject)this, -6, null, msgs);
            }
            if (newFormula != null) {
                msgs = ((InternalEObject)newFormula).eInverseAdd((InternalEObject)this, -6, null, msgs);
            }
            if ((msgs = this.basicSetFormula(newFormula, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)newFormula, (Object)newFormula));
        }
    }

    @Override
    public boolean removeNode(Node node) {
        if (!this.getNodes().contains((Object)node)) {
            return false;
        }
        for (Edge edge : node.getAllEdges()) {
            this.removeEdge(edge);
        }
        this.getNodes().remove((Object)node);
        return true;
    }

    @Override
    public boolean removeEdge(Edge edge) {
        if (!this.getEdges().contains((Object)edge)) {
            return false;
        }
        edge.setSource(null);
        edge.setTarget(null);
        this.getEdges().remove((Object)edge);
        return true;
    }

    @Override
    public boolean removeNestedCondition(NestedCondition nestedCondition) {
        if (!EcoreUtil.isAncestor((EObject)this, (EObject)nestedCondition)) {
            return false;
        }
        EObject container = nestedCondition.eContainer();
        EcoreUtil.remove((EObject)nestedCondition);
        while (container instanceof UnaryFormula) {
            EObject dummy = container;
            container = container.eContainer();
            EcoreUtil.remove((EObject)dummy);
        }
        if (container instanceof BinaryFormula) {
            BinaryFormula binary = (BinaryFormula)container;
            Formula remainder = binary.getLeft() != null ? binary.getLeft() : binary.getRight();
            EcoreUtil.replace((EObject)binary, (EObject)remainder);
        }
        return true;
    }

    @Override
    public NestedCondition createPAC(String name) {
        NestedConditionImpl pac = new NestedConditionImpl();
        GraphImpl graph = new GraphImpl();
        graph.setName(name);
        pac.setConclusion(graph);
        if (this.formula == null) {
            this.setFormula(pac);
        } else {
            AndImpl and = new AndImpl();
            and.setLeft(this.formula);
            and.setRight(pac);
            this.setFormula(and);
        }
        return pac;
    }

    @Override
    public NestedCondition createNAC(String name) {
        NestedConditionImpl nac = new NestedConditionImpl();
        GraphImpl graph = new GraphImpl();
        graph.setName(name);
        nac.setConclusion(graph);
        NotImpl not = new NotImpl();
        not.setChild(nac);
        if (this.formula == null) {
            this.setFormula(not);
        } else {
            AndImpl and = new AndImpl();
            and.setLeft(this.formula);
            and.setRight(not);
            this.setFormula(and);
        }
        return nac;
    }

    @Override
    public Rule getRule() {
        EObject container = this.eContainer();
        while (container != null) {
            if (container instanceof Rule) {
                return (Rule)container;
            }
            container = container.eContainer();
        }
        return null;
    }

    @Override
    public Node getNode(String name) {
        name = name == null ? "" : name.trim();
        for (Node node : this.getNodes()) {
            String n = node.getName();
            String string = n = n == null ? "" : n.trim();
            if (!name.equals(n)) continue;
            return node;
        }
        return null;
    }

    @Override
    public EList<Node> getNodes(EClass nodeType) {
        BasicEList result = new BasicEList();
        for (Node node : this.getNodes()) {
            if (!nodeType.equals(node.getType())) continue;
            result.add((Object)node);
        }
        return ECollections.unmodifiableEList((EList)result);
    }

    @Override
    public EList<Edge> getEdges(EReference edgeType) {
        BasicEList result = new BasicEList();
        for (Edge edge : this.getEdges()) {
            if (!edgeType.equals(edge.getType())) continue;
            result.add((Object)edge);
        }
        return ECollections.unmodifiableEList((EList)result);
    }

    @Override
    public EList<NestedCondition> getNestedConditions() {
        BasicEList result = new BasicEList();
        this.collectNestedConditions(this.getFormula(), (EList<NestedCondition>)result);
        return ECollections.unmodifiableEList((EList)result);
    }

    private void collectNestedConditions(Formula formula, EList<NestedCondition> nestedConditions) {
        if (formula instanceof NestedCondition) {
            nestedConditions.add((Object)((NestedCondition)formula));
        } else if (formula instanceof UnaryFormula) {
            this.collectNestedConditions(((UnaryFormula)formula).getChild(), nestedConditions);
        } else if (formula instanceof BinaryFormula) {
            this.collectNestedConditions(((BinaryFormula)formula).getLeft(), nestedConditions);
            this.collectNestedConditions(((BinaryFormula)formula).getRight(), nestedConditions);
        }
    }

    @Override
    public NestedCondition getPAC(String name) {
        return this.getPACorNAC(name, true);
    }

    @Override
    public NestedCondition getNAC(String name) {
        return this.getPACorNAC(name, false);
    }

    @Override
    public EList<NestedCondition> getPACs() {
        BasicEList pacs = new BasicEList();
        for (NestedCondition nestedCondition : this.getNestedConditions()) {
            if (!nestedCondition.isPAC()) continue;
            pacs.add((Object)nestedCondition);
        }
        return ECollections.unmodifiableEList((EList)pacs);
    }

    @Override
    public EList<NestedCondition> getNACs() {
        BasicEList nacs = new BasicEList();
        for (NestedCondition nestedCondition : this.getNestedConditions()) {
            if (!nestedCondition.isNAC()) continue;
            nacs.add((Object)nestedCondition);
        }
        return ECollections.unmodifiableEList((EList)nacs);
    }

    private NestedCondition getPACorNAC(String name, boolean isPAC) {
        name = name == null ? "" : name.trim();
        for (NestedCondition cond : this.getNestedConditions()) {
            if (cond.getConclusion() == null || isPAC && !cond.isPAC() || !isPAC && !cond.isNAC()) continue;
            String n = cond.getConclusion().getName();
            String string = n = n == null ? "" : n.trim();
            if (!name.equals(n)) continue;
            return cond;
        }
        return null;
    }

    @Override
    public boolean isLhs() {
        return this.eContainer() instanceof Rule && ((Rule)this.eContainer()).getLhs() == this;
    }

    @Override
    public boolean isRhs() {
        return this.eContainer() instanceof Rule && ((Rule)this.eContainer()).getRhs() == this;
    }

    public boolean isHost() {
        return this.eContainer() instanceof Module;
    }

    @Override
    public boolean isNestedCondition() {
        return this.eContainer() instanceof NestedCondition;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return ((InternalEList)this.getNodes()).basicAdd((Object)otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getEdges()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return ((InternalEList)this.getNodes()).basicRemove((Object)otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getEdges()).basicRemove((Object)otherEnd, msgs);
            }
            case 5: {
                return this.basicSetFormula(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getNodes();
            }
            case 4: {
                return this.getEdges();
            }
            case 5: {
                if (resolve) {
                    return this.getFormula();
                }
                return this.basicGetFormula();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.getNodes().clear();
                this.getNodes().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getEdges().clear();
                this.getEdges().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setFormula((Formula)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.getNodes().clear();
                return;
            }
            case 4: {
                this.getEdges().clear();
                return;
            }
            case 5: {
                this.setFormula(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return this.nodes != null && !this.nodes.isEmpty();
            }
            case 4: {
                return this.edges != null && !this.edges.isEmpty();
            }
            case 5: {
                return this.formula != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        return "Graph " + this.name;
    }
}

