/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.ui.wizard;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.henshin.interpreter.ui.HenshinInterpreterUIPlugin;
import org.eclipse.emf.henshin.interpreter.ui.wizard.ModelSelector;
import org.eclipse.emf.henshin.interpreter.ui.wizard.ParameterEditTable;
import org.eclipse.emf.henshin.interpreter.ui.wizard.UnitSelector;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class HenshinWizardPage
extends WizardPage {
    protected static int CONTROL_OFFSET = 5;
    UnitSelector unitSelector;
    ModelSelector inputSelector;
    ModelSelector outputSelector;
    ParameterEditTable parameterEditor;
    Button openCompare;
    Module module;

    public HenshinWizardPage() {
        super("mainpage");
        this.setDescription(HenshinInterpreterUIPlugin.LL("_UI_Wizard_DefaultDescription"));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, true));
        this.unitSelector = new UnitSelector(container);
        this.unitSelector.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        IResource selected = null;
        if (this.module != null) {
            String path = this.module.eResource().getURI().toPlatformString(true);
            selected = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        }
        this.inputSelector = new ModelSelector(container, selected, false);
        this.inputSelector.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.outputSelector = new ModelSelector(container, selected, true);
        this.outputSelector.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.inputSelector.addModelSelectorListener(new ModelSelector.ModelSelectorListener(){

            @Override
            public boolean modelURIChanged(String modelURI) {
                String output = HenshinWizardPage.this.deriveOutputURI(modelURI);
                if (output != null) {
                    HenshinWizardPage.this.outputSelector.setModelURI(output);
                }
                return true;
            }
        });
        this.parameterEditor = new ParameterEditTable(container);
        this.parameterEditor.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.openCompare = new Button(container, 32);
        this.openCompare.setLayoutData((Object)new GridData(4, 4, true, false));
        this.openCompare.setText("Open Compare");
        this.openCompare.setSelection(true);
        this.inputSelector.getBrowseWorkspaceButton().setFocus();
        this.setControl((Control)container);
    }

    private String deriveOutputURI(String inputUri) {
        try {
            URI uri = URI.createURI((String)inputUri);
            String fileExt = uri.fileExtension();
            uri = uri.trimFileExtension();
            uri = URI.createURI((String)(String.valueOf(uri.toString()) + "_transformed")).appendFileExtension(fileExt);
            return uri.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }
}

