/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.henshin.HenshinModelPlugin;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.And;
import org.eclipse.emf.henshin.model.Annotation;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.AttributeCondition;
import org.eclipse.emf.henshin.model.BinaryFormula;
import org.eclipse.emf.henshin.model.ConditionalUnit;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.IndependentUnit;
import org.eclipse.emf.henshin.model.IteratedUnit;
import org.eclipse.emf.henshin.model.LoopUnit;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.ModelElement;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.MultiUnit;
import org.eclipse.emf.henshin.model.NamedElement;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Not;
import org.eclipse.emf.henshin.model.Or;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.ParameterMapping;
import org.eclipse.emf.henshin.model.PriorityUnit;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.SequentialUnit;
import org.eclipse.emf.henshin.model.UnaryFormula;
import org.eclipse.emf.henshin.model.UnaryUnit;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.Xor;
import org.eclipse.emf.henshin.model.util.ScriptEngineWrapper;

public class HenshinValidator
extends EObjectValidator {
    public static final HenshinValidator INSTANCE = new HenshinValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.emf.henshin.model";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    private static final ScriptEngineWrapper SCRIPT_ENGINE = new ScriptEngineWrapper(new String[0]);

    protected EPackage getEPackage() {
        return HenshinPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateModelElement((ModelElement)value, diagnostics, context);
            }
            case 1: {
                return this.validateAnnotation((Annotation)value, diagnostics, context);
            }
            case 2: {
                return this.validateNamedElement((NamedElement)value, diagnostics, context);
            }
            case 3: {
                return this.validateGraphElement((GraphElement)value, diagnostics, context);
            }
            case 4: {
                return this.validateModule((Module)value, diagnostics, context);
            }
            case 5: {
                return this.validateUnit((Unit)value, diagnostics, context);
            }
            case 6: {
                return this.validateRule((Rule)value, diagnostics, context);
            }
            case 7: {
                return this.validateParameter((Parameter)value, diagnostics, context);
            }
            case 8: {
                return this.validateParameterMapping((ParameterMapping)value, diagnostics, context);
            }
            case 9: {
                return this.validateGraph((Graph)value, diagnostics, context);
            }
            case 10: {
                return this.validateNode((Node)value, diagnostics, context);
            }
            case 11: {
                return this.validateEdge((Edge)value, diagnostics, context);
            }
            case 12: {
                return this.validateAttribute((Attribute)value, diagnostics, context);
            }
            case 13: {
                return this.validateAttributeCondition((AttributeCondition)value, diagnostics, context);
            }
            case 14: {
                return this.validateMapping((Mapping)value, diagnostics, context);
            }
            case 15: {
                return this.validateUnaryUnit((UnaryUnit)value, diagnostics, context);
            }
            case 16: {
                return this.validateMultiUnit((MultiUnit)value, diagnostics, context);
            }
            case 17: {
                return this.validateIndependentUnit((IndependentUnit)value, diagnostics, context);
            }
            case 18: {
                return this.validateSequentialUnit((SequentialUnit)value, diagnostics, context);
            }
            case 19: {
                return this.validateConditionalUnit((ConditionalUnit)value, diagnostics, context);
            }
            case 20: {
                return this.validatePriorityUnit((PriorityUnit)value, diagnostics, context);
            }
            case 21: {
                return this.validateIteratedUnit((IteratedUnit)value, diagnostics, context);
            }
            case 22: {
                return this.validateLoopUnit((LoopUnit)value, diagnostics, context);
            }
            case 23: {
                return this.validateFormula((Formula)value, diagnostics, context);
            }
            case 24: {
                return this.validateNestedCondition((NestedCondition)value, diagnostics, context);
            }
            case 25: {
                return this.validateUnaryFormula((UnaryFormula)value, diagnostics, context);
            }
            case 26: {
                return this.validateBinaryFormula((BinaryFormula)value, diagnostics, context);
            }
            case 27: {
                return this.validateAnd((And)value, diagnostics, context);
            }
            case 28: {
                return this.validateOr((Or)value, diagnostics, context);
            }
            case 29: {
                return this.validateXor((Xor)value, diagnostics, context);
            }
            case 30: {
                return this.validateNot((Not)value, diagnostics, context);
            }
            case 31: {
                return this.validateAction((Action)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateModelElement(ModelElement modelElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(modelElement, diagnostics, context);
    }

    public boolean validateAnnotation(Annotation annotation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(annotation, diagnostics, context);
    }

    public boolean validateNamedElement(NamedElement namedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(namedElement, diagnostics, context);
    }

    public boolean validateRule(Rule rule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(rule, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(rule, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_nameNotEmpty(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_parameterNamesUnique(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_parameterMappingsPointToDirectSubUnit(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRule_mappingsFromLeft2Right(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRule_createdNodesNotAbstract(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRule_createdEdgesNotDerived(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRule_deletedEdgesNotDerived(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRule_uniqueNodeNames(rule, diagnostics, context);
        }
        return result;
    }

    public boolean validateRule_mappingsFromLeft2Right(Rule rule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Iterator iterator = rule.getMappings().iterator();
        while (iterator.hasNext()) {
            Mapping m = (Mapping)iterator.next();
            if (m.getOrigin() == null || m.getImage() == null || m.getOrigin().getGraph().isLhs() && m.getImage().getGraph().isRhs()) continue;
            diagnostics.add(this.createDiagnostic(4, m, Rule.class, "mappingsFromLeft2Right", context));
            result = false;
        }
        return result;
    }

    public boolean validateRule_createdNodesNotAbstract(Rule rule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        for (Node node : rule.getRhs().getNodes()) {
            if (node.getType() == null || !node.getType().isAbstract() || rule.getMappings().getOrigin(node) != null) continue;
            diagnostics.add(this.createDiagnostic(4, node, Rule.class, "createdNodesNotAbstract", context));
            result = false;
        }
        return result;
    }

    public boolean validateRule_createdEdgesNotDerived(Rule rule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        for (Edge edge : rule.getRhs().getEdges()) {
            if (edge.getType() == null || !edge.getType().isDerived() || rule.getMappings().getOrigin(edge) != null) continue;
            diagnostics.add(this.createDiagnostic(4, edge, Rule.class, "createdEdgesNotDerived", context));
            result = false;
        }
        return result;
    }

    public boolean validateRule_deletedEdgesNotDerived(Rule rule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        for (Edge edge : rule.getLhs().getEdges()) {
            if (edge.getType() == null || !edge.getType().isDerived() || rule.getMappings().getImage(edge, rule.getRhs()) != null) continue;
            diagnostics.add(this.createDiagnostic(4, edge, Rule.class, "deletedEdgesNotDerived", context));
            result = false;
        }
        return result;
    }

    public boolean validateRule_uniqueNodeNames(Rule rule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        EList<Node> nodes = rule.getActionNodes(null);
        int size = nodes.size();
        int i = 0;
        while (i < size) {
            Node n1 = (Node)nodes.get(i);
            if (n1.getName() != null && n1.getName().trim().length() != 0) {
                int j = i + 1;
                while (j < size) {
                    Node n2 = (Node)nodes.get(j);
                    if (n2.getName() != null && n1.getName().trim().equals(n2.getName().trim())) {
                        diagnostics.add(this.createDiagnostic(4, n1, Rule.class, "uniqueNodeNames", context));
                        diagnostics.add(this.createDiagnostic(4, n2, Rule.class, "uniqueNodeNames", context));
                        result = false;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    public boolean validateAttributeCondition(AttributeCondition attributeCondition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(attributeCondition, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(attributeCondition, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(attributeCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(attributeCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(attributeCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(attributeCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(attributeCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(attributeCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(attributeCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAttributeCondition_conditionTextNotEmpty(attributeCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAttributeCondition_conditionValidJavaScript(attributeCondition, diagnostics, context);
        }
        return result;
    }

    public boolean validateAttributeCondition_conditionTextNotEmpty(AttributeCondition attributeCondition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (attributeCondition.getConditionText() == null || attributeCondition.getConditionText().trim().length() == 0) {
            diagnostics.add(this.createDiagnostic(4, attributeCondition, AttributeCondition.class, "conditionTextNotEmpty", context));
            return false;
        }
        return true;
    }

    public boolean validateAttributeCondition_conditionValidJavaScript(AttributeCondition attributeCondition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        try {
            this.validateExpression(attributeCondition.getConditionText(), attributeCondition.getRule());
        }
        catch (ScriptException e) {
            diagnostics.add(this.createDiagnostic(4, attributeCondition, AttributeCondition.class, "conditionValidJavaScript", context, e));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateExpression(String expression, Unit unit) throws ScriptException {
        if (expression == null || unit == null) {
            return;
        }
        if ((expression = expression.trim()).length() == 0) {
            return;
        }
        if (SCRIPT_ENGINE.getEngine() == null) {
            return;
        }
        StringBuilder function = new StringBuilder();
        function.append("function _validate_expr(");
        int paramCount = unit.getParameters().size();
        int i = 0;
        while (i < paramCount) {
            Parameter param = (Parameter)unit.getParameters().get(i);
            if (param.getName() == null || param.getName().trim().length() == 0) {
                return;
            }
            function.append(param.getName().trim());
            if (i < paramCount - 1) {
                function.append(", ");
            }
            ++i;
        }
        function.append(") {\n");
        function.append("return\n" + expression + ";\n");
        function.append("}\n");
        ScriptEngineWrapper scriptEngineWrapper = SCRIPT_ENGINE;
        synchronized (scriptEngineWrapper) {
            try {
                SCRIPT_ENGINE.eval(function.toString(), (List<String>)(unit instanceof Rule ? ((Rule)unit).getJavaImports() : new EList<String>()));
            }
            catch (ScriptException e) {
                String msg = e.getMessage() != null ? e.getMessage().replaceFirst(Pattern.quote("<eval>:" + e.getLineNumber() + ":" + e.getColumnNumber()), "position " + (e.getLineNumber() - 2) + ":" + e.getColumnNumber() + ":") : "unknown error";
                throw new ScriptException(msg, e.getFileName(), 1, e.getColumnNumber());
            }
        }
    }

    public boolean validateParameter(Parameter parameter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(parameter, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(parameter, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateParameter_nameNotEmpty(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateParameter_nameNotTypeName(parameter, diagnostics, context);
        }
        return result;
    }

    public boolean validateParameter_nameNotEmpty(Parameter parameter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (parameter.getName() == null || parameter.getName().trim().length() == 0) {
            diagnostics.add(this.createDiagnostic(4, parameter, Parameter.class, "nameNotEmpty", context));
            return false;
        }
        return true;
    }

    public boolean validateParameter_nameNotTypeName(Parameter parameter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (parameter.getName() == null) {
            return true;
        }
        Unit unit = parameter.getUnit();
        if (unit == null) {
            return true;
        }
        Module module = unit.getModule();
        if (module == null) {
            return true;
        }
        for (EPackage epackage : module.getImports()) {
            if (!this.validateParameter_nameNotTypeName(parameter, diagnostics, context, epackage)) continue;
            return false;
        }
        return true;
    }

    private boolean validateParameter_nameNotTypeName(Parameter parameter, DiagnosticChain diagnostics, Map<Object, Object> context, EPackage epackage) {
        for (EClassifier classifier : epackage.getEClassifiers()) {
            if (!parameter.getName().equals(classifier.getName())) continue;
            diagnostics.add(this.createDiagnostic(4, parameter, Parameter.class, "nameNotTypeName", context));
            return false;
        }
        for (EPackage sub : epackage.getESubpackages()) {
            if (this.validateParameter_nameNotTypeName(parameter, diagnostics, context, sub)) continue;
            return false;
        }
        return true;
    }

    public boolean validateGraph(Graph graph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(graph, diagnostics, context);
    }

    public boolean validateGraphElement(GraphElement graphElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(graphElement, diagnostics, context);
    }

    public boolean validateModule(Module module, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(module, diagnostics, context);
    }

    public boolean validateUnit(Unit unit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(unit, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(unit, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(unit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(unit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(unit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(unit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(unit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(unit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(unit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_nameNotEmpty(unit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_parameterNamesUnique(unit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_parameterMappingsPointToDirectSubUnit(unit, diagnostics, context);
        }
        return result;
    }

    public boolean validateUnit_nameNotEmpty(Unit unit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!(unit instanceof Rule && ((Rule)unit).getKernelRule() != null || unit.getName() != null && unit.getName().trim().length() != 0)) {
            diagnostics.add(this.createDiagnostic(4, unit, Unit.class, "nameNotEmpty", context));
            return false;
        }
        return true;
    }

    public boolean validateUnit_parameterNamesUnique(Unit unit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        block0: for (Parameter p1 : unit.getParameters()) {
            if (p1.getName() == null || p1.getName().trim().length() == 0) continue;
            for (Parameter p2 : unit.getParameters()) {
                if (p1 == p2) continue block0;
                if (p2.getName() == null || !p1.getName().trim().equals(p2.getName().trim())) continue;
                diagnostics.add(this.createDiagnostic(4, p2, Unit.class, "parameterNamesUnique", context));
                result = false;
            }
        }
        return result;
    }

    public boolean validateUnit_parameterMappingsPointToDirectSubUnit(Unit unit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        for (ParameterMapping pm : unit.getParameterMappings()) {
            if (unit.getParameters().contains((Object)pm.getSource()) && pm.getTarget() != null && !unit.getSubUnits(false).contains((Object)pm.getTarget().getUnit())) {
                diagnostics.add(this.createDiagnostic(4, unit, Unit.class, "parameterMappingsPointToDirectSubUnit", context));
                return false;
            }
            if (!unit.getParameters().contains((Object)pm.getTarget()) || pm.getSource() == null || unit.getSubUnits(false).contains((Object)pm.getSource().getUnit())) continue;
            diagnostics.add(this.createDiagnostic(4, unit, Unit.class, "parameterMappingsPointToDirectSubUnit", context));
            return false;
        }
        return true;
    }

    public boolean validateMapping(Mapping mapping, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(mapping, diagnostics, context);
    }

    public boolean validateNode(Node node, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(node, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(node, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNode_uniqueAttributeTypes(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNode_atMostOneContainer(node, diagnostics, context);
        }
        return result;
    }

    public boolean validateNode_uniqueAttributeTypes(Node node, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        block0: for (Attribute a1 : node.getAttributes()) {
            if (a1.getType() == null) continue;
            for (Attribute a2 : node.getAttributes()) {
                if (a1 == a2) continue block0;
                if (a1.getType() != a2.getType()) continue;
                diagnostics.add(this.createDiagnostic(4, a2, Node.class, "uniqueAttributeTypes", context));
                result = false;
            }
        }
        return result;
    }

    public boolean validateNode_atMostOneContainer(Node node, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EReference type;
        HashSet<Node> containers = new HashSet<Node>();
        for (Edge incoming : node.getIncoming()) {
            type = incoming.getType();
            if (type == null || !type.isContainment()) continue;
            containers.add(incoming.getSource());
        }
        for (Edge outgoing : node.getOutgoing()) {
            type = outgoing.getType();
            if (type == null || !type.isContainer() || type.getEOpposite() == null) continue;
            containers.add(outgoing.getTarget());
        }
        if (containers.size() > 1) {
            diagnostics.add(this.createDiagnostic(4, node.getActionNode(), Node.class, "atMostOneContainer", context));
        }
        return false;
    }

    public boolean validateAttribute(Attribute attribute, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(attribute, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(attribute, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(attribute, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(attribute, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(attribute, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(attribute, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(attribute, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(attribute, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(attribute, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAttribute_valueValidJavaScript(attribute, diagnostics, context);
        }
        return result;
    }

    public boolean validateAttribute_valueValidJavaScript(Attribute attribute, DiagnosticChain diagnostics, Map<Object, Object> context) {
        try {
            if (attribute.getNode() != null && attribute.getNode().getGraph() != null) {
                this.validateExpression(attribute.getValue(), attribute.getNode().getGraph().getRule());
            }
        }
        catch (ScriptException e) {
            diagnostics.add(this.createDiagnostic(4, attribute, Attribute.class, "valueValidJavaScript", context, e));
        }
        return true;
    }

    public boolean validateEdge(Edge edge, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(edge, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(edge, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEdge_equalParentGraphs(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEdge_indexValidJavaScript(edge, diagnostics, context);
        }
        return result;
    }

    public boolean validateEdge_equalParentGraphs(Edge edge, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (edge.getSource() != null && edge.getTarget() != null && (edge.getSource().getGraph() != edge.getGraph() || edge.getTarget().getGraph() != edge.getGraph())) {
            diagnostics.add(this.createDiagnostic(4, edge, Edge.class, "equalParentGraphs", context));
            return false;
        }
        return true;
    }

    public boolean validateEdge_indexValidJavaScript(Edge edge, DiagnosticChain diagnostics, Map<Object, Object> context) {
        try {
            this.validateExpression(edge.getIndex(), edge.getGraph().getRule());
        }
        catch (ScriptException e) {
            diagnostics.add(this.createDiagnostic(4, edge, Edge.class, "indexValidJavaScript", context, e));
        }
        return true;
    }

    public boolean validateUnaryUnit(UnaryUnit unaryUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(unaryUnit, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(unaryUnit, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(unaryUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(unaryUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(unaryUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(unaryUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(unaryUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(unaryUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(unaryUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_nameNotEmpty(unaryUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_parameterNamesUnique(unaryUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_parameterMappingsPointToDirectSubUnit(unaryUnit, diagnostics, context);
        }
        return result;
    }

    public boolean validateMultiUnit(MultiUnit multiUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(multiUnit, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(multiUnit, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(multiUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(multiUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(multiUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(multiUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(multiUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(multiUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(multiUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_nameNotEmpty(multiUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_parameterNamesUnique(multiUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_parameterMappingsPointToDirectSubUnit(multiUnit, diagnostics, context);
        }
        return result;
    }

    public boolean validateIndependentUnit(IndependentUnit independentUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(independentUnit, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(independentUnit, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_nameNotEmpty(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_parameterNamesUnique(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_parameterMappingsPointToDirectSubUnit(independentUnit, diagnostics, context);
        }
        return result;
    }

    public boolean validateSequentialUnit(SequentialUnit sequentialUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(sequentialUnit, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(sequentialUnit, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_nameNotEmpty(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_parameterNamesUnique(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_parameterMappingsPointToDirectSubUnit(sequentialUnit, diagnostics, context);
        }
        return result;
    }

    public boolean validateConditionalUnit(ConditionalUnit conditionalUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(conditionalUnit, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(conditionalUnit, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_nameNotEmpty(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_parameterNamesUnique(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_parameterMappingsPointToDirectSubUnit(conditionalUnit, diagnostics, context);
        }
        return result;
    }

    public boolean validatePriorityUnit(PriorityUnit priorityUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(priorityUnit, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(priorityUnit, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_nameNotEmpty(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_parameterNamesUnique(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_parameterMappingsPointToDirectSubUnit(priorityUnit, diagnostics, context);
        }
        return result;
    }

    public boolean validateIteratedUnit(IteratedUnit iteratedUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(iteratedUnit, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(iteratedUnit, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(iteratedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(iteratedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(iteratedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(iteratedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(iteratedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(iteratedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(iteratedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_nameNotEmpty(iteratedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_parameterNamesUnique(iteratedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_parameterMappingsPointToDirectSubUnit(iteratedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIteratedUnit_iterationsNotEmpty(iteratedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIteratedUnit_iterationsValidJavaScript(iteratedUnit, diagnostics, context);
        }
        return result;
    }

    public boolean validateIteratedUnit_iterationsNotEmpty(IteratedUnit iteratedUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (iteratedUnit.getIterations() == null || iteratedUnit.getIterations().trim().length() == 0) {
            diagnostics.add(this.createDiagnostic(4, iteratedUnit, Edge.class, "iterationsNotEmpty", context));
            return false;
        }
        return true;
    }

    public boolean validateIteratedUnit_iterationsValidJavaScript(IteratedUnit iteratedUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        try {
            this.validateExpression(iteratedUnit.getIterations(), iteratedUnit);
        }
        catch (ScriptException e) {
            diagnostics.add(this.createDiagnostic(4, iteratedUnit, IteratedUnit.class, "iterationsValidJavaScript", context, e));
        }
        return true;
    }

    public boolean validateLoopUnit(LoopUnit loopUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(loopUnit, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(loopUnit, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(loopUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(loopUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(loopUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(loopUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(loopUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(loopUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(loopUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_nameNotEmpty(loopUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_parameterNamesUnique(loopUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnit_parameterMappingsPointToDirectSubUnit(loopUnit, diagnostics, context);
        }
        return result;
    }

    public boolean validateNestedCondition(NestedCondition nestedCondition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(nestedCondition, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(nestedCondition, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(nestedCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(nestedCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(nestedCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(nestedCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(nestedCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(nestedCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(nestedCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNestedCondition_mappingOriginContainedInParentCondition(nestedCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNestedCondition_mappingImageContainedInCurrent(nestedCondition, diagnostics, context);
        }
        return result;
    }

    public boolean validateNestedCondition_mappingOriginContainedInParentCondition(NestedCondition nestedCondition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Graph graph = nestedCondition.getHost();
        if (graph != null && graph.eContainer() instanceof NestedCondition) {
            Iterator iterator = nestedCondition.getMappings().iterator();
            while (iterator.hasNext()) {
                Mapping mapping = (Mapping)iterator.next();
                if (mapping.getOrigin() == null || mapping.getOrigin().getGraph() == graph) continue;
                diagnostics.add(this.createDiagnostic(4, mapping, NestedCondition.class, "mappingOriginContainedInParentCondition", context));
                return false;
            }
        }
        return true;
    }

    public boolean validateNestedCondition_mappingImageContainedInCurrent(NestedCondition nestedCondition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Iterator iterator = nestedCondition.getMappings().iterator();
        while (iterator.hasNext()) {
            Mapping mapping = (Mapping)iterator.next();
            if (nestedCondition.getConclusion().getNodes().contains((Object)mapping.getImage())) continue;
            diagnostics.add(this.createDiagnostic(4, mapping, NestedCondition.class, "mappingImageContainedInCurrent", context));
            return false;
        }
        return true;
    }

    public boolean validateFormula(Formula formula, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(formula, diagnostics, context);
    }

    public boolean validateUnaryFormula(UnaryFormula unaryFormula, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(unaryFormula, diagnostics, context);
    }

    public boolean validateBinaryFormula(BinaryFormula binaryFormula, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(binaryFormula, diagnostics, context);
    }

    public boolean validateAnd(And and, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(and, diagnostics, context);
    }

    public boolean validateOr(Or or, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(or, diagnostics, context);
    }

    public boolean validateNot(Not not, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(not, diagnostics, context);
    }

    public boolean validateAction(Action action, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateXor(Xor xor, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(xor, diagnostics, context);
    }

    public boolean validateParameterMapping(ParameterMapping parameterMapping, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(parameterMapping, diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return HenshinModelPlugin.INSTANCE;
    }

    private Diagnostic createDiagnostic(int severity, EObject object, Class<?> targetType, String constraint, Map<Object, Object> context) {
        return this.createDiagnostic(severity, object, targetType, constraint, context, null);
    }

    private Diagnostic createDiagnostic(int severity, EObject object, Class<?> targetType, String constraint, Map<Object, Object> context, Exception exception) {
        Object[] objectArray;
        String objectLabel;
        String typeName = targetType.getSimpleName();
        String string = objectLabel = object instanceof NamedElement ? String.valueOf(((NamedElement)object).getName()) : HenshinValidator.getObjectLabel((EObject)object, context);
        if (exception != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = objectLabel;
            objectArray = objectArray2;
            objectArray2[1] = exception.getMessage();
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = objectLabel;
        }
        return this.createDiagnostic(severity, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", objectArray, new Object[]{object}, context, "_Constraint_Msg_" + typeName + "_" + constraint);
    }

    protected BasicDiagnostic createDiagnostic(int severity, String source, int code, String messageKey, Object[] messageSubstitutions, Object[] data, Map<Object, Object> context, String customMessage) {
        String message = customMessage != null && customMessage.length() > 0 ? (customMessage.startsWith("_") ? this.getString(customMessage, messageSubstitutions) : customMessage) : this.getString(messageKey, messageSubstitutions);
        return new BasicDiagnostic(severity, source, code, message, data);
    }
}

