/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.ui.wizard;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.henshin.interpreter.ui.HenshinInterpreterUIPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class UnitSelector {
    static final boolean UNIT_FILTER_DEFAULT = false;
    protected int CONTROL_OFFSET = 5;
    protected Collection<UnitSelectionListener> listeners = new ArrayList<UnitSelectionListener>();
    protected Group container;
    protected Combo unitSelector;
    protected Button unitFilter;
    protected String[] selectableUnits;
    protected String[] outerUnits;

    public UnitSelector(Composite parent) {
        this.container = new Group(parent, 0);
        this.container.setText(HenshinInterpreterUIPlugin.LL("_UI_SelectTransformationUnit"));
        this.container.setLayout((Layout)new FormLayout());
        this.unitSelector = new Combo((Composite)this.container, 0);
        FormData data = new FormData();
        data.top = new FormAttachment(0, this.CONTROL_OFFSET);
        data.left = new FormAttachment(0, this.CONTROL_OFFSET);
        data.right = new FormAttachment(100, -this.CONTROL_OFFSET);
        this.unitSelector.setLayoutData((Object)data);
        this.unitSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (UnitSelectionListener l : UnitSelector.this.listeners) {
                    l.unitSelected(UnitSelector.this.unitSelector.getSelectionIndex(), UnitSelector.this.unitFilter.getSelection());
                }
            }
        });
        this.unitFilter = new Button((Composite)this.container, 32);
        this.unitFilter.setAlignment(0x1000000);
        this.unitFilter.setText(HenshinInterpreterUIPlugin.LL("_UI_ShowInnerUnits"));
        data = new FormData();
        data.top = new FormAttachment((Control)this.unitSelector, this.CONTROL_OFFSET);
        data.right = new FormAttachment(100, -this.CONTROL_OFFSET);
        this.unitFilter.setLayoutData((Object)data);
        this.unitFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UnitSelector.this.updateSelection(UnitSelector.this.unitFilter.getSelection());
            }
        });
        this.unitFilter.setSelection(false);
    }

    public Control getControl() {
        return this.container;
    }

    public void setSelection(int idx) {
        this.unitSelector.select(idx);
    }

    public void setSelectableUnits(String[] selectableUnits, String[] outerUnits) {
        this.selectableUnits = selectableUnits;
        this.outerUnits = outerUnits;
        this.updateSelection(false);
    }

    private void updateSelection(Boolean showInnerUnits) {
        String[] selectionArray;
        this.unitSelector.removeAll();
        String[] stringArray = selectionArray = showInnerUnits != false ? this.selectableUnits : this.outerUnits;
        int n = selectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            String unit = stringArray[n2];
            this.unitSelector.add(unit);
            ++n2;
        }
        if (this.unitSelector.getItemCount() > 0) {
            this.unitSelector.setText(this.unitSelector.getItem(0));
        }
    }

    public void addUnitSelectionListener(UnitSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void setEnabled(boolean enabled) {
        this.unitSelector.setEnabled(enabled);
    }

    public static interface UnitSelectionListener {
        public boolean unitSelected(int var1, boolean var2);
    }
}

