/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.sierpinski;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.henshin.interpreter.ApplicationMonitor;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.interpreter.impl.BasicApplicationMonitor;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.RuleApplicationImpl;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class SierpinskiBenchmark {
    public static final String PATH = "src/org/eclipse/emf/henshin/examples/sierpinski";

    public static void run(String path, int iterations) {
        HenshinResourceSet resourceSet = new HenshinResourceSet(path);
        Module module = resourceSet.getModule("sierpinski.henshin", false);
        Rule rule = (Rule)module.getUnit("AddTriangle");
        Resource resource = resourceSet.getResource("sierpinski-start.xmi");
        EGraphImpl graph = new EGraphImpl(resource);
        EObject container = (EObject)resource.getContents().get(0);
        graph.remove((Object)container);
        EngineImpl engine = new EngineImpl();
        RuleApplicationImpl application = new RuleApplicationImpl((Engine)engine);
        application.setRule(rule);
        application.setEGraph((EGraph)graph);
        System.out.println("Starting Sierpinski benchmark...");
        System.out.println(String.valueOf(Runtime.getRuntime().maxMemory() / 0x100000L) + "MB available memory\n");
        System.out.println("Level\tMatches\tNodes\tMatTime\tAppTime\tTotTime");
        int expectedNodes = 3;
        int expectedMatches = 1;
        ArrayList<Match> matches = new ArrayList<Match>();
        int i = 0;
        while (i < iterations) {
            matches.clear();
            System.gc();
            long startTime = System.currentTimeMillis();
            for (Match match : engine.findMatches(rule, (EGraph)graph, null)) {
                matches.add(match);
            }
            long matchingTime = System.currentTimeMillis() - startTime;
            BasicApplicationMonitor monitor = new BasicApplicationMonitor();
            System.gc();
            startTime = System.currentTimeMillis();
            for (Match match : matches) {
                application.setCompleteMatch(match);
                if (application.execute((ApplicationMonitor)monitor)) continue;
                throw new RuntimeException("Error transforming Sierpinski model");
            }
            long runtime = System.currentTimeMillis() - startTime;
            System.out.println(String.valueOf(i + 1) + "\t" + matches.size() + "\t" + graph.size() + "\t" + matchingTime + "\t" + runtime + "\t" + (matchingTime + runtime));
            if (matches.size() != expectedMatches) {
                throw new RuntimeException("Expected " + expectedMatches + " matches instead of " + matches.size());
            }
            if (graph.size() != (expectedNodes += (expectedMatches *= 3))) {
                throw new RuntimeException("Expected " + expectedNodes + " nodes instead of " + graph.size());
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        int iterations = Integer.parseInt(args[0]);
        SierpinskiBenchmark.run(PATH, iterations);
    }
}

