/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.jms.internal.server;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.net4j.internal.jms.DestinationImpl;
import org.eclipse.net4j.internal.jms.MessageImpl;
import org.eclipse.net4j.jms.internal.server.Server;
import org.eclipse.net4j.jms.internal.server.ServerConnection;
import org.eclipse.net4j.jms.internal.server.ServerConsumer;
import org.eclipse.net4j.jms.internal.server.ServerDestination;
import org.eclipse.net4j.jms.internal.server.bundle.OM;
import org.eclipse.net4j.jms.internal.server.messages.Messages;
import org.eclipse.net4j.jms.server.ISession;
import org.eclipse.net4j.jms.server.IStore;
import org.eclipse.net4j.jms.server.IStoreTransaction;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

public class ServerSession
extends Lifecycle
implements ISession {
    private ServerConnection connection;
    private int id;
    private ConcurrentMap<Long, ServerConsumer> consumers = new ConcurrentHashMap<Long, ServerConsumer>();

    public ServerSession(ServerConnection connection, int id) {
        this.connection = connection;
        this.id = id;
    }

    public ServerConnection getConnection() {
        return this.connection;
    }

    public int getID() {
        return this.id;
    }

    public long registerConsumer(DestinationImpl dest, String messageSelector, boolean noLocal, boolean durable) {
        String name;
        Server server = this.connection.getServer();
        ServerDestination destination = server.getDestination(name = dest.getName());
        if (destination == null) {
            OM.LOG.error(MessageFormat.format(Messages.getString("ServerSession_0"), name));
            return -1L;
        }
        ServerConsumer consumer = server.createConsumer(destination, messageSelector, noLocal, durable);
        consumer.setSession(this);
        this.consumers.put(consumer.getID(), consumer);
        destination.addConsumer(consumer);
        return consumer.getID();
    }

    public void handleAcknowledge() {
        IStore store = this.connection.getServer().getStore();
        IStoreTransaction transaction = store.startTransaction();
        this.handleAcknowledgeInTransaction(transaction);
        store.commitTransaction(transaction);
    }

    public void handleAcknowledgeInTransaction(IStoreTransaction transaction) {
        for (ServerConsumer consumer : this.consumers.values()) {
            consumer.handleAcknowledge(transaction);
        }
    }

    public void handleRecover() {
        IStore store = this.connection.getServer().getStore();
        IStoreTransaction transaction = store.startTransaction();
        Collection values = this.consumers.values();
        for (ServerConsumer consumer : values) {
            consumer.handleRecover(transaction);
        }
        store.commitTransaction(transaction);
    }

    public String[] handleCommit(MessageImpl[] messages) {
        Server server = this.connection.getServer();
        IStore store = server.getStore();
        IStoreTransaction transaction = store.startTransaction();
        this.handleAcknowledgeInTransaction(transaction);
        String[] messageIDs = server.handleClientMessagesInTransaction(transaction, messages);
        store.commitTransaction(transaction);
        return messageIDs;
    }
}

