/*
 * Decompiled with CFR 0.152.
 */
package hbtutorial;

import java.util.Properties;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.teneo.hibernate.HbDataStore;
import org.eclipse.emf.teneo.hibernate.HbHelper;
import org.eclipse.example.library.Book;
import org.eclipse.example.library.BookCategory;
import org.eclipse.example.library.Library;
import org.eclipse.example.library.LibraryFactory;
import org.eclipse.example.library.LibraryPackage;
import org.eclipse.example.library.Writer;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.dialect.MySQLInnoDBDialect;

public class QuickStart {
    public static void main(String[] args) {
        String dbName = "library";
        QuickStart.doQuickStart(dbName);
    }

    public static HbDataStore doQuickStart(String dbName) {
        String hbName = "Library";
        HbDataStore hbds = HbHelper.INSTANCE.createRegisterDataStore(hbName);
        Properties props = new Properties();
        props.setProperty("hibernate.connection.driver_class", "com.mysql.jdbc.Driver");
        props.setProperty("hibernate.connection.username", "root");
        props.setProperty("hibernate.connection.url", "jdbc:mysql://127.0.0.1:3306/" + dbName);
        props.setProperty("hibernate.connection.password", "root");
        props.setProperty("hibernate.dialect", MySQLInnoDBDialect.class.getName());
        hbds.setProperties(props);
        hbds.setEPackages(new EPackage[]{LibraryPackage.eINSTANCE});
        hbds.initialize();
        SessionFactory sessionFactory = hbds.getSessionFactory();
        Session session = sessionFactory.openSession();
        Transaction tx = session.getTransaction();
        tx.begin();
        Library lib = LibraryFactory.eINSTANCE.createLibrary();
        lib.setName("My Library");
        session.save((Object)lib);
        Writer writer = LibraryFactory.eINSTANCE.createWriter();
        writer.setName("JRR Tolkien");
        Book book = LibraryFactory.eINSTANCE.createBook();
        book.setAuthor(writer);
        book.setPages(305);
        book.setTitle("The Hobbit");
        book.setCategory(BookCategory.SCIENCE_FICTION);
        lib.getWriters().add((Object)writer);
        lib.getBooks().add((Object)book);
        tx.commit();
        session.close();
        return hbds;
    }
}

