/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.eclipse.resourcehandler;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.teneo.eclipse.StoreEclipseUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;

public abstract class StoreImportXML
implements IObjectActionDelegate {
    private static Log log = LogFactory.getLog(StoreImportXML.class);
    private IStructuredSelection selection = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    protected boolean isXMLImport() {
        return true;
    }

    public void run(IAction action) {
        try {
            String title = this.isXMLImport() ? "Select one or more XML resources to import from." : "Select one or more XMI resources to import from.";
            ResourceSelectionDialog dialog = new ResourceSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), title);
            dialog.open();
            Object[] fileObjs = dialog.getResult();
            if (fileObjs == null) {
                return;
            }
            IFile[] files = new IFile[fileObjs.length];
            int i = 0;
            while (i < fileObjs.length) {
                files[i] = (IFile)fileObjs[i];
                ++i;
            }
            Properties props = StoreEclipseUtil.readPropFile(this.selection);
            LocalJob wj = new LocalJob(files, props);
            wj.schedule();
        }
        catch (Exception c) {
            StoreEclipseUtil.handleError(c, log);
        }
    }

    protected abstract void doImport(IFile[] var1, Properties var2);

    public void selectionChanged(IAction action, ISelection selected) {
        IStructuredSelection structSelection;
        if (!(selected instanceof IStructuredSelection)) {
            return;
        }
        this.selection = structSelection = (IStructuredSelection)selected;
    }

    private class LocalJob
    extends WorkspaceJob {
        private IFile[] files;
        private Properties props;

        LocalJob(IFile[] files, Properties props) {
            super("Import");
            this.files = files;
            this.props = props;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            StoreImportXML.this.doImport(this.files, this.props);
            return Status.OK_STATUS;
        }
    }
}

