/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.util;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.util.InvalidObjectException;
import org.eclipse.emf.cdo.util.ObjectNotFoundException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.internal.cdo.CDOLegacyAdapter;
import org.eclipse.emf.internal.cdo.CDOLegacyWrapper;
import org.eclipse.emf.internal.cdo.CDOMetaWrapper;
import org.eclipse.emf.internal.cdo.CDOStateMachine;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FSMUtil {
    private FSMUtil() {
    }

    public static boolean isTransient(CDOObject object) {
        CDOState state = object.cdoState();
        return state == CDOState.TRANSIENT || state == CDOState.PREPARED;
    }

    public static boolean isInvalid(CDOObject object) {
        CDOState state = object.cdoState();
        return state == CDOState.INVALID || state == CDOState.INVALID_CONFLICT;
    }

    public static boolean isConflict(CDOObject object) {
        CDOState state = object.cdoState();
        return state == CDOState.CONFLICT || state == CDOState.INVALID_CONFLICT;
    }

    public static boolean isNew(CDOObject object) {
        CDOState state = object.cdoState();
        return state == CDOState.NEW;
    }

    public static boolean isMeta(Object object) {
        if (object instanceof EModelElement || object instanceof EGenericType) {
            EClass eClass = ((EObject)object).eClass();
            if (eClass == null) {
                return false;
            }
            EPackage ePackage = eClass.getEPackage();
            if (ePackage == null) {
                return false;
            }
            return ePackage.getNsURI() == "http://www.eclipse.org/emf/2002/Ecore";
        }
        return object instanceof EStringToStringMapEntryImpl;
    }

    public static boolean isWatchable(Object obj) {
        if (obj instanceof CDOObject) {
            CDOObject cdoObject = (CDOObject)obj;
            return cdoObject.cdoState() == CDOState.CLEAN || cdoObject.cdoState() == CDOState.DIRTY;
        }
        return false;
    }

    public static InternalCDOObject adapt(Object object, CDOView view) {
        if (view.isClosed()) {
            throw new IllegalStateException(Messages.getString("FSMUtil.0"));
        }
        if (object instanceof InternalCDOObject) {
            return (InternalCDOObject)object;
        }
        if (object == null) {
            throw new IllegalArgumentException(Messages.getString("FSMUtil.1"));
        }
        if (FSMUtil.isMeta(object)) {
            return FSMUtil.adaptMeta((InternalEObject)object, view);
        }
        if (object instanceof InternalEObject) {
            return FSMUtil.adaptLegacy((InternalEObject)object);
        }
        return null;
    }

    public static InternalCDOObject adaptMeta(InternalEObject object, CDOView view) {
        if (view == null) {
            throw new IllegalArgumentException(Messages.getString("FSMUtil.2"));
        }
        if (object.eIsProxy()) {
            object = (InternalEObject)EcoreUtil.resolve((EObject)object, (ResourceSet)view.getResourceSet());
        }
        try {
            InternalCDOPackageRegistry packageRegistry = (InternalCDOPackageRegistry)view.getSession().getPackageRegistry();
            CDOID id = packageRegistry.getMetaInstanceMapper().lookupMetaInstanceID(object);
            return new CDOMetaWrapper((InternalCDOView)view, object, id);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public static InternalCDOObject adaptLegacy(InternalEObject object) {
        if (object.getClass() == DynamicEObjectImpl.class) {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("FSMUtil.4")) + object);
        }
        EList adapters = object.eAdapters();
        CDOLegacyAdapter adapter = FSMUtil.getLegacyAdapter((EList<Adapter>)adapters);
        if (adapter == null) {
            adapter = new CDOLegacyAdapter();
            adapters.add((Object)adapter);
        }
        return adapter;
    }

    public static CDOLegacyAdapter getLegacyAdapter(EList<Adapter> adapters) {
        return (CDOLegacyAdapter)EcoreUtil.getAdapter(adapters, CDOLegacyAdapter.class);
    }

    @Deprecated
    public static CDOLegacyWrapper getLegacyWrapper(EList<?> listeners) {
        for (Object listener : listeners) {
            if (listener.getClass() != CDOLegacyWrapper.class) continue;
            return (CDOLegacyWrapper)listener;
        }
        return null;
    }

    @Deprecated
    public static Object getLegacyWrapper(InternalEObject object) {
        throw new UnsupportedOperationException();
    }

    public static void validate(CDOObject object, CDORevision revision) {
        if (revision == null) {
            CDOStateMachine.INSTANCE.detachRemote((InternalCDOObject)object);
            throw new InvalidObjectException(object.cdoID());
        }
    }

    public static void validate(CDOID id, CDORevision revision) {
        if (revision == null) {
            throw new ObjectNotFoundException(id);
        }
    }

    public static Iterator<InternalCDOObject> getProperContents(InternalCDOObject object) {
        final boolean isResource = object instanceof Resource;
        final InternalCDOView cdoView = object.cdoView();
        final Iterator delegate = object.eContents().iterator();
        return new Iterator<InternalCDOObject>(){
            private Object next;

            @Override
            public boolean hasNext() {
                while (delegate.hasNext()) {
                    InternalEObject eObject = (InternalEObject)delegate.next();
                    if (!isResource && eObject.eDirectResource() != null) continue;
                    this.next = FSMUtil.adapt(eObject, cdoView);
                    if (!(this.next instanceof InternalCDOObject)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public InternalCDOObject next() {
                return (InternalCDOObject)this.next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Iterator<InternalCDOObject> iterator(final Iterator<?> delegate, final InternalCDOView view) {
        return new Iterator<InternalCDOObject>(){
            private Object next;

            @Override
            public boolean hasNext() {
                while (delegate.hasNext()) {
                    this.next = FSMUtil.adapt(delegate.next(), view);
                    if (!(this.next instanceof InternalCDOObject)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public InternalCDOObject next() {
                return (InternalCDOObject)this.next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Iterator<InternalCDOObject> iterator(Collection<?> instances, InternalCDOView view) {
        return FSMUtil.iterator(instances.iterator(), view);
    }
}

