/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.editor;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.emf.cdo.CDOAudit;
import org.eclipse.emf.cdo.CDOSession;
import org.eclipse.emf.cdo.CDOView;
import org.eclipse.emf.cdo.common.CDOProtocolView;
import org.eclipse.emf.cdo.internal.ui.SharedIcons;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class CDOEditorInput
extends PlatformObject
implements IEditorInput {
    private CDOView view;
    private String resourcePath;

    public CDOEditorInput(CDOView view, String resourcePath) {
        this.view = view;
        this.resourcePath = resourcePath;
    }

    public CDOView getView() {
        return this.view;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        switch (this.view.getViewType()) {
            case TRANSACTION: {
                return SharedIcons.getDescriptor("obj16/cdo_editor");
            }
            case READONLY: {
                return SharedIcons.getDescriptor("obj16/cdo_editor_readonly");
            }
            case AUDIT: {
                return SharedIcons.getDescriptor("obj16/cdo_editor_historical");
            }
        }
        return null;
    }

    public String getName() {
        if (this.resourcePath != null) {
            return new Path(this.resourcePath).lastSegment();
        }
        return this.view.getSession().getRepositoryName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        CDOSession session = this.view.getSession();
        IConnector connector = session.getConnector();
        String repositoryName = session.getRepositoryName();
        StringBuilder builder = new StringBuilder();
        builder.append(connector.getURL());
        builder.append("/");
        builder.append(repositoryName);
        if (this.resourcePath != null) {
            builder.append(this.resourcePath);
        }
        builder.append(" [");
        builder.append(session.getSessionID());
        builder.append(":");
        builder.append(this.view.getViewID());
        builder.append("]");
        if (this.view.getViewType() != CDOProtocolView.Type.TRANSACTION) {
            builder.append(" readonly");
        }
        if (this.view instanceof CDOAudit) {
            builder.append(MessageFormat.format(" {0,date} {0,time}", ((CDOAudit)this.view).getTimeStamp()));
        }
        return builder.toString();
    }
}

