/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.ArrayList;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.internal.server.Session;
import org.eclipse.emf.cdo.internal.server.SessionManager;
import org.eclipse.emf.cdo.server.INotificationManager;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

public class NotificationManager
extends Lifecycle
implements INotificationManager {
    private IRepository repository;

    public IRepository getRepository() {
        return this.repository;
    }

    public void setRepository(IRepository repository) {
        this.repository = repository;
    }

    public void notifyCommit(ISession session, IStoreAccessor.CommitContext commitContext) {
        int detachedObjectsSize;
        InternalCDORevisionDelta[] arrayOfDeltas = commitContext.getDirtyObjectDeltas();
        CDOID[] arrayOfDetachedObjects = commitContext.getDetachedObjects();
        InternalCDOPackageUnit[] arrayOfNewPackageUnit = commitContext.getNewPackageUnits();
        int dirtyIDSize = arrayOfDeltas == null ? 0 : arrayOfDeltas.length;
        int n = detachedObjectsSize = arrayOfDetachedObjects == null ? 0 : arrayOfDetachedObjects.length;
        if (dirtyIDSize > 0 || detachedObjectsSize > 0 || arrayOfNewPackageUnit.length > 0) {
            ArrayList<CDOIDAndVersion> dirtyIDs = new ArrayList<CDOIDAndVersion>(dirtyIDSize);
            ArrayList<CDORevisionDelta> deltas = new ArrayList<CDORevisionDelta>(dirtyIDSize);
            int i = 0;
            while (i < dirtyIDSize) {
                InternalCDORevisionDelta delta = arrayOfDeltas[i];
                CDOIDAndVersion dirtyIDAndVersion = CDOIDUtil.createIDAndVersion((CDOID)delta.getID(), (int)delta.getOriginVersion());
                dirtyIDs.add(dirtyIDAndVersion);
                deltas.add((CDORevisionDelta)delta);
                ++i;
            }
            ArrayList<CDOID> detachedObjects = new ArrayList<CDOID>(detachedObjectsSize);
            int i2 = 0;
            while (i2 < detachedObjectsSize) {
                detachedObjects.add(arrayOfDetachedObjects[i2]);
                ++i2;
            }
            SessionManager sessionManager = (SessionManager)this.repository.getSessionManager();
            sessionManager.handleCommitNotification(commitContext.getTimeStamp(), (CDOPackageUnit[])arrayOfNewPackageUnit, dirtyIDs, detachedObjects, deltas, (Session)session);
        }
    }
}

