/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageTypeRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.server.internal.hibernate.bundle.OM;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateCDOPackageUnit
implements InternalCDOPackageUnit {
    private String nsUri;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HibernateCDOPackageUnit.class);
    private InternalCDOPackageRegistry packageRegistry;
    private CDOPackageUnit.State state = CDOPackageUnit.State.PROXY;
    private CDOPackageUnit.Type type;
    private CDOPackageUnit.Type originalType;
    private long timeStamp;
    private InternalCDOPackageInfo[] packageInfos;

    public HibernateCDOPackageUnit() {
    }

    public HibernateCDOPackageUnit(CDOPackageUnit cdoPackageUnit) {
        this.setType(cdoPackageUnit.getType());
        this.setPackageInfos((InternalCDOPackageInfo[])cdoPackageUnit.getPackageInfos());
        this.setOriginalType(cdoPackageUnit.getOriginalType());
        this.setPackageRegistry((InternalCDOPackageRegistry)cdoPackageUnit.getPackageRegistry());
        this.setTimeStamp(cdoPackageUnit.getTimeStamp());
    }

    public String getNsUri() {
        if (this.nsUri == null) {
            this.nsUri = this.getPackageInfos()[0].getPackageURI();
        }
        return this.nsUri;
    }

    public void setNsUri(String nsUri) {
        this.nsUri = nsUri;
    }

    public InternalCDOPackageRegistry getPackageRegistry() {
        return this.packageRegistry;
    }

    public void setPackageRegistry(InternalCDOPackageRegistry packageRegistry) {
        this.packageRegistry = packageRegistry;
    }

    public String getID() {
        try {
            return this.getTopLevelPackageInfo().getPackageURI();
        }
        catch (RuntimeException runtimeException) {
            return "UNINITIALIZED";
        }
    }

    public CDOPackageUnit.State getState() {
        return this.state;
    }

    public void setState(CDOPackageUnit.State state) {
        this.state = state;
        if (state == CDOPackageUnit.State.LOADED) {
            this.type = null;
        }
    }

    public CDOPackageUnit.Type getType() {
        if (this.getOriginalType() == CDOPackageUnit.Type.DYNAMIC) {
            this.type = CDOPackageUnit.Type.DYNAMIC;
        } else if (this.type == null || this.type == CDOPackageUnit.Type.UNKNOWN) {
            if (this.state == CDOPackageUnit.State.PROXY) {
                this.type = CDOPackageTypeRegistry.INSTANCE.lookup(this.getID());
            } else {
                InternalCDOPackageInfo packageInfo = this.getTopLevelPackageInfo();
                EPackage ePackage = packageInfo.getEPackage();
                this.type = CDOPackageTypeRegistry.INSTANCE.lookup(ePackage);
            }
            if (this.type == null) {
                this.type = CDOPackageUnit.Type.UNKNOWN;
            }
        }
        return this.type;
    }

    public CDOPackageUnit.Type getOriginalType() {
        return this.originalType;
    }

    public void setOriginalType(CDOPackageUnit.Type originalType) {
        this.originalType = originalType;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public InternalCDOPackageInfo getTopLevelPackageInfo() {
        if (this.packageInfos == null || this.packageInfos.length == 0) {
            throw new IllegalStateException("Package unit not initialized");
        }
        return this.packageInfos[0];
    }

    public InternalCDOPackageInfo getPackageInfo(String packageURI) {
        InternalCDOPackageInfo[] internalCDOPackageInfoArray = this.packageInfos;
        int n = this.packageInfos.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
            if (packageInfo.getPackageURI().equals(packageURI)) {
                return packageInfo;
            }
            ++n2;
        }
        return null;
    }

    public InternalCDOPackageInfo[] getPackageInfos() {
        return this.packageInfos;
    }

    public void setPackageInfos(InternalCDOPackageInfo[] packageInfos) {
        this.packageInfos = packageInfos;
        InternalCDOPackageInfo[] internalCDOPackageInfoArray = packageInfos;
        int n = packageInfos.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
            packageInfo.setPackageUnit((InternalCDOPackageUnit)this);
            ++n2;
        }
    }

    public EPackage[] getEPackages(boolean loadOnDemand) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        InternalCDOPackageInfo[] internalCDOPackageInfoArray = this.packageInfos;
        int n = this.packageInfos.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
            EPackage ePackage = packageInfo.getEPackage(loadOnDemand);
            if (ePackage != null) {
                result.add(ePackage);
            }
            ++n2;
        }
        return result.toArray(new EPackage[result.size()]);
    }

    public boolean isSystem() {
        return this.getTopLevelPackageInfo().isSystemPackage();
    }

    public void init(EPackage ePackage) {
        EPackage topLevelPackage = EMFUtil.getTopLevelPackage((EPackage)ePackage);
        ArrayList<InternalCDOPackageInfo> result = new ArrayList<InternalCDOPackageInfo>();
        this.initPackageInfos(topLevelPackage, result);
        this.packageInfos = result.toArray(new InternalCDOPackageInfo[result.size()]);
        this.setState(CDOPackageUnit.State.NEW);
        this.originalType = this.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        InternalCDOPackageInfo[] internalCDOPackageInfoArray = this.packageInfos;
        int n = this.packageInfos.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
            EPackage ePackage = packageInfo.getEPackage(false);
            if (ePackage != null) {
                EPackage ePackage2 = ePackage;
                synchronized (ePackage2) {
                    ePackage.eAdapters().remove((Object)packageInfo);
                }
            }
            ++n2;
        }
        this.packageInfos = null;
        this.setState(CDOPackageUnit.State.DISPOSED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load() {
        if (this.state == CDOPackageUnit.State.PROXY) {
            EPackage[] ePackages = null;
            ePackages = this.loadPackagesFromGlobalRegistry();
            if (ePackages == null) {
                ePackages = this.packageRegistry.getPackageLoader().loadPackages((CDOPackageUnit)this);
            }
            EPackage[] ePackageArray = ePackages;
            int n = ePackages.length;
            int n2 = 0;
            while (n2 < n) {
                EPackage ePackage = ePackageArray[n2];
                String packageURI = ePackage.getNsURI();
                InternalCDOPackageInfo packageInfo = this.getPackageInfo(packageURI);
                EPackage ePackage2 = ePackage;
                synchronized (ePackage2) {
                    EMFUtil.addAdapter((Notifier)ePackage, (Adapter)packageInfo);
                    EcoreUtil.resolveAll((EObject)ePackage);
                }
                ++n2;
            }
            this.setState(CDOPackageUnit.State.LOADED);
        }
    }

    public void write(CDODataOutput out, boolean withPackages) throws IOException {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0}", new Object[]{this});
        }
        out.writeBoolean(withPackages);
        if (withPackages) {
            CDOModelUtil.writePackage((ExtendedDataOutput)out, (EPackage)this.packageInfos[0].getEPackage(), (boolean)true, (EPackage.Registry)this.packageRegistry);
        }
        out.writeCDOPackageUnitType(this.originalType);
        out.writeLong(this.timeStamp);
        out.writeInt(this.packageInfos.length);
        InternalCDOPackageInfo[] internalCDOPackageInfoArray = this.packageInfos;
        int n = this.packageInfos.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
            out.writeCDOPackageInfo((CDOPackageInfo)packageInfo);
            ++n2;
        }
    }

    public void read(CDODataInput in, InternalCDOPackageRegistry packageRegistry) throws IOException {
        EPackage ePackage = null;
        boolean withPackages = in.readBoolean();
        if (withPackages) {
            ePackage = CDOModelUtil.readPackage((ExtendedDataInput)in, (EPackage.Registry)packageRegistry);
            this.setState(CDOPackageUnit.State.LOADED);
        }
        this.originalType = in.readCDOPackageUnitType();
        this.timeStamp = in.readLong();
        this.packageInfos = new InternalCDOPackageInfo[in.readInt()];
        int i = 0;
        while (i < this.packageInfos.length) {
            this.packageInfos[i] = (InternalCDOPackageInfo)in.readCDOPackageInfo();
            this.packageInfos[i].setPackageUnit((InternalCDOPackageUnit)this);
            ++i;
        }
        if (ePackage != null) {
            this.attachPackageInfos(ePackage);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Read {0}", new Object[]{this});
        }
    }

    public int compareTo(CDOPackageUnit o) {
        return this.getID().compareTo(o.getID());
    }

    public String toString() {
        String fmt = "CDOPackageUnit[id={0}, state={1}, type={2}, originalType={3}, timeStamp={4,date} {4,time}]";
        return MessageFormat.format(fmt, this.getID(), this.getState(), this.getType(), this.getOriginalType(), this.getTimeStamp());
    }

    private void initPackageInfos(EPackage ePackage, List<InternalCDOPackageInfo> result) {
        InternalCDOPackageInfo packageInfo = (InternalCDOPackageInfo)CDOModelUtil.createPackageInfo();
        packageInfo.setPackageUnit((InternalCDOPackageUnit)this);
        packageInfo.setPackageURI(ePackage.getNsURI());
        packageInfo.setParentURI(ePackage.getESuperPackage() == null ? null : ePackage.getESuperPackage().getNsURI());
        packageInfo.setMetaIDRange(this.packageRegistry.getMetaInstanceMapper().mapMetaInstances(ePackage));
        EMFUtil.addAdapter((Notifier)ePackage, (Adapter)packageInfo);
        this.packageRegistry.basicPut(ePackage.getNsURI(), (Object)ePackage);
        result.add(packageInfo);
        for (EPackage subPackage : ePackage.getESubpackages()) {
            this.initPackageInfos(subPackage, result);
        }
    }

    private void attachPackageInfos(EPackage ePackage) {
        InternalCDOPackageInfo packageInfo = this.getPackageInfo(ePackage.getNsURI());
        if (packageInfo != null) {
            EMFUtil.addAdapter((Notifier)ePackage, (Adapter)packageInfo);
        }
        for (EPackage subPackage : ePackage.getESubpackages()) {
            this.attachPackageInfos(subPackage);
        }
    }

    private EPackage[] loadPackagesFromGlobalRegistry() {
        EPackage[] ePackages = new EPackage[this.packageInfos.length];
        int i = 0;
        while (i < ePackages.length) {
            ePackages[i] = EPackage.Registry.INSTANCE.getEPackage(this.packageInfos[i].getPackageURI());
            if (ePackages[i] == null) {
                return null;
            }
            ++i;
        }
        return ePackages;
    }

    public void setType(CDOPackageUnit.Type type) {
        this.type = type;
    }
}

