/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import java.io.Closeable;
import java.io.InputStream;
import org.eclipse.emf.cdo.common.id.CDOIDLibraryDescriptor;
import org.eclipse.emf.cdo.common.id.CDOIDLibraryProvider;
import org.eclipse.emf.cdo.common.id.CDOIDObjectFactory;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.hibernate.IHibernateMappingProvider;
import org.eclipse.emf.cdo.server.hibernate.IHibernateStore;
import org.eclipse.emf.cdo.server.hibernate.internal.id.CDOIDHibernateFactoryImpl;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernatePackageHandler;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStoreAccessor;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.eclipse.emf.cdo.server.internal.hibernate.SystemInformation;
import org.eclipse.emf.cdo.server.internal.hibernate.bundle.OM;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOInterceptor;
import org.eclipse.emf.cdo.spi.common.id.CDOIDLibraryProviderImpl;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.emf.cdo.spi.server.StoreAccessorPool;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;

public class HibernateStore
extends Store
implements IHibernateStore {
    public static final String TYPE = "hibernate";
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HibernateStore.class);
    private static final CDOIDObjectFactory CDOID_OBJECT_FACTORY = new CDOIDHibernateFactoryImpl();
    private static final IDLibraryProvider CDOID_LIBRARY_PROVIDER = new IDLibraryProvider();
    private static final CDOIDLibraryDescriptor CDOID_LIBRARY_DESCRIPTOR = CDOID_LIBRARY_PROVIDER.createDescriptor(CDOIDHibernateFactoryImpl.class.getName());
    private static ThreadLocal<HibernateStore> currentHibernateStore = new ThreadLocal();
    private Configuration hibernateConfiguration;
    private SessionFactory hibernateSessionFactory;
    private HibernatePackageHandler packageHandler;
    private IHibernateMappingProvider mappingProvider;
    private boolean doDropSchema = false;
    private SystemInformation systemInformation;

    public HibernateStore(IHibernateMappingProvider mappingProvider) {
        super(TYPE, HibernateStore.set((Object[])new IStore.ChangeFormat[]{IStore.ChangeFormat.REVISION}), HibernateStore.set((Object[])new IStore.RevisionTemporality[]{IStore.RevisionTemporality.NONE}), HibernateStore.set((Object[])new IStore.RevisionParallelism[]{IStore.RevisionParallelism.NONE}));
        this.mappingProvider = mappingProvider;
        this.packageHandler = new HibernatePackageHandler(this);
        if (TRACER.isEnabled() && mappingProvider != null) {
            TRACER.trace("HibernateStore with mappingProvider " + mappingProvider.getClass().getName());
        }
    }

    public Configuration getHibernateConfiguration() {
        return this.hibernateConfiguration;
    }

    public synchronized SessionFactory getHibernateSessionFactory() {
        if (this.hibernateSessionFactory == null) {
            if (TRACER.isEnabled()) {
                TRACER.trace("Initializing SessionFactory for HibernateStore");
            }
            currentHibernateStore.set(this);
            try {
                this.initConfiguration();
                this.hibernateSessionFactory = this.hibernateConfiguration.buildSessionFactory();
            }
            finally {
                currentHibernateStore.set(null);
            }
        }
        return this.hibernateSessionFactory;
    }

    public CDOIDObjectFactory getCDOIDObjectFactory() {
        return CDOID_OBJECT_FACTORY;
    }

    public CDOIDLibraryDescriptor getCDOIDLibraryDescriptor() {
        return CDOID_LIBRARY_DESCRIPTOR;
    }

    public CDOIDLibraryProvider getCDOIDLibraryProvider() {
        return CDOID_LIBRARY_PROVIDER;
    }

    public HibernateStoreAccessor createReader(ISession session) {
        return new HibernateStoreAccessor(this, session);
    }

    public HibernateStoreAccessor createWriter(ITransaction transaction) {
        return new HibernateStoreAccessor(this, transaction);
    }

    public synchronized int getNextPackageID() {
        return this.packageHandler.getNextPackageID();
    }

    public synchronized int getNextClassID() {
        return this.packageHandler.getNextClassID();
    }

    public synchronized int getNextFeatureID() {
        return this.packageHandler.getNextFeatureID();
    }

    public long getCreationTime() {
        return this.getSystemInformation().getCreationTime();
    }

    public HibernatePackageHandler getPackageHandler() {
        return this.packageHandler;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.packageHandler.activate();
    }

    protected void doDeactivate() throws Exception {
        if (this.hibernateSessionFactory != null) {
            if (TRACER.isEnabled()) {
                TRACER.trace("Closing SessionFactory");
            }
            this.hibernateSessionFactory.close();
            this.hibernateSessionFactory = null;
        }
        if (this.doDropSchema) {
            Configuration conf = this.getHibernateConfiguration();
            SchemaExport se = new SchemaExport(conf);
            se.drop(false, true);
        }
        LifecycleUtil.deactivate((Object)((Object)this.packageHandler), (OMLogger.Level)OMLogger.Level.WARN);
        if (this.doDropSchema) {
            this.packageHandler.doDropSchema();
        }
        super.doDeactivate();
    }

    protected StoreAccessorPool getReaderPool(ISession session, boolean forReleasing) {
        return null;
    }

    protected StoreAccessorPool getWriterPool(IView view, boolean forReleasing) {
        return null;
    }

    protected void reInitialize() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Re-Initializing HibernateStore");
        }
        if (this.hibernateSessionFactory != null) {
            if (!this.hibernateSessionFactory.isClosed()) {
                if (TRACER.isEnabled()) {
                    TRACER.trace("Closing SessionFactory");
                }
                this.hibernateSessionFactory.close();
            }
            this.hibernateSessionFactory = null;
        }
    }

    protected void initConfiguration() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Initializing Configuration");
        }
        InputStream in = null;
        try {
            try {
                this.hibernateConfiguration = new Configuration();
                if (this.mappingProvider != null) {
                    this.mappingProvider.setHibernateStore(this);
                    this.mappingProvider.addMapping(this.hibernateConfiguration);
                }
                if (TRACER.isEnabled()) {
                    TRACER.trace("Adding resource.hbm.xml to configuration");
                }
                in = OM.BUNDLE.getInputStream("mappings/resource.hbm.xml");
                this.hibernateConfiguration.addInputStream(in);
                this.hibernateConfiguration.setInterceptor((Interceptor)new CDOInterceptor());
                this.hibernateConfiguration.setProperties(HibernateUtil.getInstance().getPropertiesFromStore(this));
                if (this.hibernateConfiguration.getProperty("hibernate.hbm2ddl.auto") != null && this.hibernateConfiguration.getProperty("hibernate.hbm2ddl.auto").startsWith("create")) {
                    this.doDropSchema = true;
                    this.hibernateConfiguration.setProperty("hibernate.hbm2ddl.auto", "update");
                } else {
                    this.doDropSchema = false;
                }
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            throw throwable;
        }
        IOUtil.close((Closeable)in);
    }

    public static HibernateStore getCurrentHibernateStore() {
        return currentHibernateStore.get();
    }

    public boolean isFirstTime() {
        return this.getSystemInformation().isFirstTime();
    }

    private SystemInformation getSystemInformation() {
        if (this.systemInformation == null) {
            this.systemInformation = this.getPackageHandler().getSystemInformation();
        }
        return this.systemInformation;
    }

    private static final class IDLibraryProvider
    extends CDOIDLibraryProviderImpl {
        public IDLibraryProvider() {
            this.addLibrary("hibernate-id-v3.jar", org.eclipse.emf.cdo.server.hibernate.internal.id.bundle.OM.BUNDLE);
        }
    }
}

