/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.internal.server.RepositoryConfigurator;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreFactory;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class DBStoreFactory
implements IStoreFactory {
    public String getStoreType() {
        return "db";
    }

    public IStore createStore(Element storeConfig) {
        IMappingStrategy mappingStrategy = this.getMappingStrategy(storeConfig);
        IDBAdapter dbAdapter = this.getDBAdapter(storeConfig);
        DataSource dataSource = this.getDataSource(storeConfig);
        IDBConnectionProvider connectionProvider = DBUtil.createConnectionProvider((DataSource)dataSource);
        return CDODBUtil.createStore(mappingStrategy, dbAdapter, connectionProvider);
    }

    private IMappingStrategy getMappingStrategy(Element storeConfig) {
        NodeList mappingStrategyConfigs = storeConfig.getElementsByTagName("mappingStrategy");
        if (mappingStrategyConfigs.getLength() != 1) {
            throw new IllegalStateException("Exactly one mapping strategy must be configured for DB store");
        }
        Element mappingStrategyConfig = (Element)mappingStrategyConfigs.item(0);
        String mappingStrategyType = mappingStrategyConfig.getAttribute("type");
        IMappingStrategy mappingStrategy = CDODBUtil.createMappingStrategy(mappingStrategyType);
        if (mappingStrategy == null) {
            throw new IllegalArgumentException("Unknown mapping strategy: " + mappingStrategyType);
        }
        Map properties = RepositoryConfigurator.getProperties((Element)mappingStrategyConfig, (int)1);
        mappingStrategy.setProperties(properties);
        return mappingStrategy;
    }

    private IDBAdapter getDBAdapter(Element storeConfig) {
        NodeList dbAdapterConfigs = storeConfig.getElementsByTagName("dbAdapter");
        if (dbAdapterConfigs.getLength() != 1) {
            throw new IllegalStateException("Exactly one dbAdapter must be configured for DB store");
        }
        Element dbAdapterConfig = (Element)dbAdapterConfigs.item(0);
        String dbAdapterName = dbAdapterConfig.getAttribute("name");
        IDBAdapter dbAdapter = DBUtil.getDBAdapter((String)dbAdapterName);
        if (dbAdapter == null) {
            throw new IllegalArgumentException("Unknown DB adapter: " + dbAdapterName);
        }
        return dbAdapter;
    }

    private DataSource getDataSource(Element storeConfig) {
        NodeList dataSourceConfigs = storeConfig.getElementsByTagName("dataSource");
        if (dataSourceConfigs.getLength() != 1) {
            throw new IllegalStateException("Exactly one dataSource must be configured for DB store");
        }
        Properties properties = new Properties();
        Element dataSourceConfig = (Element)dataSourceConfigs.item(0);
        NamedNodeMap attributes = dataSourceConfig.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Attr attribute = (Attr)attributes.item(i);
            properties.put(attribute.getName(), attribute.getValue());
            ++i;
        }
        return DBUtil.createDataSource((Map)properties);
    }
}

