/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.spi.net4j;

import java.text.MessageFormat;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.ILocationAware;
import org.eclipse.net4j.buffer.BufferState;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.buffer.IBufferHandler;
import org.eclipse.net4j.channel.IChannelMultiplexer;
import org.eclipse.net4j.util.concurrent.IWorkSerializer;
import org.eclipse.net4j.util.concurrent.QueueWorkerWorkSerializer;
import org.eclipse.net4j.util.concurrent.SynchronousWorkSerializer;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.spi.net4j.InternalChannel;
import org.eclipse.spi.net4j.InternalChannelMultiplexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Channel
extends Lifecycle
implements InternalChannel {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_CHANNEL, Channel.class);
    private String userID;
    private InternalChannelMultiplexer channelMultiplexer;
    private short id = Short.MIN_VALUE;
    private ExecutorService receiveExecutor;
    private IBufferHandler receiveHandler;
    private IWorkSerializer receiveSerializer;
    private transient Queue<IBuffer> sendQueue;

    public String getUserID() {
        return this.userID;
    }

    @Override
    public void setUserID(String userID) {
        this.userID = userID;
    }

    @Override
    public ILocationAware.Location getLocation() {
        return this.channelMultiplexer.getLocation();
    }

    @Override
    public boolean isClient() {
        return this.channelMultiplexer.isClient();
    }

    @Override
    public boolean isServer() {
        return this.channelMultiplexer.isServer();
    }

    @Override
    public IChannelMultiplexer getMultiplexer() {
        return this.channelMultiplexer;
    }

    @Override
    public void setMultiplexer(IChannelMultiplexer channelMultiplexer) {
        this.channelMultiplexer = (InternalChannelMultiplexer)channelMultiplexer;
    }

    @Override
    public short getID() {
        return this.id;
    }

    @Override
    public void setID(short id) {
        this.checkArg(id != Short.MIN_VALUE, "id == IBuffer.NO_CHANNEL");
        this.id = id;
    }

    @Override
    public ExecutorService getReceiveExecutor() {
        return this.receiveExecutor;
    }

    @Override
    public void setReceiveExecutor(ExecutorService receiveExecutor) {
        this.receiveExecutor = receiveExecutor;
    }

    @Override
    public IBufferHandler getReceiveHandler() {
        return this.receiveHandler;
    }

    @Override
    public void setReceiveHandler(IBufferHandler receiveHandler) {
        this.receiveHandler = receiveHandler;
    }

    @Override
    public Queue<IBuffer> getSendQueue() {
        return this.sendQueue;
    }

    @Override
    public void sendBuffer(IBuffer buffer) {
        this.handleBuffer(buffer);
    }

    @Override
    public void handleBuffer(IBuffer buffer) {
        BufferState state = buffer.getState();
        if (state != BufferState.PUTTING) {
            OM.LOG.warn("Ignoring buffer in state == " + (Object)((Object)state) + ": " + this);
            return;
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Handling buffer: {0} --> {1}", new Object[]{buffer, this});
        }
        if (this.sendQueue == null) {
            if (TRACER.isEnabled()) {
                TRACER.trace("Ignoring buffer because sendQueue == null: " + this);
            }
            buffer.release();
        } else {
            this.sendQueue.add(buffer);
            this.channelMultiplexer.multiplexChannel(this);
        }
    }

    @Override
    public void handleBufferFromMultiplexer(IBuffer buffer) {
        if (this.receiveHandler != null) {
            if (TRACER.isEnabled()) {
                TRACER.format("Handling buffer from multiplexer: {0} --> {1}", new Object[]{buffer, this});
            }
            this.receiveSerializer.addWork((Runnable)this.createReceiverWork(buffer));
        } else {
            buffer.release();
        }
    }

    protected ReceiverWork createReceiverWork(IBuffer buffer) {
        return new ReceiverWork(this, buffer);
    }

    @Override
    public short getBufferCapacity() {
        return this.channelMultiplexer.getBufferCapacity();
    }

    @Override
    public IBuffer provideBuffer() {
        return this.channelMultiplexer.provideBuffer();
    }

    @Override
    public void retainBuffer(IBuffer buffer) {
        this.channelMultiplexer.retainBuffer(buffer);
    }

    public String toString() {
        return MessageFormat.format("Channel[{0}, {1}]", new Object[]{this.id, this.getLocation()});
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.id != Short.MIN_VALUE, "channelID == NO_CHANNEL");
        this.checkState(this.channelMultiplexer, "channelMultiplexer");
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.sendQueue = new ConcurrentLinkedQueue<IBuffer>();
        class ChannelReceiveSerializer
        extends QueueWorkerWorkSerializer {
            ChannelReceiveSerializer() {
            }

            protected String getThreadName() {
                return "ReceiveSerializer-" + Channel.this;
            }
        }
        this.receiveSerializer = this.receiveExecutor == null ? new SynchronousWorkSerializer() : new ChannelReceiveSerializer();
    }

    protected void doDeactivate() throws Exception {
        this.unregisterFromMultiplexer();
        if (this.receiveSerializer != null) {
            this.receiveSerializer.dispose();
            this.receiveSerializer = null;
        }
        if (this.sendQueue != null) {
            this.sendQueue.clear();
            this.sendQueue = null;
        }
        super.doDeactivate();
    }

    protected void unregisterFromMultiplexer() {
        this.channelMultiplexer.closeChannel(this);
    }

    public void close() {
        LifecycleUtil.deactivate((Object)this, (OMLogger.Level)OMLogger.Level.DEBUG);
    }

    public boolean isClosed() {
        return !this.isActive();
    }

    protected static class ReceiverWork
    implements Runnable {
        private final InternalChannel channel;
        private final IBuffer buffer;

        public ReceiverWork(InternalChannel channel, IBuffer buffer) {
            this.channel = channel;
            this.buffer = buffer;
        }

        public void run() {
            IBufferHandler receiveHandler = this.channel.getReceiveHandler();
            if (receiveHandler != null) {
                receiveHandler.handleBuffer(this.buffer);
            } else {
                this.buffer.release();
            }
        }
    }
}

