/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.security;

import java.security.SecureRandom;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.security.IRandomizer;

public class Randomizer
extends Lifecycle
implements IRandomizer {
    public static final String ALGORITHM_SHA1PRNG = "SHA1PRNG";
    public static final String DEFAULT_ALGORITHM_NAME = "SHA1PRNG";
    private String algorithmName = "SHA1PRNG";
    private String providerName;
    private transient SecureRandom secureRandom;

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public boolean nextBoolean() {
        return this.secureRandom.nextBoolean();
    }

    public double nextDouble() {
        return this.secureRandom.nextDouble();
    }

    public float nextFloat() {
        return this.secureRandom.nextFloat();
    }

    public synchronized double nextGaussian() {
        return this.secureRandom.nextGaussian();
    }

    public int nextInt() {
        return this.secureRandom.nextInt();
    }

    public int nextInt(int n) {
        return this.secureRandom.nextInt(n);
    }

    public long nextLong() {
        return this.secureRandom.nextLong();
    }

    public byte[] generateSeed(int numBytes) {
        return this.secureRandom.generateSeed(numBytes);
    }

    public String getAlgorithm() {
        return this.secureRandom.getAlgorithm();
    }

    public synchronized void nextBytes(byte[] bytes) {
        this.secureRandom.nextBytes(bytes);
    }

    public String nextString(int length, String alphabet) {
        int n = alphabet.length();
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < length) {
            int pos = this.nextInt(n);
            char c = alphabet.charAt(pos);
            builder.append(c);
            ++i;
        }
        return builder.toString();
    }

    public synchronized void setSeed(byte[] seed) {
        this.secureRandom.setSeed(seed);
    }

    public void setSeed(long seed) {
        this.secureRandom.setSeed(seed);
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        if (this.algorithmName == null) {
            throw new IllegalStateException("algorithmName == null");
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.secureRandom = this.providerName == null ? SecureRandom.getInstance(this.algorithmName) : SecureRandom.getInstance(this.algorithmName, this.providerName);
        this.secureRandom.setSeed(System.currentTimeMillis());
    }

    protected void doDeactivate() throws Exception {
        this.secureRandom = null;
        super.doDeactivate();
    }
}

