/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om.log;

import java.io.PrintStream;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.log.OMLogHandler;
import org.eclipse.net4j.util.om.log.OMLogger;

public class PrintLogHandler
implements OMLogHandler {
    public static final PrintLogHandler CONSOLE = new PrintLogHandler();
    private PrintStream out;
    private PrintStream err;

    public PrintLogHandler(PrintStream out, PrintStream err) {
        this.out = out;
        this.err = err;
    }

    protected PrintLogHandler() {
        this(IOUtil.OUT(), IOUtil.ERR());
    }

    public void logged(OMLogger logger, OMLogger.Level level, String msg, Throwable t) {
        try {
            PrintStream stream = level == OMLogger.Level.ERROR ? this.err : this.out;
            stream.println(String.valueOf(PrintLogHandler.toString(level)) + " " + msg);
            if (t != null) {
                IOUtil.print(t, stream);
            }
        }
        catch (RuntimeException runtimeException) {}
    }

    public static String toString(OMLogger.Level level) {
        switch (level) {
            case ERROR: {
                return "[ERROR]";
            }
            case WARN: {
                return "[WARN]";
            }
            case INFO: {
                return "[INFO]";
            }
            case DEBUG: {
                return "[DEBUG]";
            }
        }
        throw new IllegalArgumentException("Illegal log level: " + (Object)((Object)level));
    }
}

