/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapper;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.CascadeType;
import org.eclipse.emf.teneo.annotations.pannotation.JoinColumn;
import org.eclipse.emf.teneo.annotations.pannotation.JoinTable;
import org.eclipse.emf.teneo.annotations.pannotation.OneToMany;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.hbannotation.CollectionOfElements;
import org.eclipse.emf.teneo.hibernate.hbannotation.Filter;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedEReference;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedETypeElement;
import org.eclipse.emf.teneo.hibernate.mapper.AbstractAssociationMapper;
import org.eclipse.emf.teneo.simpledom.Element;
import org.eclipse.emf.teneo.util.StoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneToManyMapper
extends AbstractAssociationMapper
implements ExtensionPoint {
    private static final Log log = LogFactory.getLog(OneToManyMapper.class);

    public void process(PAnnotatedEReference paReference) {
        if (this.getOtherSide(paReference) == null) {
            this.processOtMUni(paReference);
        } else {
            this.processOtMBidiInverse(paReference);
        }
    }

    private void processOtMUni(PAnnotatedEReference paReference) {
        CollectionOfElements coe;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating one to many unidirectional mapping for " + paReference));
        }
        HbAnnotatedEReference hbReference = (HbAnnotatedEReference)paReference;
        EReference eref = hbReference.getModelEReference();
        EClass refType = eref.getEReferenceType();
        PAnnotatedEClass referedToAClass = hbReference.getAReferenceType();
        boolean isMap = StoreUtil.isMap((EStructuralFeature)eref) && this.getHbmContext().isMapEMapAsTrueMap();
        Element collElement = this.addCollectionElement((PAnnotatedEStructuralFeature)paReference);
        this.addAccessor(collElement);
        if (hbReference.getImmutable() != null) {
            collElement.addAttribute("mutable", "false");
        }
        if (((HbAnnotatedEReference)paReference).getHbCache() != null) {
            this.addCacheElement(collElement, ((HbAnnotatedEReference)paReference).getHbCache());
        }
        Element keyElement = collElement.addElement("key");
        this.handleOndelete(keyElement, hbReference.getHbOnDelete());
        ArrayList<JoinColumn> jcs = paReference.getJoinColumns() == null ? new ArrayList<JoinColumn>() : paReference.getJoinColumns();
        JoinTable jt = paReference.getJoinTable();
        if (jt != null) {
            this.addJoinTable(hbReference, collElement, keyElement, jt);
        } else {
            this.addKeyColumns(hbReference, keyElement, jcs);
        }
        OneToMany otm = hbReference.getOneToMany();
        if (hbReference.getHbIdBag() != null) {
            log.debug((Object)"Setting indexed=false because is an idbag");
            otm.setIndexed(false);
        }
        if (!otm.isIndexed() && hbReference.getHbIdBag() == null && otm.getMappedBy() != null) {
            collElement.addAttribute("inverse", "true");
        }
        boolean isMapValueIsEntity = false;
        if (hbReference.getHbIdBag() == null && otm.isList()) {
            EClass eclass = eref.getEReferenceType();
            if (hbReference.getMapKey() != null || hbReference.getHbMapKey() != null || hbReference.getMapKeyManyToMany() != null) {
                isMapValueIsEntity = eclass.getEStructuralFeature("value") instanceof EReference;
                this.addMapKey(collElement, paReference);
            } else if (isMap) {
                isMapValueIsEntity = eclass.getEStructuralFeature("value") instanceof EReference;
                this.addMapKey(collElement, hbReference);
            } else if (collElement.getName().compareTo("list") == 0) {
                this.addListIndex(collElement, (PAnnotatedEStructuralFeature)paReference);
            }
        }
        this.addFetchType(collElement, (coe = hbReference.getHbCollectionOfElements()) != null ? coe.getFetch() : otm.getFetch());
        this.addCascadesForMany(collElement, this.getCascades(hbReference.getHbCascade(), (List<CascadeType>)otm.getCascade()));
        EList inverseJoinColumns = jt != null && jt.getInverseJoinColumns() != null ? jt.getInverseJoinColumns() : new ArrayList();
        String targetName = null;
        targetName = otm.getTargetEntity();
        if (targetName == null) {
            targetName = this.getHbmContext().getEntityName(refType);
        }
        if (hbReference.getEmbedded() != null) {
            this.addCompositeElement(collElement, hbReference);
        } else if (isMap && !isMapValueIsEntity) {
            EClass eclass = eref.getEReferenceType();
            EAttribute valueEAttribute = (EAttribute)eclass.getEStructuralFeature("value");
            PAnnotatedEAttribute valuePAttribute = paReference.getPaModel().getPAnnotated(valueEAttribute);
            this.addElementElement(collElement, (PAnnotatedEStructuralFeature)valuePAttribute, this.getColumns((PAnnotatedEStructuralFeature)valuePAttribute), otm.getTargetEntity());
        } else if (!this.isEObject(targetName) && jt != null) {
            Element mtm = this.addManyToMany(hbReference, referedToAClass, collElement, targetName, (List<JoinColumn>)inverseJoinColumns, otm.isUnique());
            this.addForeignKeyAttribute(mtm, (PAnnotatedEStructuralFeature)paReference);
            if (hbReference.getNotFound() != null) {
                mtm.addAttribute("not-found", hbReference.getNotFound().getAction().getName().toLowerCase());
            }
        } else {
            Element otmElement = this.addOneToMany(paReference, referedToAClass, collElement, eref.getName(), targetName);
            this.addForeignKeyAttribute(keyElement, (PAnnotatedEStructuralFeature)paReference);
            if (hbReference.getNotFound() != null) {
                otmElement.addAttribute("not-found", hbReference.getNotFound().getAction().getName().toLowerCase());
            }
        }
        this.mapFilter(collElement, (List<Filter>)((HbAnnotatedETypeElement)paReference).getFilter());
    }

    private void processOtMBidiInverse(PAnnotatedEReference paReference) {
        String targetName;
        OneToMany otm;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating one to many bidirectional inverse mapping for " + paReference));
        }
        Element collElement = this.addCollectionElement((PAnnotatedEStructuralFeature)paReference);
        this.addAccessor(collElement);
        EReference eref = paReference.getModelEReference();
        HbAnnotatedEReference hbReference = (HbAnnotatedEReference)paReference;
        PAnnotatedEClass referedToAClass = hbReference.getAReferenceType();
        if (hbReference.getHbCache() != null) {
            this.addCacheElement(collElement, hbReference.getHbCache());
        }
        if (hbReference.getImmutable() != null) {
            collElement.addAttribute("mutable", "false");
        }
        if (!(otm = paReference.getOneToMany()).isIndexed() && otm.getMappedBy() != null && hbReference.getHbIdBag() == null) {
            collElement.addAttribute("inverse", "true");
        } else {
            log.debug((Object)"Inverse is not set on purpose for indexed collections");
        }
        Element keyElement = collElement.addElement("key");
        this.handleOndelete(keyElement, ((HbAnnotatedEReference)paReference).getHbOnDelete());
        ArrayList<JoinColumn> jcs = paReference.getJoinColumns() == null ? new ArrayList<JoinColumn>() : paReference.getJoinColumns();
        JoinTable jt = paReference.getJoinTable();
        if (jt != null) {
            this.addJoinTable(hbReference, collElement, keyElement, jt);
        } else {
            this.addKeyColumns(hbReference, keyElement, jcs);
        }
        this.addFetchType(collElement, otm.getFetch());
        this.addCascadesForMany(collElement, this.getCascades(hbReference.getHbCascade(), (List<CascadeType>)otm.getCascade()));
        boolean isMap = StoreUtil.isMap((EStructuralFeature)eref) && this.getHbmContext().isMapEMapAsTrueMap();
        boolean isMapValueIsEntity = false;
        if (hbReference.getHbIdBag() == null && otm.isList()) {
            if (hbReference.getMapKey() != null || hbReference.getHbMapKey() != null || hbReference.getMapKeyManyToMany() != null) {
                this.addMapKey(collElement, paReference);
            } else if (isMap) {
                EClass eclass = eref.getEReferenceType();
                isMapValueIsEntity = eclass.getEStructuralFeature("value") instanceof EReference;
                this.addMapKey(collElement, hbReference);
            } else if (otm.isIndexed()) {
                this.addListIndex(collElement, (PAnnotatedEStructuralFeature)paReference);
            }
        }
        if ((targetName = otm.getTargetEntity()) == null) {
            targetName = this.getHbmContext().getEntityName(eref.getEReferenceType());
        }
        if (paReference.getEmbedded() != null) {
            this.addCompositeElement(collElement, paReference);
        } else if (isMap && !isMapValueIsEntity) {
            EClass eclass = eref.getEReferenceType();
            EAttribute valueEAttribute = (EAttribute)eclass.getEStructuralFeature("value");
            PAnnotatedEAttribute valuePAttribute = paReference.getPaModel().getPAnnotated(valueEAttribute);
            this.addElementElement(collElement, (PAnnotatedEStructuralFeature)valuePAttribute, this.getColumns((PAnnotatedEStructuralFeature)valuePAttribute), otm.getTargetEntity());
        } else if (jt != null) {
            EList inverseJoinColumns = jt != null && jt.getInverseJoinColumns() != null ? jt.getInverseJoinColumns() : new ArrayList();
            Element mtm = this.addManyToMany(hbReference, referedToAClass, collElement, targetName, (List<JoinColumn>)inverseJoinColumns, otm.isUnique());
            this.addForeignKeyAttribute(mtm, (PAnnotatedEStructuralFeature)paReference);
            if (hbReference.getNotFound() != null) {
                mtm.addAttribute("not-found", hbReference.getNotFound().getAction().getName().toLowerCase());
            }
        } else {
            Element otmElement = this.addOneToMany(paReference, referedToAClass, collElement, eref.getName(), targetName);
            this.addForeignKeyAttribute(keyElement, (PAnnotatedEStructuralFeature)paReference);
            if (hbReference.getNotFound() != null) {
                otmElement.addAttribute("not-found", hbReference.getNotFound().getAction().getName().toLowerCase());
            }
        }
        this.mapFilter(collElement, (List<Filter>)((HbAnnotatedETypeElement)paReference).getFilter());
    }

    protected Element addOneToMany(PAnnotatedEReference paReference, PAnnotatedEClass referedToAClass, Element collElement, String featureName, String targetEntity) {
        if (this.isEObject(targetEntity)) {
            Element any = collElement.addElement("many-to-any").addAttribute("id-type", "long");
            this.addColumnsAndFormula(any, (PAnnotatedEStructuralFeature)paReference, this.getAnyTypeColumns(featureName, false), false, false);
            return any;
        }
        String tag = "one-to-many";
        if (((HbAnnotatedEReference)paReference).getHbIdBag() != null) {
            tag = "many-to-many";
        }
        if (referedToAClass.isOnlyMapAsEntity() || !this.getHbmContext().forceUseOfInstance(referedToAClass)) {
            return collElement.addElement(tag).addAttribute("entity-name", targetEntity);
        }
        return collElement.addElement(tag).addAttribute("class", this.getHbmContext().getInstanceClassName(referedToAClass.getModelEClass()));
    }

    private Element addManyToMany(HbAnnotatedEReference hbReference, PAnnotatedEClass referedToAClass, Element collElement, String targetEntity, List<JoinColumn> invJoinColumns, boolean unique) {
        Element manyToMany = referedToAClass.isOnlyMapAsEntity() || !this.getHbmContext().forceUseOfInstance(referedToAClass) ? collElement.addElement("many-to-many").addAttribute("entity-name", targetEntity).addAttribute("unique", unique ? "true" : "false") : collElement.addElement("many-to-many").addAttribute("class", this.getHbmContext().getInstanceClassName(referedToAClass.getModelEClass())).addAttribute("unique", unique ? "true" : "false");
        this.addKeyColumns(hbReference, manyToMany, invJoinColumns);
        return manyToMany;
    }

    private Element addCompositeElement(Element collElement, PAnnotatedEReference paReference) {
        Element componentElement = collElement.addElement("composite-element").addAttribute("class", this.getHbmContext().getInstanceClassName(paReference.getEReferenceType()));
        this.getHbmContext().setCurrent(componentElement);
        try {
            PAnnotatedEClass componentAClass = paReference.getAReferenceType();
            this.getHbmContext().processFeatures((List<PAnnotatedEStructuralFeature>)componentAClass.getPaEStructuralFeatures());
        }
        finally {
            this.getHbmContext().setCurrent(collElement.getParent());
        }
        return componentElement;
    }
}

