/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.internal.statistic;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.match.internal.statistic.NameSimilarity;
import org.eclipse.emf.ecore.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceSimilarity {
    private ResourceSimilarity() {
    }

    public static Resource findMatchingResource(Resource resource, List<Resource> candidates) {
        URI referenceURI = resource.getURI();
        if (candidates.size() == 1) {
            return candidates.get(0);
        }
        Resource mostSimilar = null;
        double highestSimilarity = -1.0;
        for (Resource candidate : candidates) {
            String[] candidateSegments;
            String[] referenceSegments;
            double similarity;
            URI candidateURI = candidate.getURI();
            if (!referenceURI.fileExtension().equals(candidateURI.fileExtension()) || !((similarity = ResourceSimilarity.resourceURISimilarity(referenceSegments = referenceURI.trimFileExtension().segments(), candidateSegments = candidateURI.trimFileExtension().segments())) > highestSimilarity)) continue;
            highestSimilarity = similarity;
            mostSimilar = candidate;
        }
        if (highestSimilarity < 0.7) {
            mostSimilar = null;
        }
        return mostSimilar;
    }

    public static double computeURISimilarity(URI reference, URI candidate) {
        double similarity = 0.0;
        if (reference.equals((Object)candidate)) {
            similarity = 1.0;
        } else if (reference.toString().length() == 0) {
            if (candidate.toString().length() == 0) {
                similarity = 1.0;
            }
        } else {
            if (reference.fileExtension() == null || candidate.fileExtension() == null || reference.fileExtension().equals(candidate.fileExtension())) {
                String referenceFragment = reference.fragment();
                String candidateFragment = candidate.fragment();
                String[] referenceSegments = reference.trimFileExtension().segments();
                String[] candidateSegments = candidate.trimFileExtension().segments();
                double segmentSimilarity = ResourceSimilarity.resourceURISimilarity(referenceSegments, candidateSegments);
                double fragmentSimilarity = referenceFragment != null && candidateFragment != null ? ResourceSimilarity.fragmentURISimilarity(referenceFragment, candidateFragment) : 1.0;
                similarity = segmentSimilarity * 0.4 + fragmentSimilarity * 0.6;
            }
            if (similarity > 0.999) {
                similarity = 1.0;
            }
        }
        return similarity;
    }

    private static double fragmentURISimilarity(String reference, String candidate) {
        return NameSimilarity.nameSimilarityMetric(reference, candidate);
    }

    private static double resourceURISimilarity(String[] reference, String[] candidate) {
        String referenceName = reference[reference.length - 1];
        String candidateName = candidate[candidate.length - 1];
        double nameSimilarity = NameSimilarity.nameSimilarityMetric(referenceName, candidateName);
        if (reference.length == 1 || candidate.length == 1 || nameSimilarity > 0.999) {
            return nameSimilarity;
        }
        double equalSegments = 0.0;
        int referenceIndex = reference.length - 2;
        int candidateIndex = candidate.length - 2;
        while (referenceIndex >= 0 && candidateIndex >= 0) {
            if (reference[referenceIndex].equals(candidate[candidateIndex])) {
                equalSegments += 1.0;
            }
            --referenceIndex;
            --candidateIndex;
        }
        return nameSimilarity * 0.6 + equalSegments * 2.0 / (double)(reference.length + candidate.length - 2) * 0.4;
    }
}

