/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.net4j.protocol;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.id.CDOIDLibraryDescriptor;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.util.ServerException;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.internal.cdo.net4j.protocol.CDOTimeRequest;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSessionRequest
extends CDOTimeRequest<CDOSessionProtocol.OpenSessionResult> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, OpenSessionRequest.class);
    private String repositoryName;
    private boolean passiveUpdateEnabled;
    private CDOSessionProtocol.OpenSessionResult result;

    public OpenSessionRequest(CDOClientProtocol protocol, String repositoryName, boolean passiveUpdateEnabled) {
        super(protocol, (short)1);
        this.repositoryName = repositoryName;
        this.passiveUpdateEnabled = passiveUpdateEnabled;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        super.requesting(out);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing repositoryName: {0}", new Object[]{this.repositoryName});
        }
        out.writeString(this.repositoryName);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing passiveUpdateEnabled: {0}", new Object[]{this.passiveUpdateEnabled});
        }
        out.writeBoolean(this.passiveUpdateEnabled);
    }

    @Override
    protected CDOSessionProtocol.OpenSessionResult confirming(CDODataInput in) throws IOException {
        int sessionID = in.readInt();
        if (sessionID == -1) {
            String msg = MessageFormat.format(Messages.getString("OpenSessionRequest.0"), this.repositoryName);
            throw new ServerException(msg);
        }
        if (sessionID == -2) {
            String msg = MessageFormat.format(Messages.getString("OpenSessionRequest.3"), this.repositoryName);
            throw new ServerException(msg);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Read sessionID: {0}", new Object[]{sessionID});
        }
        String repositoryUUID = in.readString();
        if (TRACER.isEnabled()) {
            TRACER.format("Read repositoryUUID: {0}", new Object[]{repositoryUUID});
        }
        long repositoryCreationTime = in.readLong();
        if (TRACER.isEnabled()) {
            TRACER.format("Read repositoryCreationTime: {0,date} {0,time}", new Object[]{repositoryCreationTime});
        }
        boolean repositorySupportingAudits = in.readBoolean();
        if (TRACER.isEnabled()) {
            TRACER.format("Read repositorySupportingAudits: {0}", new Object[]{repositorySupportingAudits});
        }
        CDOIDLibraryDescriptor libraryDescriptor = CDOIDUtil.readLibraryDescriptor((ExtendedDataInput)in);
        if (TRACER.isEnabled()) {
            TRACER.format("Read libraryDescriptor: {0}", new Object[]{libraryDescriptor});
        }
        this.result = new CDOSessionProtocol.OpenSessionResult(sessionID, repositoryUUID, repositoryCreationTime, repositorySupportingAudits, libraryDescriptor);
        CDOPackageUnit[] packageUnits = in.readCDOPackageUnits(null);
        int i = 0;
        while (i < packageUnits.length) {
            this.result.getPackageUnits().add((InternalCDOPackageUnit)packageUnits[i]);
            ++i;
        }
        super.confirming(in);
        this.result.setRepositoryTimeResult(this.getRepositoryTimeResult());
        return this.result;
    }
}

